
%  This version of the parse predicate (added Aug 20) is rogers specific
%  It returns a semantic representation as its argument.  th == Ted Hotzak
%  You give it an atom as a sentence (terminated by a period)
%  The 'th' predicate is designed for use from external functions


th(Sentence, Semantics) :-
  read_sentence_atom(Sentence, Sent),
  clear_edges,                     % clear chart
  set_num_to_one,                  % initialize counter
  init_chart(Sent), !,             % initialize chart
  parse(Sent, _Time, Semantics).

parse(edge([],ISign,C,[],Wordlist,[],N), Wordlist, _Time, Result) :-
  path(ISign,phon,Wordlist),
  complete(ISign),
  writesem(ISign, Result),                      % Write out the semantics
  ( flag(silent) -> true; write(Result) ),
  assert(parse_found(N)).
 
parse(Edge, _, _, _) :-
  spying(Edge,'Processing '),
  fundamental_rule(Edge),      % Compare current edge with chart edges
  find_rules(Edge).            % Compare current edge with grammar rules

parses :- nl, parse, nl, fail.

read_sentence_atom(Atom, Sent) :-
   name(Atom, Chars),
   assert(current_sentence(Chars)),
   read_sent(Sent),
   retract(current_sentence(_)).

get_char(C0) :- 
   flag(silent),
   retract(current_sentence([C|Chars])),  
   lowercase(C,C0),
   assert(current_sentence(Chars)),
   !.

get_char(C0) :- get0(C),  lowercase(C,C0).


clear_edges :- clear_agenda, abolish(edge,7), abolish(edge,3), !.

unknown_word(_,_) :- fail.
