/*

File:			rogers.pl
? Originally by Fred and Carl

Last change date:	Mon Mar 22 09:44:15 1993
By:			Jo Calder

Mon Mar 22 09:44:59 1993 JC Changes for abbreviations

*/

:- dynamic conp/0.

conp :- flag(conp).
lisp :- flag(lisp).

% When called by LISP

grammar([G]) :- grammar_directory(D), concat_atom([D,G], Gram), gram(Gram), !.

% Write out the Semantic Representation in a format that can be used
% by the LISP parser.

%  writesem(_) :- flag(silent),!.

writesem(Sign) :-
  path(Sign, sem:tables, Sem),
  abolish(indexn,1),
  assert(indexn(1)),
  trim(Sem, TSem),
  ( var(TSem) -> TSem = CSem; convert_subtable([[tables,TSem]], CSem)),
  tolisp(CSem),
  nl, write('\'), !.

writesem(Sign, Result) :-
  path(Sign, sem:tables, Sem),
  abolish(indexn,1),
  assert(indexn(1)),
  trim(Sem, TSem),
  ( var(TSem) -> TSem = CSem; convert_subtable([[tables,TSem]], CSem)),
  tolisp(CSem, Result), !.
  

% Write out the lexicon in a format that can be used by the LISP parser.

sendlex :- writelex1('\'), !.   % For sending down a pipe

genlex(F) :-                   % For generating the .lisp file
  assert(flag(lisp)),
  gram(F),
  writelex(F).

writelex(F) :-                 % For writing a file
  abolish(indexn,1),
  assert(indexn(1)),
  name(F,Prefix),
  concat(Prefix,".lisp",L),
  name(File,L),
  tell(File),
  writelex1(' '),
  told.

writelex1(Marker) :-
  entry(Word, Sign, _),
  format('(lex "~w" ',[Word]),		% 25/3/92: ~a changed to ~w by DF 
  trim1(Sign, NewSign),
  tolisp(NewSign),
  write(')'), write(Marker), nl,
  fail.

/*

Additions for abbreviations JC Fri Mar 19 13:38:02 1993

*/

writelex1(Marker) :-
    abbrev_def(Name, Abbs),
    format('(abbrev "~w" ', [Name]),
    writeabbs(Abbs),
    write(')'), write(Marker), nl, 
    fail.
writelex1(_).

/*

Addition for abbreviations

*/

writeabbs(List) :-
    member(A, List),
    format('"~w" ', [A]),
    fail.
writeabbs(_).

trim1(X, Y) :- trim(X, Y), !.

trim(X, X) :- var(X), !.
trim([],[]).
trim([X|Y],[X|NewY]) :- var(X), !, trim(Y,NewY).
trim([[_,Value]|Rest], TrimmedRest) :- 
  var(Value),!,
  trim(Rest, TrimmedRest).
trim([[Attribute,lset(D,X)]|Rest],[[Attribute, Y]|TrimmedRest]) :-
  list2set(D,X,Y),
  trim(Rest, TrimmedRest).
trim([[Attribute,x(X)]|Rest],[[Attribute, X]|TrimmedRest]) :-
  ( var(X) -> X = nil ; true ),
% fix(x(X)),
  trim(Rest, TrimmedRest).
%trim([[type,_]|Rest],TrimmedRest) :- !,  % Don't display type information 
%  trim(Rest, TrimmedRest).               
%trim([[sub,_]|Rest],TrimmedRest) :- !,   % Don't display subtype information
%  trim(Rest, TrimmedRest).
trim([[dtrs,_]|Rest],TrimmedRest) :- !,  % Don't display daughters information.
  trim(Rest, TrimmedRest).
trim([[Attribute,Value]|Rest],[[Attribute, Value]|TrimmedRest]) :-
  atomic(Value),
  trim(Rest, TrimmedRest).
trim([[adjuncts,_]|Rest],TrimmedRest) :- !,
  trim(Rest, TrimmedRest).
trim([[form,Stuff]|Rest],[Wheat|TrimmedRest]) :-
  determine_form(Stuff,Wheat),!,
  trim(Rest, TrimmedRest).
trim([[sem,Value]|Rest], TrimmedRest) :- 
  trim(Value, []), !, % A messy fix to suppress NIL semantics
  trim(Rest, TrimmedRest).
trim([[Attribute,Value]|Rest],[[Attribute, TrimmedValue]|TrimmedRest]) :- 
  atomic(Attribute), !,
  trim(Value, TrimmedValue),
  trim(Rest, TrimmedRest).
trim([X|Y],[NewX|NewY]) :- !, trim(X, NewX), trim(Y, NewY).
trim(X,X).

trimlist([], []).
trimlist([X|Y],[NewX|NewY]) :- !, trim(X, NewX), trimlist(Y, NewY).

% convert nested subtables into a list of subtables

convert_subtable(X,X).  % For Dag valued subtables
/*
convert_subtable([[tables,Tables]],  % For list valued subtables
                 [[tables,[[main,Main],[subtables,NewS]]]]) :-
  path(Tables, main, Main),
 tableconvert(Tables, NewS), !.
%  (Temp == [] -> NewS='NIL'; NewS=Temp).   % modified 13.12.91
*/

convert_subtable(X, X).  % If the above fails, then leave everything unchanged  

tableconvert([[main,_]], []).

tableconvert([[main,_],[subtables,S]], [[[main,Main]]|List]) :-
  path(S, main, Main),
  tableconvert(S, List).

% convert to a LISP list format/

%tolisp(V) :- var(V), !, write('[] ').  % added 13.12.91
tolisp(V) :- var(V), !, write('NIL ').  % added 26.10.92

tolisp(string(S)) :- !, write('"'), write(S), write('"').  % added 26.05.92

tolisp(var(V)) :- !, fix(V), write('!'), write(V).  % added 22.05.92

% added 25.08.92

tolisp(var(V,S)) :- var(V), !, tolisp(S).          
tolisp(var(v(V),S)) :- !, fix(V), write('!'), write(V), write(' '),
   (var(S) -> true; tolisp(S)).

tolisp([]) :- !,
  write('NIL ').   % modified 13.12.91

tolisp([X|Y]) :- !,
  write('( '),
  writelist([X|Y]),
  write(') '), !.

tolisp(X) :- write(X), write(' ').

%  A variation of tolisp that returns a atom corresponding to a LISP lisp

%tolisp(V, '[] ') :- var(V), !.
tolisp(V, 'NIL ') :- var(V), !.

tolisp(string(S), Result) :- !, 
   concat_atom(['"', S, '"'], Result).

tolisp(var(S), Result) :- !, 
   fix(S),
   concat_atom(['!', S], Result).

% added 25.08.92

tolisp(var(V,S), Result) :- var(V), !, tolisp(S,Result).          
tolisp(var(v(V),S),Result) :- var(S), !, 
   fix(V), 
   concat_atom(['!', V], Result).
tolisp(var(v(V),S),Result) :- !, 
   fix(V), 
   tolisp(S, NewS), 
   concat_atom(['!', V, NewS], Result).

tolisp([], 'NIL ') :- !.

tolisp([X|Y], Result) :- !, 
   tolisp(X, AtomX),
   lisplist(Y, AtomX, List),
   concat_atom(['( ', List, ') '], Result).

tolisp(X, Result) :- functor(X,_,_), !,
   X =.. [F|As],
   lisplist(As, F, Res),
   concat_atom([ Res, ' '], Result).

tolisp(X, Result) :- !,
   concat_atom([ X, ' '], Result).


lisplist([], Result, Result).

lisplist([X|Y], First, Result) :-
   tolisp(X, AtomX),
   lisplist(Y, AtomX, AtomY),
   concat_atom([First, AtomY], Result).

% writelist([]).

writelist([]).

writelist([X|Rest]) :-
  tolisp(X),
  writelist(Rest).

% For converting column values into an LF readable form.

fix(X) :- var(X), !, indexgen(X).
fix(x(X)) :- var(X), !, indexgen(X).
fix(_).

indexgen(X) :- retract(indexn(X)), Y is X+1, assert(indexn(Y)), !.

% Constraint functions
% The Constituent Order Principle, references the "order" function 

order(Dtrs, Phonology) :-
  path(Dtrs, head_dtr, Head),       % get the head daughter
  path(Dtrs, comp_dtrs, Comps),     % comp_dtrs 
  path(Dtrs, adj_dtrs, Adjs),       % adj_dtrs 
  path(Dtrs, filler_dtrs, Fillers), % filler_dtrs
  order(Head, Comps, Adjs, Fillers, Phonology), !.

%%%% Head and Comp Daughters
% if it is a lexical head then use the comp_dtr ordering
% get the phonology of the head and have it precede its comps
% otherwise treat head as most oblique complement

order(Head, Comps, [], [], Phonology) :- 
  ( path(Head, syn:loc:lex, plus); path(Head, syn:loc:lex, '+') ) -> 
    order_comps(Comps, Result),          
    path(Head, phon, HeadP),             
    concat(HeadP, Result, Phonology);    
  order_comps([Head|Comps], Phonology).  

%%%% Head and Adjunct Daughter
% get the phonology of the head if it is an adjective or a noun
% have it precede its head otherwise have it follow

order(Head, [], [Adj], [], Phonology)  :- 
  path(Head, phon, HeadP),                 
  path(Adj, phon, AdjP),                   
  ( ( path(Adj, syn:loc:head:maj, n) ; path(Adj, syn:loc:head:maj, a) ; 
      path(Adj, syn:loc:head:maj:n, plus) ) -> 
    concat(AdjP, HeadP, Phonology);      
    concat(HeadP, AdjP, Phonology) ).      

order_comps([], []).
  
order_comps([Sign|Comps], Phonology) :-
  path(Sign, phon, Phon),
  order_comps(Comps, Result),
  concat(Result,Phon,Phonology).


% Collect Referents
%   In a head-complement structure, the referent of the complex structure
%   is that of the head.  When we have a head and a single adjunct, then we
%   use the referent of the adjunct

collect(_, [], [Adj], I) :- !,
  path(Adj, sem:referent, I).

collect(I, _, [], I) :- !.

% The Semantics Principle - based on LISP function "rogers-semantics"

combine(HSem, [], [], Sem) :- !,
  path(HSem, tables, Sem).

combine(HSem, [C|Comps], Adjs, Sem) :- !,
  path(HSem, tables, Sem),
  path(C, sem:tables, CSem),
  combine_tables(Sem, CSem),
  combine(HSem, Comps, Adjs, Sem).

% We allow only a single adjunct at a time
% If the conp flag is set, then the adjunct must have semantic content (i.e. either
% a table or a referent) in order to succeed.  
% If the sem:function feature is unspecified
% then use the combine tables function.  
% If it is 'priority', return the semantics of the adjunct.
% If a head is 'deferred', return the semantics of the adjunct.

combine(HSem, [], [A], Result) :- !,
  path(HSem, tables, Sem),
  path(A, sem:tables, ASem),
  path(A, sem:referent, ARef),                    %  FP Apr 15, 92
  (conp -> \+ (var(ASem), var(ARef)) ; true ),    %  Contribution Principle
  path(A, sem:function, Fun),
  path(HSem, function, HFun),
  combine_tables(Fun, HFun, Sem, ASem, Result).

combine_tables(Fun, HFun, Sem, ASem, Sem) :-  % functions are undefined
  var(Fun), var(HFun), !,
  combine_tables(Sem, ASem).

combine_tables(Fun, _HFun, _, ASem, ASem) :- % when A's sem:function=priority
  \+ var(Fun), Fun=priority, !,
   conp,
   \+ var(ASem).                     %  Contribution Principle II

combine_tables(_Fun, HFun, Sem, _ASem, Sem) :- % when H's sem:function=priority
  \+ var(HFun), HFun=priority, !,
   conp,
   \+ var(Sem).                     %  Contribution Principle II

combine_tables(Fun, _HFun, Sem, _ASem, Sem) :- % when A's sem:function=default
  \+ var(Fun), Fun=default,
  \+ var(Sem),
  path(Sem, main:table, Table),              % and head has a table
  \+ var(Table), !.                          % return head

combine_tables(_, HFun, _, ASem, ASem) :-    % when H's sem:function=default
  \+ var(HFun), HFun=default,
  \+ var(ASem),
  path(ASem, main:table, Table),             % and adjunct has a table
  \+ var(Table), !.                          % return Adjunct

combine_tables(_, _, Sem, ASem, Sem) :-  % when adjunct has no table...
  combine_tables(Sem, ASem).

%  Unify the two semantics if possible... if not possible, look for a
%  common attribute and insert the second as a subtable of the first.

combine_tables(V, T) :- var(V), !, T=V.
combine_tables(T, V) :- var(V), !, T=V.

% Just try a normal unification...

combine_tables(T, T) :- \+ flag(dbunify), !.

% If one of the tables has a variable as a table name, then
% make sure that the columns in this underspecified table are a
% subset of those in the other table (or one of its subtables).
% Done ONLY when the dbunify flag is set.  If both tables don't
% have a table name specified or if both do have a name specified,
% then just unify them.

combine_tables(T, S) :- flag(dbunify), 
  path(T, main:table, TTable),
  path(S, main:table, STable),
  var(TTable),
  ( var(STable) -> S = T; combine_tables_db(S, T) ).

combine_tables(S, T) :- flag(dbunify), 
  path(T, main:table, TTable),
  var(TTable) -> combine_tables_db(S, T); S=T.

% Look for a join

combine_tables(T, S) :-
  path(T, main:columns, TCols),
  path(S, main:columns, SCols),
  join(TCols, SCols, J),
  subtable(T, S).

% 

combine_tables_db(Main, S) :- 
  path(Main, main:columns, MCols),
  path(S, main:columns, SCols),
  get_defined(MCols, MCols1),
  get_defined(SCols, SCols1),
  subset(SCols1, MCols1),
  Main = S.                   % Now it is safe to unify...

combine_tables_db(Main, S) :- 
  path(Main, subtables, Sub),
  \+ var(Sub),
  combine_tables_db(Sub, S).

% Is the first list a subset of the second list, or vice versa

subset([], _).
subset([X|Rest], Set) :- member(X, Set), subset(Rest, Set).

% join- is given 2 lists of AV pairs corresponding to columns and their values
% A column is "defined" if it has something instantiated as its value.
% If they share two instantiated columns, then unify the values. 
% "J" is the joined AV pair (I don't know if we'll need it).

join(X, Y, J) :-
  get_defined(X, NewX),
  get_defined(Y, NewY),
  join_aux(NewX, NewY, J), !.

% join_aux([], _, _) :- nl, write('Call PathFinder'), nl, !, fail.

join_aux([X|_], Y, X) :- member(X, Y), !.
join_aux([_|Rest], Y, J) :- join_aux(Rest, Y, J).

get_defined([],[]).
get_defined([[_,V]|Rest], NewRest) :- var(V), !, get_defined(Rest, NewRest).
get_defined([X|Rest], [X|NewRest]) :- get_defined(Rest, NewRest).

% subtable(M,S) - install S as the last subtable of M

subtable(M, S) :-
  path(M, subtables, V),
  ( var(V) -> V=S; subtable(V, S) ).


get_dtr(head_dtr, Sign, Dtr) :- path(Sign, dtrs:head_dtr, Dtr), !.
get_dtr(Which, Sign, []) :- path(Sign, dtrs:Which, []).
get_dtr(Which, Sign, [A]) :- path(Sign, dtrs:Which, [A]).
get_dtr(Which, Sign, [A,B]) :- path(Sign, dtrs:Which, [A,B]).


% Transforms phrasal sign into the form accepted by TreeTool
% this version expects the following attributes:
%	syn:loc:subcat
%	syn:loc:head
%	syn:non_loc:inher
%	sem:cont
% Could be modified!

tugtree(PSign,Tree) :-
  path(PSign,phon,Phon),
  give_head(PSign,Head),
  abbrev_head(Head,AHead),
  path(PSign,dtrs,Dtrs),
  tugdtrs(Dtrs,Subtrees),
  path(PSign,syn:loc:subcat,SubCat),
  abbrev_subcat(SubCat,ASub),
  path(PSign,sem:function, Pri),         
  path(PSign,sem:tables, Tabs),
  (var(Tabs) -> Tab=Tabs; path(Tabs,main:table, Tab)),
  Tree =.. [tree, Phon:AHead:ASub:Pri:Tab | Subtrees],
  !.

