:- dynamic flag/1.

% To set and clear flags

+ X :- flag(X) -> true; assert(flag(X)).
- X :- flag(X) -> retract(flag(X)); true.

% utilities for HPSG system

cputime(T) :- statistics(runtime,[T,_]).      % System Dependent
%cputime(T) :- T is cputime.

% reverse a list

reverse(A,B) :- reverse(A,[],B), !.

reverse([],L,L).
reverse([H|Rest],L,Reverse) :-  reverse(Rest,[H|L],Reverse).

% concatenation (append)

concat_atom(Atoms, Atom) :- concat_atoms1(Atoms, [], List),  name(Atom, List).

concat_atoms1([], List, List).		% Rogers specific?

concat_atoms1([Atom|L], ListIn, ListOut) :-
  name(Atom, List),
  concat(ListIn, List, Tmp),
  concat_atoms1(L, Tmp, ListOut).

concat([],A,A).
concat([A|Rest],List,[A|Newlist]) :-
  concat(Rest,List,Newlist).
 
member(X, [X|_]).
member(X, [_|Rest]) :- member(X, Rest).

%  Predicates which depend on the low level representation of DAGs.
%  Lookup a lexical entries corresponding to this word, and return AVM.
 
%  to handle unknown words... if there is no entry for a word, then use
%  the lexical type(s) for unknown words

lookup(+EName, Sign, Cs):-!,  % signs with empty phonology
   entry(+EName, Sign, Cs).

lookup(Word, Sign, Constraints) :- 
   entry(Word, Sign, Constraints). 

/*
lookup(Phrase, [_dtrs,[phon, Phrase]|Sign], Constraints) :-  % lexical phrases
  Phrase = [_,_|_],                                          % at least 2 words
  entry(Phrase, [_dtrs,[phon, [Phrase]]|Sign], Constraints). % Rogers specific
*/

lookup(Word, Sign, Constraints) :-
  \+ entry(Word, _, _),
  compound(Word,[Word]),                % not a compound word
  writemessage('Unknown word: ', Word),
  unknown_word(Sign, Constraints),
  path(Sign, phon, [Word]).

get_dtr(Which, Sign, Dtr) :- path(Sign, dtrs:Which, Dtr).

% get_all_dtrs(+Sign, -Head, -Comps, -Adjs, -Fillers).

get_all_dtrs([[dtrs, [[head_dtr,H], [comp_dtrs,C], [adj_dtrs,A],
                      [filler_dtrs,F]
                     ]
              ]|_
             ], H, C, A, F).

% path(Sign,Path,Value)
% For feature matrices (signs) ... if no such feature
%   exists, or if the matrix is undefined, then FAIL
% MODIFIED SEPT 31:  Allow "first" and "rest" to be used to 
% access elements of lists

path(Var, Path, _) :- 
  var(Var), !, 
  nl, write('Taking path of uninstantiated matrix: '), write(Path), nl, trace,
  fail.

path([], Path, _) :- !, 
  nl, write('Undefined feature in path: '), write(Path), nl, trace,
  fail.

path([[F,V]|_], F:Rest, Return) :- !, path(V, Rest, Return).
path([[F,V]|_], F, Return) :- !, V=Return.
path([_|OtherValues], Path, Return) :- path(OtherValues,Path,Return).

% To examine the processing of a specific edge

spying(edge(_,_,_,_,_,_,N),Message) :- 
  edge_spy(N) -> nl, write(Message), write(N), nl, trace
  ; true.

look(N) :- assert(edge_spy(N)).
nolook(N) :- retractall(edge_spy(N)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Reconstruct a Phrasal Sign

makePSign(A, B, C) :- flag(phrasal) -> make_psign(A, B, C) ; true.

make_psign(_,[],_) :- !.

make_psign(PSign,[active(A),inactive(I)],Ex) :-
  edge([Sign|Ex], PSign, Components, Cons, _, _, A),
  make_psign(PSign, Components, [Sign|Ex]),
  edge(_, Sign, C, _, _, _, I),
  make_psign(Sign, C, []), 
  process(Cons,_,Ex),!.

make_psign(PSign, [rule(R),N], Expects) :-
  edge(E, HSign, Components, _, _, _, N),
  rule(R, PSign, Constraints),
  path(PSign, dtrs:head_dtr, HSign),
  make_expects(PSign, Constraints, _, Expects),
  make_psign(HSign, Components, E), !.

make_psign(_, _, _).   % If it fails, just leave everything as it was

writePSign(Sign, Constit, Num, Time) :- 
  flag(phrasal) -> 
    assert(edge(Sign, Constit, Num)),
    writetime('PSign Reconstructed at ', Time)
  ; true.

% To convert set representations into lists - based on Mellish

set2list(Name, Set, lset(Name,List)) :-
  domain(Name, Domain),
  template(Domain, List),
  build_list(Domain, Set, List).

template(Domain, [0|List]) :- template_aux(Domain, List).

template_aux([], []) :- !.
template_aux([_|Rest], [_|T]) :- template_aux(Rest, T).

build_list([], _, [1]).

build_list([D|Ds], Elements, [X,Y|Rest]) :- 
   (member(D,Elements) -> true; X=Y),
   build_list(Ds, Elements, [Y|Rest]).

% And back

list2set(Name, List, Set) :-
  domain(Name, Domain),
  build_set(Domain, List, Set).

build_set([], _, []).

build_set([_|Ds], [X,Y|Rest], Set) :- X == Y, !, 
   build_set(Ds, [Y|Rest], Set).

build_set([D|Ds], [_,Y|Rest], [D|Set]) :- 
   build_set(Ds, [Y|Rest], Set).

