:- eccs_new_variable(parser, parse, parsing, run, 
			"The name of the parser to be used for analyzing input").

eccs_user_parser_spec(parse, 
	[prehook = retractall(eccs_last_sentence_analysis(_, _, _)), 
	 fs_drawer = mike_draw_fs,
	 tree_drawer = mike_draw_tree_from_parse]).

parse(_, String, Results) :-
    eccs_post_last_sentence(String),
    findall(Result, parse(String, 0, [], [Result]), Results).

go(L) :-
  parse(L,0,[],X),
  pdag(X), nl, nl,
  fail.
go(_).

ta(L) :-
  parse(L,0,[],[X]),
  findunifs(X,Y),
  strip(Y,Z),
  draw_avm(Z), nl.

parse([],_,[X],[X]).
parse([H|T],Num0,List0,List) :-
  Num is Num0 + 1,
  lexicon(H,Num,Sign),
  reduce(Sign,List0,List1),
  parse(T, Num, List1, List).
  
reduce(Sign,List0,List) :-
  rule(Mom, Cons),
  Mom <=> [dtrs = [ all = Kids |_]|_],
  Cons,
  find_kids(Sign,List0,List1,Kids),
  build_mom(Mom,Kids),
  reduce(Mom,List1,List).
reduce(Sign,List,[Sign|List]).

find_kids(found,List,List,[]).
find_kids(Sign,List0,List,[Kid|Kids]) :-
  Sign <=> Kid,
  find_kids(found,List0,List,Kids).
find_kids(Sign,List0,List,[Kid|Kids]) :-
  delete(Element,List0,List1),
  Element <=> Kid,
  find_kids(Sign,List1,List,Kids).

delete(F, [F|X], X).
delete(F, [E|X], [E|Y]):-
        delete(F, X, Y).

lexicon(Word, Pos, Cat) :-
    eccs_get_from_database(lexical_entry, Word, Cat),
    get_pos(Cat, Pos, Pos).

get_pos(Cat, Beg, End):-
        Cat <=> [pos = [beg = Beg, end = End|_]|_].


rule(Mom, Cons) :-
    eccs_get_from_database(rule, _Name, rule(Mom, Cons)).

