%:- compile('~/Pleuk/Code/ppostscript.pl').

/*

24/6/91 JC

Altered printing of type information to be as Postscript literals 
rather than strings

*/

/*
ps_print(Dag, Tab, Col)						     

Tab over Tab spaces and then print Dag.  Col is the running column count.
Dag is the result of findunifs/2 and so is ground.
*/

ps_pp_print(R) :-
	ps_print(R, 0, 0), !.

ps_print('$UNINSTANTIATED', _, _) :- !,
    write('['), 
    eccs_ps_literal(uninstantiated),
    write(']').
ps_print('$NULL_SEQ', _, _) :- !,
    write('['),
    eccs_ps_literal(sequence),
    write('[]]').
ps_print(X, _, _) :-
        atomic(X), !,
	ps_write_atomic(X).
ps_print(X, _, _) :-
        var(X), !,
	ps_write_atomic(X).
ps_print('$NEG'(N), Tab, _) :- !,		% assume negations are atomic
    tab(Tab),
    concat('!', N, Str),
    eccs_ps_quote(Str).
ps_print('$INDEX'(N), Tab, _) :- !,
%	tab(Tab),
	ps_write_index(N).
ps_print([L= V|T], Tab, Col) :- !,
        write('['),
	eccs_ps_literal(avm),
        ps_print_av_pairs([L=V|T], Tab, Col),
	write(']').
ps_print('$INDEX'(N, [L=V|T]), Tab, Col) :- !,
%	tab(Tab),
	write('['),
	eccs_ps_literal(tagged_avm),
	eccs_ps_quote(N),
	prlength(N, I),
	NewCol is Col + 1 + I,
	ps_print_av_pairs([L=V|T], 0, NewCol),
	write(']').
ps_print('$INDEX'(N, L), Tab, Col) :- !,
	ps_print(L, Tab, Col).
ps_print([H|T], Tab, Col) :-
        write('['),
	eccs_ps_literal(sequence),
	write('['),
        ps_print_sequence([H|T], Tab, Col),
	write(']]').

ps_print_av_pairs([Label = Val|T], Tab, Col) :- !,
	write('['),
	ps_print_feature_structure([Label = Val|T], Tab, Col),
	write(']').

ps_print_feature_structure([Label = Val|T], Tab, Col) :-
%	tab(Tab), 
	NCol is Col + 1,
	ps_print_feature_structure0([Label = Val|T], 0, NCol).

ps_print_feature_structure0([Label = Val], Tab, Col) :- !,
%	tab(Tab), 
	write('['),
	eccs_ps_quote(Label), 
	prlength(Label, N),
	NTab is Col + N + 3,
	ps_print(Val, 0, NTab),
	write(']').
ps_print_feature_structure0([Label = Val|T], Tab, Col) :-
	prlength(Label, N),
	NTab is Col + N + 3,
	ps_print_feature_structure0(T, Col, Col),
%	tab(Tab), 
	write('['), eccs_ps_quote(Label), 
	ps_print(Val, 0, NTab),
	write(']'),
	nl.

ps_print_sequence([], _Tab, _Col) :- !.
ps_print_sequence('$END_SEQ', _Tab, _Col) :- !.
ps_print_sequence(['$INDEX'(M)|'$INDEX'(N)], _Tab, _Col) :-
    ps_print('$INDEX'(M), Tab, Col),
    ps_print('$INDEX'(N), Tab, Col).
ps_print_sequence([H|T], Tab, Col) :-
%	tab(Tab), 
	NCol is Col + 1,
	ps_print(H, 0, NCol),
	ps_print_sequence(T, 0,NCol).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ps_mike_print_lexical_entry(lexical_entry, Orth, Dag) :-
    switch_to_graphics_stream(ps_mike_print_lexical_entry1(lexical_entry, Orth, Dag)).

ps_mike_print_lexical_entry1(lexical_entry, Orth, Dag) :-
    pdag(Dag), nl,
    eccs_string_to_postscript(" set_avm"),
    eccs_concat('lexical entry: ', Orth, Str),
    eccs_ps_quote(Str),
    eccs_string_to_postscript(" set_caption"),
    nl,
    eccs_string_to_postscript(" draw_avm_main"), nl, nl.

ps_mike_print_template(template, Name, temp(Dag, _)) :-
    switch_to_graphics_stream((
    	pdag(Dag), nl,
	eccs_string_to_postscript(" set_avm"),
	eccs_concat('Template:  ', Name, Str),
	eccs_ps_quote(Str),
	eccs_string_to_postscript(" set_caption"),
	nl,
	eccs_string_to_postscript(" draw_avm_main"), nl, nl)).

ps_mike_print_grammar_rule(lp_statement, Name, prec(F0, X0, Y0)) :-
       ps_mike_print_lp1(Name, [F0, X0, Y0]).

ps_mike_print_lp1(Name, [F0, X0, Y0]) :-
    switch_to_graphics_stream((
    	findunifs(F0, VarTree, FRoot),
	findunifs(X0, VarTree, XRoot),
	findunifs(Y0, VarTree, YRoot),
	unfold_value_tree(VarTree),
	rename_indexes([FRoot, XRoot, YRoot]),
	ps_print([FRoot, XRoot, YRoot], 0, 0),
	    eccs_string_to_postscript(" set_avm"),
	    eccs_concat('LP statement ', Name, Str),
	    eccs_ps_quote(Str),
	    eccs_string_to_postscript(" set_caption"),
	    nl,
	    eccs_string_to_postscript(" draw_avm_main"), nl, nl)),
    eccs_do_menu(confirm).


ps_mike_print_grammar_rule(rule, Name, rule(Mom, _Cons)) :-
    switch_to_graphics_stream((
            pdag(Mom), nl,
	    eccs_string_to_postscript(" set_avm"),
	    eccs_concat('Grammar rule: ', Name, Str),
	    eccs_ps_quote(Str),
	    eccs_string_to_postscript(" set_caption"),
	    nl,
	    eccs_string_to_postscript(" draw_avm_main"), nl, nl)),
    eccs_do_menu(confirm).


ps_mike_draw_fs(_, Dag) :-
    	eccs_string_to_postscript("/theavm "),
 	switch_to_graphics_stream((pdag(Dag), nl, 
	write('def'), nl,
	write('draw_avm_main'), nl)).


/*
eccs_default_printing_routine(_, Dag) :-
	switch_to_graphics_stream((pdag(Dag), nl)). 
*/
ps_write_atomic(X) :-
    write('['),
    eccs_ps_literal(atomic),
    eccs_ps_quote(X),
    write(']').

ps_write_index(N) :-
    write('['),
    eccs_ps_literal(tag),
    eccs_ps_quote(N), 
    write(']').

/*

Moved to Pleuk/Code/ppostscript.pl

eccs_ps_quote(X) :-
    write('('),
    write(X), 
    write(')'), nl.

eccs_ps_literal(X) :-
    write('/'),
    write(X),
    write(' ').


switch_to_graphics_stream(Goal) :-
    	eccs_sys_graphics_stream(S),
	current_output(X),
	set_output(S),
	(call(Goal); true), !,
	flush_output(S),
	set_output(X).

postscript_available :-
	eccs_sys_graphics_stream(_).

*/
