/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('q_subsumes.pl', '1.1', 1').

*/
% eccs_q_subsumes is a version of su (the basic string unification
% algorithm) which is optimised and specialised to do subsumption
% checking.  In particular, this means that we must build in a special
% test in the first predicate below to handle the fact that this
% routine is called only after the second argument has been ground.
% It also means that the clause which invokes equate3 in su is
% eliminated and that instead of merging constraint lists, the
% constraint list of the first argument must subsume the constraint
% list of the second argument.

eccs_q_subsumes(X,Y) :-
	eccs_sys_var(X), !,
	X = V:C,
	eccs_q_subsumes(X,Y).
eccs_q_subsumes(X,Y) :-
	eccs_sys_var(Y), !,
	Y = V:C,
	eccs_q_subsumes(X,Y).
eccs_q_subsumes(X:C,Y) :- !,
	eccs_q_subsumes([X:C],Y).
eccs_q_subsumes(X,Y:C) :- !,
        eccs_q_subsumes(X,[Y:C]).
eccs_q_subsumes(X,'$VAR'(N)) :- !,
        eccs_q_subsumes(X,['$VAR'(N):C]).
eccs_q_subsumes(X,Y) :-
	eccs_q_subsumes0(X,Y).

eccs_q_subsumes0([],[]).
eccs_q_subsumes0(X,[Y0|T]) :-
  xnonvar(Y0), Y0 = 0:_, !,
  eccs_q_subsumes0(X,T).
eccs_q_subsumes0([X0|T],Y) :-
  xnonvar(X0), X0 = 0:_, !,
  eccs_q_subsumes0(T,Y).
eccs_q_subsumes0(X,[Y0|T]) :-
  xnonvar(Y0), Y0 = [_|_]:_, Y0 = YL:_, !,
  eccs_append(YL,T,Y),
  eccs_q_subsumes0(X,Y).
eccs_q_subsumes0([X0|T],Y) :-
  xnonvar(X0), X0 = [_|_]:_, X0 = XL:_, !,
  eccs_append(XL,T,X),
  eccs_q_subsumes0(X,Y).
eccs_q_subsumes0([S1|S],[T1X:T1C|T]) :-
  \+ dvar(S1),
  S1 = [S11,S12]:_,
  S11 = S11X:S11C,
  eccs_safe_unify(S11X, T1X),
  eccs_q_subsumes_constraints(S11C,T1C),
  eccs_q_subsumes0([S12|S],T),
  \+ ( xnonvar(S12), S12 = 0:_ ).
eccs_q_subsumes0([S1:CS|S],[T1:TS|T]) :-
  eccs_safe_unify(S1, T1),
  eccs_q_subsumes_constraints(CS,TS),
  eccs_q_subsumes0(S,T).
eccs_q_subsumes0([X0|X],Y) :-
  xvar(X0),
  X0 = 0:C,
  eccs_q_ck_con(C),
  eccs_q_subsumes0(X,Y).

% note:  the third last clause above could be made much more efficient
% by adding the constraint that S12 \= 0:_ before the call to
% eccs_q_subsumes0 is made.  However, this would add an extra phantom
% constraint that doesn't exist in the original term.  This constraint
% is only used to prevent executing both the third last and second
% last clauses.  A similar strategy could be profitably exploited in
% equate2 and equate3 in qsu.pl.  This results in considerable
% speedups but in some cases of co-instantiation involving the second
% argument, this can result in incorrect results as well.  This point
% should be investigated in more depth.

% eccs_q_subsumes_constraints(X,Y) is true if the constraints in X subsume
% the constraints in Y.  X and Y are constraint list stacks as
% described elsewhere.  This code could be optimised greatly since the
% routines reference here were written with a far more general
% approach in mind.

eccs_q_subsumes_constraints(X,Y) :-
  find_top(X,XC0,_),
  find_top(Y,YC0,_),
  eccs_q_morph_check_constraints(XC0,XC),
  eccs_q_morph_check_constraints(YC0,YC),
  separate_neg_and_disj(XC,XN,XD),
  separate_neg_and_disj(YC,YN,YD),
  eccs_u_sub_neg(XN,YN),
  eccs_u_sub_disj(XD,YD).

