/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('qbuildnetwork.pl', '1.1', 1').

*/

eccs_q_build_net(or(Network)) :-
	eccs_q_left_most_nodes(N),
	eccs_q_build0(N, Network).

eccs_q_build0([], []).
eccs_q_build0([Node|Rest],  [requires(Node, Dimensions)|Rs]) :-
	eccs_q_has_requirement(Node, Req, []),
	eccs_q_build1(Req, Dimensions),
	eccs_q_build0(Rest, Rs).
eccs_q_build0([Node|Rest],  [requires(Node, nothing)|Rs]) :-
	eccs_q_terminal(Node),
	eccs_q_build0(Rest, Rs).

eccs_q_build1([], []).
eccs_q_build1([Req|Rest], [fulfils(Req, Fuls, Default)|Rs]) :-
	default(Req, Default),
	eccs_q_fulfils(Req, Fs),
	eccs_q_build0(Fs, Fuls),
	eccs_q_build1(Rest, Rs).
eccs_q_build1([Req|Rest], [fulfils(Req, Fuls, nothing)|Rs]) :-
	\+ default(Req, _Default),
	eccs_q_fulfils(Req, Fs),
	eccs_q_build0(Fs, Fuls),
	eccs_q_build1(Rest, Rs).
