/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('qnumbervars.pl', '1.1', 1').

*/
% this is a special version of numbervars which is used as part of the
% subsumption checking code.  its major feature is that it does not
% instantiate variables in constraint list stacks (signalled by ":").

eccs_q_numbervars('$VAR'(M), M, N) :- !,
	eccs_succ(M, N).
eccs_q_numbervars(Atomic, M, M) :-
	eccs_sys_atomic(Atomic), !.
eccs_q_numbervars(V:C, M, N) :-
	eccs_q_numbervars(V, M, N).
eccs_q_numbervars(Term, M, N) :-
	eccs_sys_functor(Term, _, Arity),
	'eccs_$q_numbervars'(0, Arity, Term, M, N).

'eccs_$q_numbervars'(A, A, _, N, N) :- !.
'eccs_$q_numbervars'(Am, Arity, Term, M, N) :-
    	eccs_succ(Am, An),
	eccs_sys_arg(An, Term, Arg),
	eccs_q_numbervars(Arg, M, K), !,
	'eccs_$q_numbervars'(An, Arity, Term, K, N).
