% eccs_strip takes a term which has string variables of the form X:C where
% C is a constraint list stack and returns a term where the constraint
% stacks have been simplified to contain only the top element of the
% original stack.

eccs_strip(Var,Var) :-
	eccs_sys_var(Var), !.
eccs_strip(Atomic,Atomic) :-
	eccs_sys_atomic(Atomic), !.
eccs_strip(X0:C0,X:[C|Next]) :- !,
	eccs_strip(X0,X),
	find_top(C0,C1,Next),
	eccs_q_morph_check_constraints(C1,C).
eccs_strip(Term0,Term) :-
	Term0 =.. [Functor|Args0],
	eccs_strip0(Args0,Args),
	Term =.. [Functor|Args].

eccs_strip0([],[]).
eccs_strip0([H0|T0],[H|T]) :-
	eccs_strip(H0,H),
	eccs_strip0(T0,T).
