% a unification algorithm for an associative function with identity
% and constraints on variables.

% this algorithm is based on siekmann's algorithm for unification for
% an associative function without identity.

% this version is complete and correct but definitely not minimal.
% (It is also not guaranteed to terminate.) It also incorporates the
% value disjunctive and negative constraints directly in the term structure.
% It uses open-ended lists in a way similar to Eisele and Doerre's
% merge predicate to allow merging of constraint lists.  All variables
% are encoded as a term of the form X:C where X corresponds to the
% original variable conceptually and C is the list of constraints on
% X.  Unfortunately, whenever we merge constraint stacks we must
% search the stack for the top.



/* The first clause added by Jo Wed Apr 27 15:58:05 1988 */

su(X,Y) :-
	X == Y, !.
su(X,Y) :-
	eccs_sys_var(X), !,
	X = V:C,
	su(X,Y).
su(X,Y) :-
	eccs_sys_var(Y), !,
	Y = V:C,
	su(X,Y).
su(X:C,Y) :- !,
	su([X:C],Y).
su(X,Y:C) :- !,
        su(X,[Y:C]).
su(X,Y) :-
	equate(X,Y).

equate([],[]).
equate(X,[Y0|T]) :-
  xnonvar(Y0), Y0 = 0:_, !,
  equate(X,T).
equate([X0|T],Y) :-
  xnonvar(X0), X0 = 0:_, !,
  equate(T,Y).
equate(X,[Y0|T]) :-
  xnonvar(Y0), Y0 = [_|_]:_, Y0 = YL:_, !,
  eccs_append(YL,T,Y),
  equate(X,Y).
equate([X0|T],Y) :-
  xnonvar(X0), X0 = [_|_]:_, X0 = XL:_, !,
  eccs_append(XL,T,X),
  equate(X,Y).
equate([S1|S],[T1|T]) :-
  equate1([S1|S],[T1|T]).
equate([S1|S],[T1|T]) :-
  \+ dvar(S1), S1 \== T1,
  equate2([S1|S],[T1|T]).
equate([S1|S],[T1|T]) :-
  \+ dvar(T1), S1 \== T1,
  equate3([S1|S],[T1|T]).
equate([S1|S],T) :-
  xvar(S1), S1 = 0:C,
  eccs_q_ck_con(C),			% is there a constraint prohibiting 0?
  equate(S,T).
equate(S,[T1|T]) :-
  xvar(T1), T1 = 0:C,
  eccs_q_ck_con(C),			% is there a constraint prohibiting 0?
  equate(S,T).

equate1([S1:CS|S],[T1:TS|T]) :-
    eccs_safe_unify(S1, T1),
    eccs_q_merge_constraints(CS,TS),
    equate(S,T).

equate2([S1|S],[T1X:T1C|T]) :-
  S1 = [S11,S12]:_,
  S11 = S11X:S11C,
  eccs_safe_unify(S11X, T1X),
  eccs_q_merge_constraints(S11C,T1C),
  equate([S12|S],T),
  \+ ( xnonvar(S12), S12 = 0:_ ).

equate3([S1X:S1C|S],[T1|T]) :-
  T1 = [T11,T12]:_,
  T11 = T11X:T11C,
  eccs_safe_unify(T11X, S1X),
  eccs_q_merge_constraints(T11C,S1C),
  equate(S,[T12|T]),
  \+ ( xnonvar(T12), T12 = 0:_ ).


% cvar(X) is true if X is a constrained variable.

cvar(X:C) :-
  eccs_sys_var(X),
  constrained(X:C).

% cnonvar(X) is true if X is an atom (i.e., a constrained nonvar).

cnonvar(X:C) :-
  eccs_sys_nonvar(X),
  constrained(X:C).

% xnonvar(X) is true if X is ground (constrained or unconstrained).

xnonvar(X:C) :-
  eccs_sys_nonvar(X).

% xvar(X) is true if X is a variable (constrained or unconstrained).

xvar(X:C) :-
  eccs_sys_var(X).

% uvar(X) is true if X is an unconstrained variable.

uvar(X:C) :-
  eccs_sys_var(X),
  unconstrained(X:C).

% unonvar(X) is true if X is unconstrained and ground.  (unused)

unonvar(X:C) :-
  eccs_sys_nonvar(X),
  unconstrained(X:C).

% unconstrained(X) is true if X is unconstrained.

unconstrained(X:C) :-
  find_top(C,[],_).

% constrained(X) is true if X is constrained.  (unused)

constrained(X:C) :-
  \+ find_top(C,[],_).

% disjunctive(X) is true if X has a disjunctive constraint only.

disjunctive(X:C) :-
  find_top(C,[c(_,or(_,_))],_).

% dvar(X) is true if X is a variable with a disjunctive constraint.

dvar(X:C) :-
  eccs_sys_var(X),
  disjunctive(X:C).

% negative(X) is true if X has a negative constraint only.

negative(X:C) :-
  find_top(C,[c(_,not(_,_))],_).

% nvar(X) is true if X is a variable with a negative constraint.

nvar(X:C) :-
  eccs_sys_var(X),
  negative(X:C).

% find_top returns the top constraint list of the constraint list
% stack and the uninstantiated variable at the top of the stack.

find_top(List,Top,Next) :-
  find_top(List,[],Top,Next).

find_top(X,Top,Top,X) :-
  eccs_sys_var(X), !.
find_top([H|T],CTop,Top,Next) :-
  \+ eccs_sys_var(H), !,
  find_top(T,H,Top,Next).

% eccs_q_ck_con checks that the constraint list at the top of the
% constraint list stack is satisfiable and adds another element to the
% top of the stack if one of the constraints has been satisfied (i.e.,
% become ground).

eccs_q_ck_con(C0) :-
  find_top(C0,Top0,C1),
  eccs_q_morph_check_constraints(Top0,Top),
  ( Top0 == Top ->
    true ;
    C1 = [Top|C] ).

% eccs_q_merge_constraints merges two constraint lists together such that
% any constraints which are satisfied on unification are undone on
% backtracking.  it might be improved by leaving the stacks alone when
% they are both [].

eccs_q_merge_constraints(X,Y) :-
  ( eccs_sys_var(X) ; eccs_sys_var(Y) ), !,
  X=Y,
  eccs_q_ck_con(X).
eccs_q_merge_constraints(X,Y) :-
  find_top(X,XTop,Next),
  find_top(Y,YTop,Next),
  eccs_append(XTop,YTop,Top0),
  eccs_q_morph_check_constraints(Top0,Top1),
  simplify_constraints(Top1,Neg0,Disj0),
  elim_identities(Disj0,Disj1),
  collapse_constraints(not,Neg0,Neg),
  collapse_constraints(or,Disj1,Disj),
  eccs_sys_if_then_else( (Neg == [], Disj == []), 
  	Next = [[]|_], 
	eccs_sys_if_then_else((Neg == [], Disj \== []), 
		Next = [[Disj]|_], 
		eccs_sys_if_then_else((Neg \== [], Disj == []), 
			Next = [[Neg]|_],
			eccs_sys_if_then_else((Neg \== [], Disj \== []),
				Next = [[Neg,Disj]|_] )))).

% collapse_constraints takes a set of negative or disjunctive
% constraints and collapses them into a single constraint.

collapse_constraints(_,[],[]) :- !.
collapse_constraints(Func,List,c(V,Con)) :-
  List = [c(V,_)|_],
  collapse_constraints0(Func,List,[],ListOfSets),
  union(ListOfSets,Union),
  Con =.. [Func,DummyVar,Union].

collapse_constraints0(_,[],X,X).
collapse_constraints0(or,[c(V0,or(_,L0))|T],X,Y) :-
  collapse_constraints0(or,T,[L0|X],Y).
collapse_constraints0(not,[c(V0,not(_,L0))|T],X,Y) :-
  collapse_constraints0(not,T,[L0|X],Y).

% unify the left and right hand sides of the equalities in the list of
% equalities.

sunify_eq_list([]).
sunify_eq_list([L=R|T]) :-
	su(L,R),
	sunify_eq_list(T).
