/* 
 rcsid('$Id: generic.pl,v 1.60 1993/05/04 09:43:01 pleuk Exp $').
 $Log: generic.pl,v $
% Revision 1.60  1993/05/04  09:43:01  pleuk
% Version 1.00beta from Jo
%
% Revision 1.5  1992/04/16  13:43:35  pleuk
% revisions from SLE - April 1992
%
% Revision 1.4  1992/01/29  16:03:21  chrisbr
% Jo's changes integrated with SLE's
%
% Revision 1.3  1992/01/17  09:44:40  chrisbr
% Just getting the RCS keywords right
%
 Header added by CHB -- December 1991
 EXPORTS to sletemplates
         % eccs_add_constraint/6 -> sletemplates
         % eccs_graph_plus_constraints/2 -> sletemplates, srcparser,printers
         % eccs_list_of_graph_plus_constraints/1 -> sletemplates
         % eccs_graph/2 -> printers, slemain, sletemplates, srcparser
         % eccs_user_empty_structure/1 -> slemain, sletemplates
         % eccs_constraints_structure/3 -> sletemplates
         % eccs_user_unify/3 -> slemain, sletemplates, sleparser
         % eccs_graph_unify/2 -> sletemplates
         % eccs_opt_append/3 -> sletemplates, srcparser
         % eccs_injection/2 -> sletemplates         
         % eccs_get_constraint_type/4 -> sletemplates

EXPORTS to printers
       
         % eccs_graph_plus_constraints/2 -> sletemplates, srcparser,printers
         % eccs_list_of_gcs2gcspluscs/3 -> printers
         % eccs_graph/2 -> printers, slemain, sletemplates, srcparser
         % eccs_get_all_node_constraints/2 -> printers
          
EXPORTS to srcparser

         % eccs_graph_plus_constraints/2 -> sletemplates, srcparser,printers
         % eccs_graph/2 -> printers, slemain, sletemplates, srcparser
         % eccs_user_unify/3 -> slemain, sletemplates, sleparser
         % eccs_check_constraints/2 -> srcparser
         % eccs_opt_append/3 -> sletemplates, srcparser

EXPORTS  to slemain

         % eccs_graph/2 -> printers, slemain, sletemplates, srcparser
         % eccs_user_empty_structure/1 -> slemain, sletemplates
         % eccs_user_unify/3 -> slemain, sletemplates, sleparser

LOCAL PROCEDURES of generic.pl
         % eccs_add_constraint1/7
         % eccs_list_of_gcs2gcspluscs1/3
         % eccs_constraints/2 
         % eccs_user_unify_graphs/3
         % eccs_check_implication_constraints1/3
         % eccs_list_injection/2
         % eccs_effective_constraint_check/3
         % eccs_check_constraints0/2
         % eccs_eval_constraints/5
         % eccs_merge_constraint_values/2
         % eccs_get_all_constraint_type/4
         % eccs_eval_constraints0/5
         % eccs_cross_check/5
         % eccs_one_solution_to_ds_and_ns/3
         % eccs_eval_cvs/2
         % eccs_eval_cvs1/5
         % eccs_check_instantiations/5
         % eccs_check_instantiations1/6
         % eccs_check_instantiations2/6
         % eccs_feature_never_there/2
         % eccs_check_bit_constraints/3
         % eccs_check_disjunction_constraints/4
         % eccs_check_negation_constraints/4
         % eccs_check_negation_constraints0/3
         % eccs_check_implication_constraints/3
         % eccs_check_template_constraints/5
         % eccs_check_type_constraints/3
         % eccs_member_all/2
         % eccs_get_disjunction_intersection/3
         % eccs_remove_negations/5
         % eccs_eval_disjunctions/5
         % eccs_imp_condition/3
         % eccs_do_imp_case/7
         % eccs_imp_subsumes/2
         % eccs_graph_subsumes/2
         % eccs_constraints_subsume/2

Wed Dec 11 14:28:02 1991 JC

Attempted to fix singleton vars; added routines for bit-encoded sort
information.  





*/


/*

eccs_add_constraint(ConsType, Constraint, Graph, In, Out, ST)

Constraint is of type ConsType, and holds of Graph. Out is In 
updated to reflect the constraint.  ST is the current symbol 
table mapping SLE variables (i.e. #1) to prolog variables


*/


eccs_add_constraint(Type, Constraint, Graph, In, Out, ST) :-
    eccs_graph_plus_constraints(In, Node, InCs),
    eccs_get_all_node_constraints(Graph, InCs, MyCs, Remainder),
    (eccs_delete(Type = CurrentValue, MyCs, Others);
     CurrentValue = [], Others = MyCs), !,
    eccs_add_constraint1(Type, Constraint, Graph, CurrentValue, Others, ST, NewCs),
    !,
    eccs_sys_if_then_else(NewCs = [],
	                  OutCs = Remainder,
			  (eccs_constraints_structure(Graph, NewCs, NewConstraints),
			   OutCs = [NewConstraints | Remainder]) ),
    eccs_graph_plus_constraints(Out, Node, OutCs).
/*

More to be added ...

bits, implications, etc.  

Thu Aug 20 11:34:02 1992 JC
Added the variable

templates_to_expand_at_compile_time

to allow expansion of certain templates on compilation.

*/

:- eccs_new_variable(templates_to_expand_at_compile_time, [],
    parsing, run, 
    "A list of templates which are expanded immediately").

eccs_add_constraint1(temp, T, Graph, Ts, Others, ST, Cs) :-
    eccs_template_name(T, Name),
%    write(Name), nl, trace,
    eccs_global_variable(templates_to_expand_at_compile_time, Names),
    eccs_member(Name, Names), !,
    eccs_do_template_args(T, ST, TOut),
    eccs_template_definition(TOut, Defn, Graph),
    eccs_graph_plus_constraints(Defn, _, Cs1),
    eccs_append(Others, Cs1, Cs2),
    (Ts = [] -> Cs = Cs2; 
    	Cs = [temp = Ts|Others]).
    
eccs_add_constraint1(temp, T, _Graph, Ts, Others, ST, [temp=[TOut|Ts]|Others]) :-
    eccs_do_template_args(T, ST, TOut).
eccs_add_constraint1(disj, Disj, Graph, Disjs, Others, _ST, Out) :-
    (Disjs = [] -> 
	eccs_eval_constraints(Graph, [disj = Disj|Others], Out, [], []);
	eccs_eval_constraints(Graph, [disj = Disj, disj = Disjs|Others], Out, [], [])).
eccs_add_constraint1(neg, Neg, Graph, Negs, Others, _ST, Out) :-
    eccs_eval_constraints(Graph, [neg = Neg, neg = Negs|Others], Out, [], []).
eccs_add_constraint1(imp, Imp, _Graph, Imps, Others, _ST, [imp=[Imp|Imps]|Others]).
eccs_add_constraint1(cv, CV, _Graph, CVs, Others, _ST, [cv=[CV|CVs]|Others]).
eccs_add_constraint1(instant, (F:V), _Graph, Instants, Others, _ST, 
		[instant=[(F:V)|Instants]|Others]).
/*  

As with disjunctions, we reduce the bits to a single structure immediately

*/
eccs_add_constraint1(bits, Bits, _Graph, OtherBits, Others, _ST, [bits=[NewBits]|Others]) :-
	eccs_check_bits([Bits|OtherBits], NewBits).



eccs_graph_plus_constraints(G:C, G, C).

% EXPORTED -> sletemplates
eccs_list_of_graph_plus_constraints([]).
eccs_list_of_graph_plus_constraints([H|T]) :-
    eccs_graph_plus_constraints(H, _, _),
    eccs_list_of_graph_plus_constraints(T).

% EXPORTED -> printers
eccs_list_of_gcs2gcspluscs(List, Graphs, Constraints) :-
    eccs_list_of_gcs2gcspluscs1(List, Graphs, Cs),
    eccs_flatten(Cs, Constraints).

% LOCAL
eccs_list_of_gcs2gcspluscs1([], [], []).
eccs_list_of_gcs2gcspluscs1([H|T], [HG|TG], [HCs|TCs]) :-
    eccs_graph_plus_constraints(H, HG, HCs),
    eccs_list_of_gcs2gcspluscs1(T, TG, TCs).

% EXPORTED -> printers, srcparser, sletemplates, slemain
eccs_graph(G:_, G).
% LOCAL
eccs_constraints(_:Cs, Cs).
% EXPORTED -> slemain,sletemplates
eccs_user_empty_structure(_:[]).
% EXPORTED -> sletemplates
eccs_constraints_structure(Node, Constraints, 'C'(Node, Constraints)).

/*

eccs_delete_constraints_on_node(Graph, MyCs, Cs, NewCs)

If Graph is constrained, it has MyCs as its constraints in the list of
node-constraint pairs, Cs, and NewCs is the result of deleting MyCs
from NewCs.  Otherwise, MyCs is the empty list. 

*/
% eccs_delete_constraints_on_node/4 -> LOCAL
eccs_delete_constraints_on_node(_Graph, _MyCs, _Cs, _NewCs) :-         % singleton vars, CHB
	write([eccs_delete_constraints_on_node,unimplemented]),abort.

% eccs_user_unify/3 -> main, templates, parser
eccs_user_unify(X:[], X:[], X:[]) :- !.
eccs_user_unify(X:[], Y:[], X:[]) :- !,
	eccs_graph_unify(X, Y).
eccs_user_unify(X:CX, Y:[], X:C) :- !,
	eccs_graph_unify(X, Y),
	eccs_check_constraints(CX, C).
eccs_user_unify(X:[], Y:CY, X:C) :- !,
	eccs_graph_unify(X, Y),
	eccs_check_constraints(CY, C).
eccs_user_unify(X:CX, Y:CY, X:C) :- !,
	eccs_graph_unify(X, Y),
	eccs_check_constraints([CX|CY], C).
%eccs_user_unify_graphs/3 -> LOCAL
eccs_user_unify_graphs(G1:C1, G2:C2, G2:C3) :-
	eccs_graph_unify(G1, G2),
	eccs_opt_append(C1, C2, C3).
% eccs_graph_unify/2 -> sletemplates
eccs_graph_unify(Dag, Dag) :- !.
eccs_graph_unify([Path = Val | Dags1], Dag) :-
	eccs_graph_unify_pathval(Dag, Path, Val, Dags2),
	eccs_graph_unify(Dags1, Dags2).
% eccs_graph_unify_pathval/4  -> LOCAL
% should Dag = Dag1 pjw 19.11.91, believe so chb 4.12.91
eccs_graph_unify_pathval(Dag1, Feature = Path, Val, Dags) :- !,
	eccs_graph_unify_pathval(Dag1, Feature, Dag2, Dags),
% originally	eccs_graph_unify_pathval(Dag, Feature, Dag2, Dags),
	eccs_graph_unify_pathval(Dag2, Path, Val, _ ).
eccs_graph_unify_pathval([Feature = Val1 | Dags], Feature, Val2, Dags) :- !,
	eccs_graph_unify(Val1, Val2).
eccs_graph_unify_pathval([Dag | Dags1], Feature, Val, [Dag | Dags2]) :- 
	eccs_graph_unify_pathval(Dags1, Feature, Val, Dags2).
/* eccs_check_constraints(+In, -Out) */

/* 'In' is a list with elements of the form 'C'(Node, Constraints),
where 'Node' is either a variable representing a graph or an atom, and
which may have more than one entry in 'In', and where Constraints is a
list containing any or all of:
    bits = [List], neg = [List], disj = [List], 
    imp = [List], temp = [List], types = [List]
    cv = [context_variable_name]
    instant =[instantiation_constraint]


'Out' is an updated list of constraints with a single entry per node,
unless all constraints for a particular node are satisfied in which
case no constraint entry is returned for that node.  If 'Node' is a
variable it may be instantiated as a result of the constraint check. 

We do context variables first, as these are cheap and likely to limit
the search quite a bit.

*/

% eccs_check_constraints/2 -> srcparser
eccs_check_constraints([[ In1H | In1T ] | In2 ], Out) :-
	eccs_opt_append([ In1H | In1T ], In2, In),
	eccs_check_constraints(In, Out).
eccs_check_constraints(In, Out) :-
        eccs_eval_cvs(In, InminusCVS),
	eccs_check_constraints0(InminusCVS, Checked),
	eccs_effective_constraint_check(In, Checked, Out).


/* eccs_effective_constraint_check(+In, +Checked, -Out) */

/* In order to judge whether we have evaluated any constraints, we
test to see whether the list we put in to the constraint checking
routine is the same as what we get out.  This strategy will not work
if constraints get evaluated in such a way as to make the In and
Checked forms prolog non-identical but with identical content.  The
obvious alternative strategy is to check for logical equivalence, but
that would be horrendously expensive... well in fact it's undecidable.

If the constraint list 'In' remains unchanged following a complete
check then this is returned.  Otherwise the check is repeated to
determine whether the changes made affect any other constraints in the
list, e.g. the instantiation of a node in one check may allow the
evaluation of an implication constraint in a subsequent check. */
% eccs_effective_constraint_check/3 -> LOCAL
eccs_effective_constraint_check(In, Checked, Checked) :-
	In == Checked, !.
eccs_effective_constraint_check(_In, Checked, Out) :-
	eccs_check_constraints(Checked, Out).


/* eccs_check_constraints0(+In, -Out) */

/* For the first node in the constraint list 'In', collect together
all constraints on that node in the rest of the list, evaluate these,
and return either a new constraint entry or the empty list if all
constraints are satisfied. */
% eccs_check_constraints0/2 -> LOCAL
eccs_check_constraints0([], []) :- !.
eccs_check_constraints0([ Constraints | Rest ], NewCs ) :-
	eccs_constraints_structure(CurrentNode, CurrentCs, Constraints),
	eccs_get_all_node_constraints(CurrentNode,Rest, RestCurrentCs,RestCs),
	eccs_opt_append(CurrentCs, RestCurrentCs, AllCurrentCs),
        eccs_eval_constraints(CurrentNode, 
	                      AllCurrentCs, 
			      NewCurrentCs, RestCs, RestCsOut),
	eccs_check_constraints0(RestCsOut, NewRestCs),
	eccs_sys_if_then_else(NewCurrentCs = [],
	                      NewCs = NewRestCs,
			      (eccs_constraints_structure(CurrentNode,
			                                  NewCurrentCs,
							  NewConstraints),
			       NewCs = [ NewConstraints | NewRestCs ]) ).
	

/* eccs_get_all_node_constraints(+Node, +ConstraintList, 
	                         -NodeConstraints, -RemainingConstraintList) */

/* Scan 'ConstraintList' collecting all the constraint entries on the
graph 'Node' or any equivalent graph, where is equivalence is defined
as having identical tails. Return a single compound entry and a list
of the remaining constraints on all other nodes */
% eccs_get_all_node_constraints/4 -> printers
eccs_get_all_node_constraints(Node, AllCs, NodeCs, RemCs) :-
	eccs_sys_if_then_else((eccs_sys_nonvar(Node), eccs_listp(Node)),
	                      eccs_tail(Node, Tail),
			      Tail = Node),
	eccs_get_all_node_constraints1(Tail, AllCs, NodeCs, RemCs).

eccs_get_all_node_constraints1(_Tail, [], [], []) :- !.
eccs_get_all_node_constraints1(Tail, [Constraints | Rest],
			      AllCurrentCs, RestCs) :- 
	eccs_constraints_structure(Node, CurrentCs, Constraints),
	(eccs_sys_nonvar(Node) ->
		eccs_tail(Node, NTail), NTail == Tail;
		Node == Tail),
	!,
	eccs_get_all_node_constraints1(Tail, Rest, 
	                              RestCurrentCs,RestCs),
	eccs_opt_append(CurrentCs, RestCurrentCs, AllCurrentCs).
eccs_get_all_node_constraints1(Tail,
	                      [ OtherConstraint | Rest ],
			      AllCurrentCs,
			      [ OtherConstraint | RestCs ]) :- !,
	eccs_get_all_node_constraints1(Tail, Rest, 
	                              AllCurrentCs, RestCs).

/* eccs_eval_constraints(+Node, +Constraints, -NewConstraints, OtherCs, OtherCsOut) */

/* Combine the constraint values in the compound constraint list
'Constraints' and then return the result of evaluating these OtherCs
and OtherCsOut are all constraints that are associated with the graph
that contains Node.  These are needed here as template expansion may
introducxe new nodes with associated constraints.  */
% eccs_eval_constraints/5 -> LOCAL
eccs_eval_constraints(Node, Constraints, NewConstraints, OtherCs, OtherCsOut) :-
	eccs_merge_constraint_values(Constraints, ConstraintLists),
	eccs_eval_constraints0(Node, ConstraintLists, NewConstraints, OtherCs, OtherCsOut).


/* eccs_merge_constraint_values(+CompoundConstraintList, -SingleConstraintList)
*/
/* For each constraint type in 'CompoundConstraintList' construct a
single list of values */
% eccs_merge_constraint_values/2 -> LOCAL
eccs_merge_constraint_values([], []) :- !.
eccs_merge_constraint_values(Cs, [ Attribute = Values | RestCs ]) :- !,
 	eccs_get_all_constraint_type(Attribute, Cs, Values, Rest),
	eccs_merge_constraint_values(Rest, RestCs).

/* eccs_get_all_constraint_type(+Type, +Constraints, -Values, -RemConstraints) */ 
/* Disjunctions are treated specially - values are compiled into a
list of lists to allow the intersection to be determined.  Other
attribute values are appended and a flat list returned. */
% eccs_get_all_constraint_type/4 -> LOCAL
eccs_get_all_constraint_type(_Attribute, [], [], []) :- !.
eccs_get_all_constraint_type(disj, [ disj = Value | Rest ], 
	                     [Value | RestValues], Remainder) :- !,
	eccs_get_all_constraint_type(disj, Rest, RestValues, Remainder).
eccs_get_all_constraint_type(Attribute, [ Attribute = Value | Rest ],
	                     NewValues, Remainder) :- !,
	eccs_get_all_constraint_type(Attribute, Rest, RestValues, Remainder),
	eccs_opt_append(Value, RestValues, NewValues).
eccs_get_all_constraint_type(Attribute, [ Att = Val | Rest ],
	                     RestValues, [ Att = Val | Remainder ]) :-
	eccs_get_all_constraint_type(Attribute, Rest, RestValues, Remainder).


/* eccs_get_constraint_type(+Type, +Constraints, -Value, -RemConstraints) */
% eccs_get_constraint_type/4 -> sletemplates
eccs_get_constraint_type(_Attribute, [], [], []) :- !.
eccs_get_constraint_type(Attribute, [ Attribute = Value | Rest ], Value, Rest) :- !.
eccs_get_constraint_type(Attribute, [ Att = Val | Rest ], 
	                 RestValues, [ Att = Val | Remainder]) :-
	eccs_get_constraint_type(Attribute, Rest, RestValues, Remainder).


/* eccs_eval_constraints0(+Node, +Constraints, -NewConstraints,
	OtherCs, OtherCsOut) */

/* 

Call checking routines for each constraint type.  

Disjunctions and negations are checked by the same routine. OtherCs
and OtherCsOut are all constraints associated with the graph that
contains Node.  (need for template expansion).  

*/
% eccs_eval_constraints0/5 -> LOCAL
eccs_eval_constraints0(Node, Constraints, NewConstraints, OtherCs, OtherCsOut) :-
	eccs_check_instantiations(Node, Constraints, C0, OtherCs, OtherCs1),
    	eccs_check_bit_constraints(Node, C0, C1),
	eccs_check_disjunction_constraints(Node, C1, C2, RemainingDs),
	eccs_check_negation_constraints(Node, C2, C3, RemainingNs),
	eccs_cross_check(RemainingDs, RemainingNs, C3, C4, Node),
	eccs_check_implication_constraints(Node, C4, C5),
	eccs_check_template_constraints(Node, C5, C6, OtherCs1, OtherCsOut),
	eccs_check_type_constraints(Node, C6, NewConstraints).


/*

eccs_cross_check(RemainingDs, RemainingNs, In, Out, Node)

Make certain that disjunctive and negative constraints have at 
least one solution.


Arguments are this way round to get help from indexing. 

*/


eccs_cross_check([], [], In, In, _Node)  :- !.
eccs_cross_check([], Ns, In, [neg=Ns|In], _Node) :- !.
eccs_cross_check(Ds, Ns, In, Out, Node) :-
    eccs_once(eccs_remove_negations(Node, Ds, Ns, NsOut, DsOut)),
    eccs_one_solution_to_ds_and_ns(DsOut, Node, D1s),
    (D1s = [] -> Out = O2; Out = [disj=D1s|O2]),
    (NsOut = [] -> O2 = In; O2 = [neg=NsOut|In]).

% eccs_one_solution_to_ds_and_ns/3 -> LOCAL
eccs_one_solution_to_ds_and_ns([Node], Node1, []) :- !,
    eccs_graph_unify(Node, Node1).	% Just in case ...
eccs_one_solution_to_ds_and_ns(Ds, _, Ds).



/* CONTEXT VARIABLES */

/* 

Substitute in the value of context variables as 
soon as we can. 

Note that we are working on constraint structure pairs here.  We can
take the node from the constraint structure pair and just go ahead and
instantiate.  The clauses are packed in this way so as to optimize for
the more common case where there are no CVs.

*/

% eccs_eval_cvs/2 -> LOCAL
eccs_eval_cvs([], []) :- !.
eccs_eval_cvs([NC|NCs], OutCs) :-
    eccs_constraints_structure(Node, Cs, NC),
    eccs_get_all_constraint_type(cv, Cs, CVars, Rest),
    (CVars = [] -> OutCs =[NC|OutCs1];
    	eccs_eval_cvs1(CVars, Rest, Node, OutCs, OutCs1)),
    eccs_eval_cvs(NCs, OutCs1).

/*

eccs_eval_cvs1(+CVars, +Other, +Node, CsIn, CsOut)

evaluate context variables CVars. 

Again we optimize for common cases. Other is the set of constraints
having a type different than context variable.



JC Wed Dec 11 14:29:53 1991 ?? This routine needs to be checked out,
in particular to make sure that it passes constraints out in the right
form.

*/

eccs_eval_cvs1([], [], _, In, In) :- !.	

% should there be no recursive call here pjw 19.11.91

eccs_eval_cvs1([], Rest, Node, In, Out) :-
    !,
    eccs_constraints_structure(Node, Rest, NC),
    eccs_append([NC|Rest], In, Out).

eccs_eval_cvs1(CVars, Rest, Node, In, Out) :-
    eccs_eval_cvars(CVars, GC),
    eccs_graph_plus_constraints(GC1, Node, Rest),
    eccs_user_unify(GC, GC1, Result),
    eccs_graph_plus_constraints(Result, _, NewCs),
    (NewCs = [] -> In = Out;
      eccs_constraints_structure(Node, NewCs, NC),
      Out = [NC|In]).



/* INSTANTIATION CONSTRAINTS */
% eccs_check_instantiations/5 -> LOCAL
eccs_check_instantiations(Node, MyCsIn, MyCsOut, OtherCsIn, OtherCsOut) :-
    eccs_get_all_constraint_type(instant, MyCsIn, Instants, Remainder),
    eccs_check_instantiations1(Node, Instants, Remainder, MyCsOut, OtherCsIn, OtherCsOut).

/*

eccs_check_instantiations1(Node, Instants, Remainder, MyCsOut, 
						OtherCsIn, OtherCsOut).

We trap here for the cases in which Node is still variable, or is atomic. 

The atomic case, where we just throw away any constraints, is
justified as these constraints are all negative and involve complex
feature structures.

The call to eccs_sort/2 was necessary at some point.  I'm not 100%
sure that it still is.  It doesn't hurt ..
Wed Dec 11 14:38:29 1991 JC

*/


eccs_check_instantiations1(_Node, [], MyCs, MyCs, OtherCs, OtherCs) :- !.
eccs_check_instantiations1(Atom, _,  MyCs, MyCs, OtherCs, OtherCs) :- 
    eccs_sys_atomic(Atom),
    !.
eccs_check_instantiations1(Node, Ins, MyCs, [instant=Ins|MyCs], OtherCs, OtherCs) :- 
    eccs_sys_var(Node), !.
eccs_check_instantiations1(Node, Ins, MyCs, AllMyCs, OtherCsIn, OtherCsOut) :- 
    eccs_check_instantiations2(Node, Ins, MyCs, MyCsOut, OtherCsIn, OtherCsOut),
    eccs_get_all_constraint_type(instant, MyCsOut, Cs, Rest),
    eccs_sort(Cs, CsSort),
    eccs_sys_if_then_else(Cs = [], AllMyCs = MyCsOut, AllMyCs = [instant=CsSort|Rest]).

/*

eccs_check_instantiations2(Node, Ins, MyCs, AllMyCs, OtherCs, OtherCs).

If we get here, we really have an instantiated node and constraints on
instantiations.

*/


eccs_check_instantiations2(_Node, [], MyCs, MyCs, OtherCs, OtherCs) :- !.
eccs_check_instantiations2(Node, [(Feature:Value)|Rest], MyCsIn, MyCsOut, OCsIn, OCsOut) :-
    eccs_feature_really_there(Feature, Node, NodeValue), !,
    (Value == '$$TOP$$' -> fail; true),
    eccs_constraints_structure(NodeValue, [neg=[Value]], NC),
    eccs_check_instantiations2(Node, Rest, MyCsIn, MyCsOut, [NC|OCsIn], OCsOut).
eccs_check_instantiations2(Node, [(Feature:_Value)|Rest], MyCsIn, MyCsOut, OCsIn, OCsOut) :-
    eccs_feature_never_there(Feature, Node), !,
    eccs_check_instantiations2(Node, Rest, MyCsIn, MyCsOut, OCsIn, OCsOut).
eccs_check_instantiations2(Node, [In|Rest], MyCsIn, MyCsOut, OCsIn, OCsOut) :-
    eccs_check_instantiations2(Node, Rest, [instant=[In]|MyCsIn],MyCsOut, OCsIn, OCsOut).

/*

eccs_feature_really_there(Feature, Node, Value) :-

True if Node is a list of feature value pairs and Feature 
appears in it. 

*/

eccs_feature_really_there(_Feature, Node, _Value) :-
    eccs_sys_var(Node), !, fail.
eccs_feature_really_there(Feature, [F = V|_], V) :-
    F == Feature, !.
eccs_feature_really_there(Feature, [_|T], V) :-
    eccs_feature_really_there(Feature, T, V).

/*

eccs_feature_never_there(Feature, Node)

True if Node can never get instantiated in such a way as to allow 
Feature = _Value to appear within it. 

THis is to allow for the possibility of closed typing. 


*/

eccs_feature_never_there(_Feature, Node) :-
    eccs_sys_var(Node), !, fail.
eccs_feature_never_there(Feature, [F = _|_]) :-
    F == Feature, !, fail.
eccs_feature_never_there(Feature, [_|T]) :-
    !,
    eccs_feature_never_there(Feature, T).
eccs_feature_never_there(_Feature, X) :-
    eccs_sys_nonvar(X).

/* BIT CONSTRAINTS */

eccs_check_bit_constraints(_Node, Constraints, NewConstraints) :-
	eccs_get_constraint_type(bits, Constraints, Bits, Rest),
	eccs_check_bit_constraints1(Bits, Rest, NewConstraints).


eccs_check_bit_constraints1([], Cons, Cons) :- !.
eccs_check_bit_constraints1(Bits, Other, [NewBits|Other]) :-
    eccs_check_bits(Bits, NewBits).


/* DISJUNCTION CONSTRAINTS */
% eccs_check_disjunction_constraints/4 -> LOCAL
eccs_check_disjunction_constraints(Node, Constraints, CsOut, RemainingDs) :-
	eccs_get_constraint_type(disj, Constraints, Disj, CsOut),
	(Disj = [] -> RemainingDs = [];
		eccs_get_disjunction_intersection(Node, Disj, RemainingDs)).
    
/* NEGATION CONSTRAINTS */
% eccs_check_negation_constraints/4 -> LOCAL
eccs_check_negation_constraints(Node, Constraints, CsOut, RemainingNs) :-
	eccs_get_constraint_type(neg, Constraints, Negs, CsOut),
	eccs_sys_if_then_else(Negs = [],
	                      RemainingNs = [],
			      eccs_check_negation_constraints0(Node, Negs, RemainingNs)).
% eccs_check_negation_constraints0/4 -> LOCAL
eccs_check_negation_constraints0(Node, Negs, Negs) :-
	eccs_sys_var(Node), !.
eccs_check_negation_constraints0(Node, Negs, []) :-	
	\+ ((eccs_member(N, Negs), eccs_graph_unify(Node, N))).


/*
The following clause commented out

eccs_check_disjunction_and_negation_constraints(Node, Constraints, NewConstraints) :-
	eccs_get_constraint_type(disj, Constraints, Disj, Rest1),
	eccs_get_constraint_type(neg, Rest1, Neg, Rest),
	eccs_get_disjunction_intersection(Node, Disj, Intersection),
	\+ (Intersection = []),
	eccs_once(
	    eccs_remove_negations(Node,Intersection,Neg, Neg1,Intersection1) ),
	\+ (Intersection1 = []),
	eccs_eval_disjunctions(Node, Intersection1, Neg1, NewDisj, NewNeg),
	eccs_sys_if_then_else(NewNeg = [],
	                      NewNegConstraints = Rest,
			      NewNegConstraints = [ neg = NewNeg | Rest ] ),
	eccs_sys_if_then_else(NewDisj = [Node],
	                      NewConstraints = NewNegConstraints,
			      NewConstraints = [ disj = NewDisj | 
			                         NewNegConstraints ]).
*/


/* IMPLICATION CONSTRAINTS 

Wed Dec 11 14:39:44 1991 JC

The 3rd line of the body had just CStructure, rather than the
1-element list.  This resulted in ill-formed constraint lists. 

*/


eccs_check_implication_constraints(Node, Constraints, NewConstraints) :-
    eccs_get_constraint_type(imp, Constraints, Imp, Rest),
    eccs_constraints_structure(Node, Rest, CStructure),
    eccs_graph_plus_constraints(GC, Node, [CStructure]),
    eccs_check_implication_constraints1(GC, Imp, NewImp),
    eccs_sys_if_then_else(NewImp = [], NewConstraints = Rest,
	NewConstraints = [ imp = NewImp | Rest ] ).

/* TEMPLATES */

/* 

eccs_check_template_constraints(Node, Constraints, NewConstraints, Cs, CsOut)

Top level routine for checking templates.

Constraints and NewConstraints are local to Node.  Cs and CsOut are
all constraints associated with the graph that contains Node.

*/
% eccs_check_template_constraints/5 -> LOCAL
eccs_check_template_constraints(Node, Constraints, NewConstraints, Cs, CsOut) :-
	eccs_get_constraint_type(temp, Constraints, Temp, Rest),
	eccs_template_expansion(Node, Temp, NewTemp, Rest, RestOut, Cs, CsOut),
	eccs_sys_if_then_else(NewTemp = [],
	                      NewConstraints = RestOut,
			      NewConstraints = [ temp = NewTemp | RestOut ] ).

/* TYPE CONSTRAINTS */

eccs_check_type_constraints(_Node, Constraints, NewConstraints) :-
	eccs_get_constraint_type(types, Constraints, Types, Rest),
	NewTypes = Types,
	eccs_sys_if_then_else(NewTypes = [],
	                      NewConstraints = Rest,
			      NewConstraints = [ types = NewTypes | Rest ] ).



/* eccs_get_disjunction_intersection(+Node, +DisjunctionList, -Intersection)
   eccs_member_all(+Item, +Rest) */

/* If 'Node' has multiple entries in a constraint list return the
intersection of the disjunctions specified in each (if any).  Return a
single disjunction list directly.  If no disjunction constraint is
specified then the value of 'Node' is inserted to allow the negation
constraint check to proceed. */
% eccs_get_disjunction_intersection/3 -> LOCAL
eccs_get_disjunction_intersection(_Node, [List], List) :- !.
eccs_get_disjunction_intersection(_Node, [[H|[]] | Rest], [H]) :-
	eccs_member_all(H, Rest), !.
eccs_get_disjunction_intersection(_Node, [[_H|[]] | _Rest], []) :- !.
eccs_get_disjunction_intersection(Node, [[H|T] | Rest], Int) :- 
	eccs_member_all(H, Rest), !,
	eccs_get_disjunction_intersection(Node, [T | Rest], Others),
	eccs_sys_if_then_else(eccs_memberchk_var(H, Others),
	                      Int = Others,
			      Int = [H | Others]).
eccs_get_disjunction_intersection(Node, [[_H|T] | Rest], Int) :-
	eccs_get_disjunction_intersection(Node, [T | Rest], Int).


eccs_member_all(_Item, []) :- !.
eccs_member_all(Item, [List | Rest]) :-
	eccs_memberchk_var(Item, List),
	eccs_member_all(Item, Rest).


/* eccs_remove_negations(+Node,+Disjunctions, +Negations,
	                 -NewNegations, -NewDisjunctions) */

/* Scan 'Disjunctions' removing any elements occurring in 'Negations' */


eccs_remove_negations(_Node, Disj, [], [], Disj).
eccs_remove_negations(_Node, [], Neg, Neg, []).

eccs_remove_negations(Node, Disj, [Neg | Rest], RemNeg, NewDisj) :-
	eccs_delete_var(Neg, Disj, RestDisj),
	eccs_remove_negations(Node, RestDisj, Rest, RemNeg, NewDisj).
eccs_remove_negations(Node, Disj, [_Neg | Rest], RemNeg, NewDisj) :-
	eccs_remove_negations(Node, Disj, Rest, RemNeg, NewDisj).


/* eccs_eval_disjunctions(+Node, +Disjunctions, +Negations,
	                  -NewDisjunctions, -NewNegations) */

/* If 'Node' is atomic ensure value is contained in 'Disjunctions'.
If so return that value in a single element 'NewDisjunctions' list for
the purposes of subsequent constraint checks, and return the empty
list as 'NewNegations'.  If 'Node' is a variable and 'Disjunctions'
contains a single value, then instantiate 'Node' to be this value.
???Otherwise remove any occurences of the variable 'Node' from
'Disjunctions' and return the result as 'NewDisjunctions'??? */

eccs_eval_disjunctions(Node, [Item], _Negs, [Item], []) :-
	eccs_sys_atom(Item), !,
	Node = Item.
eccs_eval_disjunctions(Node, [Item], Negs, [Item], Negs) :-
	eccs_sys_var(Item), !,
	Node = Item.

eccs_eval_disjunctions(Node, List, Negs, [Node], Negs) :-
	eccs_sys_atom(Node),
	eccs_member(Node, List), !.
eccs_eval_disjunctions(Node, List, Negs, NewList, Negs) :-
	eccs_sys_var(Node),
	eccs_delete_var(Node, List, NewList), !.
eccs_eval_disjunctions(Node, Disj, Negs, Disj, Negs) :-
	eccs_sys_var(Node).


/* eccs_opt_append(+In1, +In2, -Out) */
/* optimised append routine - trap a few cases */

% eccs_opt_append/3 -> sletemplates, srcparser
eccs_opt_append([], List, List) :- !.
eccs_opt_append(List, [], List) :- !.
eccs_opt_append([Item], List, [Item|List]) :- !.
eccs_opt_append(List, [Item], [Item|List]) :- !.
eccs_opt_append([H|T], List, [H|R]) :-
	eccs_opt_append(T, List, R).

/*
Routine for checking implications

eccs_check_implication_constraints1(Graph+Cons, NewImp, NewImp1)



Just an instantiation check, really, 

*/


eccs_check_implication_constraints1(_Node, [], []) :- !.
eccs_check_implication_constraints1(Node, [imp(A, B, C)|Rest], NewImp) :-
    eccs_imp_condition(Node, A, Case),
    eccs_do_imp_case(Case, Node, A, B, C, Rest, NewImp).
% eccs_imp_condition/3 -> LOCAL
eccs_imp_condition(Node, Anteced, subsumed) :-
    eccs_imp_subsumes(Anteced, Node), !.
eccs_imp_condition(Node, Anteced, fail) :-
    \+ eccs_user_unify(Node, Anteced, _), !.
eccs_imp_condition(_Node, _Anteced, none).
% eccs_do_imp_case/7 -> LOCAL
eccs_do_imp_case(none, Node, A, B, C, Rest, [imp(A, B, C)|NewImps]) :-
    eccs_check_implication_constraints1(Node, Rest, NewImps).

eccs_do_imp_case(fail, _Node, _, _, (C & D), Rest, Rest) :-
    !,
    eccs_user_unify(C, D, _).
eccs_do_imp_case(subsumed, _Node, _, (C & D), _, Rest, Rest) :-
    eccs_user_unify(C, D, _).
% eccs_imp_subsumes/2 -> LOCAL
eccs_imp_subsumes(X, X) :-
    X == X, !.
eccs_imp_subsumes(X:XCs, Y:YCs) :-
    eccs_verify((eccs_graph_subsumes(X, Y), 
    eccs_constraints_subsume(XCs, YCs))).
% eccs_graph_subsumes/2 -> LOCAL
eccs_graph_subsumes(X, Y) :-
    eccs_verify(eccs_graph_unify(X, Y)),
    eccs_verify((
    	numbervars(Y, 0, _N), eccs_injection(X, Y))).


eccs_injection(X, X) :- !.
eccs_injection([F = V|R], X) :-
    eccs_delete(F = Val, X, Rest),
    eccs_injection(V, Val),
    eccs_injection(R, Rest).
% eccs_list_injection/2 -> LOCAL
eccs_list_injection([], []).
eccs_list_injection([H|T], [F|R]) :-
    eccs_injection(H, F), !,
    eccs_list_injection(T, R).


% what's this then pjw 19.11.91
% Comment chb 04.12.91 -- test subsumption between sets of constraints.
% For the moment this is clearly incorrect, since it asserts that arbitrary
% sets of constraints might subsume each other. However, it is hard to do better
% than this
% eccs_constraints_subsume/2 -> LOCAL
eccs_constraints_subsume(_XXCs, _YYCs).

/*

eccs_imp_subsumes(X,Y) :-
    eccs_graph_plus_constraints(X, XG, XCs),
    eccs_graph_plus_constraints(Y, YG, YCs),
    eccs_hide_implications(XCs, X1Cs),
    eccs_hide_implications(YCs, Y1Cs),
    eccs_graph_plus_constraints(X1, XG, X1Cs),
    eccs_graph_plus_constraints(Y1, YG, Y1Cs),
    eccs_user_subsumes(X1, Y1).

eccs_hide_implications(Cs, CslessImps) :-
    eccs_get_all_constraint_type(imp, Cs, _, CslessImps).

eccs_user_subsumes(XCs, YCs) :- 
    eccs_graph_plus_constraints(XCs, X, XXCs),
    eccs_graph_plus_constraints(YCs, Y, YYCs),
    eccs_verify(eccs_user_unify(XCs, YCs, _)),
    eccs_verify((
    	numbervars(YCs, 0, N),
	eccs_injection(XCs, YCs),
	eccs_constraints_subsume(XXCs, YYCs))).
*/

/*

New code; JC mid December 1991

eccs_check_bits(+List, -NewBits)

The list of bit specifications in List are pairwise bitwise anded, resulting 
in NewBits.

The apparent redundancy of the first clause of eccs_check_bits1 is
needed in order to have a test that there are still satisfying models,
which wouldn't happen if we just passed on Bits as New.

For the wrapper bits/1, see sletemplates.pl

*/

eccs_check_bits(bits(Bits), bits(New)) :-
    !,
    eccs_check_bits1([bits(Bits)], New).
eccs_check_bits(Bits, bits(New)) :-
    eccs_check_bits1(Bits, New).

eccs_check_bits1([bits(Bits)], New) :- !,
    eccs_bit_unify(Bits, Bits, New).
eccs_check_bits1([bits(Bits1)|bits(Bits2)], Meet) :-
    eccs_bit_unify(Bits1, Bits2, Meet), !.    
eccs_check_bits1([bits(Bits1), bits(Bits2)|Bs], Meet) :-
    eccs_bit_unify(Bits1, Bits2, New),
    eccs_check_bits1([bits(New)|Bs], Meet).





