
/*
 rcsid('$Id: printers.pl,v 1.60 1993/05/04 09:43:01 pleuk Exp $').
 $Log: printers.pl,v $
% Revision 1.60  1993/05/04  09:43:01  pleuk
% Version 1.00beta from Jo
%
% Revision 1.5  1992/04/16  13:43:35  pleuk
% revisions from SLE - April 1992
%
% Revision 1.4  1992/02/11  10:29:09  chrisbr
% Changes to parser and debugging routines. Dead code removed
%
% Revision 1.3  1992/01/29  16:03:23  chrisbr
% Jo's changes integrated with SLE's
%

Wed Dec 11 14:28:02 1991 JC

Added a bunch of parameters, which follow immediately.  Got rid 
of most singleton var warnings.  

Fri Jan 31 1992 CHB

Changed the printing routines for grammar rules and lexical entries to
provide the option of expanding out templates as far as possible

*/

:- eccs_ensure_variable(shadowed_attributes, [], printing, run,
	"A list of attributes not to show in printed versions").

:- eccs_ensure_variable(attribute_ordering, [], printing, run, 
	"The order in which attributes should appear in printed versions").

:- eccs_ensure_variable(better_attributes, [], printing, run, 
	"Preferences as to which attributes should have full AVMs rather than tags").

:- eccs_ensure_variable(expand_templates, false, printing, run,
	"Whether templates should be expanded out in feature structure listings").

:- eccs_ensure_variable(filter_lists_to_sequences, false, printing, run, 
	"If true, avms consisting of just the attributes, ``first'' and ``rest'' will be mapped into sequences").

:- eccs_ensure_variable(print_as_tree, false, printing, run, 
	"Attempt to format output into a tree.").


/*

Mon Feb  8 14:56:39 1993 JC

Added variable 'group objects by name'

*/



eccs_print_template(template, Name, template(PName, Alias, Def), 
	captioned(Caption, STDForm)) :-
    eccs_tem_sle2std(PName, Alias, Def, STDForm),
    eccs_tem_name_to_atom(Name, Atom),
    eccs_concat_list(['The template: "', Atom, '"'], Caption).
/* Call a slightly different printing routine if we are expanding templates
 * eagerly
 */
eccs_print_lexical_entry(lexical_entry, Name,  Def, captioned(Caption, STDForm)) :-
	eccs_sys_if_then_else(
				 eccs_global_variable(expand_templates,true),
				 eccs_print_lexical_entry(lexical_entry, Name,  Def, 
				 captioned(Caption, STDForm),expand),
				 eccs_print_lexical_entry(lexical_entry, Name,  Def, 
				 captioned(Caption, STDForm),noexpand)).
% 31 Jan 1992 CHB
% Print out a lexical entry with templates intact...
eccs_print_lexical_entry(lexical_entry, Name,  Def, 
	captioned(Caption, STDForm),noexpand) :-
    eccs_sle2std(Def, STDForm),
    eccs_number_indices(STDForm),
    eccs_tem_name_to_atom(Name, Atom),
    eccs_concat_list(['The lexical entry "', Atom, '"'], Caption).
% 31 Jan 1992 CHB
% Print out a lexical entry with templates expanded...
% If this fails, print a message, then revert to old printer
eccs_print_lexical_entry(lexical_entry, Name,  Def, 
	captioned(Caption, STDForm),expand) :-
    eccs_eval_cv(top_level_template, T),
    template(T, _, _, template(_, _, TDef)),
    eccs_user_unify(Def, TDef, Out),!, 
    eccs_sle2std(Out, STDForm),
    eccs_number_indices(STDForm),
    eccs_tem_name_to_atom(Name, Atom),
    eccs_concat_list(['The lexical entry "', Atom, '"'], Caption).
eccs_print_lexical_entry(lexical_entry, Name,  Def, 
	captioned(Caption, STDForm),expand) :-
    eccs_sle2std(Def, STDForm),
    eccs_number_indices(STDForm),
    eccs_tem_name_to_atom(Name, Atom),
    eccs_concat_list(['The lexical entry "', Atom, '" (Can''t expand)'], Caption).

eccs_print_grammar_rule(grammar_rule, Name, rule(M, Ds), STDForm) :-
    STDForm = captioned(Caption, relation(atomic(rule), [M1, parenth(D1s)])),
    eccs_sle2std_list([M|Ds], [M1|D1s]),
    eccs_number_indices([M1|D1s]),
    eccs_concat_list(['The grammar rule: "', Name, '"'], Caption).

eccs_print_control(control, wait_statement, wait(Name, Locus, Args), 
	captioned('Wait statement', relation(atomic(Atom), L1))) :-
    eccs_tem_name_to_atom(Name, Atom),
    eccs_append(Args, [Locus], L),
    eccs_sle2std_list(L, L1).
eccs_print_control(control, deterministic, deterministic(D), 
	captioned('Deterministic', relation(atomic(deterministic), [atomic(A)]))) :-
    eccs_tem_name_to_atom(D, A).


/*

How we print from parses:

eccs_printfs_from_parse(Sentence, Caption, Edge, STDForm)

Wed Dec 11 14:45:17 1991 JC,  added !.  

*/


eccs_printfs_from_parse(_Sentence, Caption, FS, captioned(Caption, STDForm)) :-
    eccs_sle2std(FS, STDForm).



eccs_tem_sle2std(PName, Alias, Def, infix(Symbol, atomic(PName),STDForm)) :-
    eccs_sys_atomic(PName), !,
    eccs_template_type(Alias, Symbol),
    eccs_sle2std(Def, STDForm),
    eccs_number_indices(STDForm, 1, _).

eccs_tem_sle2std(PName, Alias, Def, 
		infix(Symbol, Format ,STDForm)) :-
    eccs_template_type(Alias, Symbol),
    PName =.. [Name, A1|As],
    eccs_sle2std_list([Def, A1|As], [STDForm|Args]),
    eccs_operator_or_relation(Name, Args, Format),
    eccs_number_indices(Args, 1, N),
    eccs_number_indices(STDForm, N, _).

eccs_tem_name_to_atom(A, A) :-
    eccs_sys_atomic(A), !.
eccs_tem_name_to_atom(T/N, A) :-
    eccs_concat_list([T, '/', N], A).
% singleton variables squashed 1/92 -- CHB
eccs_operator_or_relation(Name, [A1, A2], infix(atomic(Name), A1, A2)) :-
    current_op(_P, Fixity, Name),
    eccs_memberchk(Fixity, [xfx, yfy, xfy, yfx]).
eccs_operator_or_relation(Name, A1, prefix(atomic(Name), A1)) :-
    current_op(_P, Fixity, Name),
    eccs_memberchk(Fixity, [fx, fy]).
eccs_operator_or_relation(Name, A1, postfix(atomic(Name), A1)) :-
    current_op(_P, Fixity, Name),
    eccs_memberchk(Fixity, [xf, yf]).
eccs_operator_or_relation(Name, Args, relation(atomic(Name), Args)).


eccs_template_type(alias, atomic(aliases)).
eccs_template_type(not_an_alias, symbol(arrowdblright)).


/*

eccs_sle2std(Internal, STDForm)

The Internal  representation has the STDForm as its standard printing format.

*/

eccs_sle2std(Internal, STDForm) :-
    eccs_sle2std(Internal, STDForm1, _, _),
    (eccs_global_variable(filter_lists_to_sequences, true) ->
	    eccs_sle_filter_lists(STDForm1, STDForm2)
	;   STDForm2 = STDForm1),
    (eccs_global_variable(print_as_tree, true) ->
	    filter_to_tree(STDForm2, STDForm)
	;   STDForm2 = STDForm).



% changed ValueTree to ValueTree in first line of code CHB 1/92
eccs_sle2std(Internal, STDForm, Value_Tree, Root) :-
    eccs_graph_plus_constraints(Internal, Graph, Constraints),
    eccs_findunifs(Graph, Constraints, Value_Tree, Root),
    eccs_unfold_vt(Value_Tree),
    eccs_sle2std1(Root, Value_Tree, STDForm).

eccs_findunifs(Value, Constraints, VarTree, Root) :-
    eccs_findunifs(Value, Constraints, Root, VarTree, []).

/*

eccs_sle2std1(In, Args, Out).

This is the last routine to be called in translating stuff to SPF.  

Wed Dec 11 14:47:08 1991 JC Tags were not getting numbered. This
routine was defined as just identity, and the routine it calls is new.

*/

eccs_sle2std1(STDForm, _, STDForm) :-
    eccs_sle_renumber_tags(STDForm).

eccs_sle_renumber_tags(SPF) :-
    eccs_sle_renumber_tags(SPF, 1, _).

eccs_sle_renumber_tags(A, N, N) :-
    eccs_sys_atomic(A), !.
eccs_sle_renumber_tags(tag(N), N, M) :-
    !,
    M is N + 1.
eccs_sle_renumber_tags(tagged(N, AVM), N, O) :-
    !,
    M is N +1, 
    eccs_sle_renumber_tags(AVM, M, O).
eccs_sle_renumber_tags(Term, N, M) :-
    eccs_sys_functor(Term, F, Arity),
    eccs_sle_renumber_tags1(Term, 0, Arity, N, M).

eccs_sle_renumber_tags1(Term, Arity, Arity, N, N) :- !.
eccs_sle_renumber_tags1(Term, Count, Arity, N, M) :- 
    Count  < Arity,
    Count1 is Count +1,
    eccs_sys_arg(Count1, Term, Arg),
    eccs_sle_renumber_tags(Arg, N, O),
    eccs_sle_renumber_tags1(Term, Count1, Arity, O, M).



/*

eccs_sle2std_list(L, L1)

L is a list of graph plus constraints pairs, L1 is a list 
of SPF terms.

*/


eccs_sle2std_list(L, L1) :-
    eccs_list_of_gcs2gcspluscs(L, Gs, Cs),
    eccs_sle2std_list(Gs, Cs, Value_Tree, L1),
    eccs_unfold_vt(Value_Tree).

/*

eccs_sle2std_list(Gs, Cs, VT, Root)

Graphs Gs with associated constraints Cs, give rise to value 
tree VT with Root.

*/

eccs_sle2std_list([], _Cs, _, []).
eccs_sle2std_list([Graph|R], Cs, Value_Tree, [Root|R1]) :-
    eccs_findunifs(Graph, Cs, Value_Tree, Root),
    eccs_sle2std_list(R, Cs, Value_Tree, R1).


/*

eccs_findunifs(Value, Constraints, Root, VarTree, Path)

VarTree is the binary tree of values in AVM.  Path is the reversed
list of attributes which, followed from the root of the original dag
leads to Value. Root is a partial specification of the output form of
AVM.

*/

/* On finding a value, insert it in the tree and add the path to the
list of paths.  In the case of variables, leave a new variable hanging
around.


The fourth clause here seems to me to be needed in order to catch
cases where whole sequences are identified.  It might be commented in,
if this was deemed to be appropriate behaviour. Depends on whether one
wishes to be explicit about the extensionality of operators like
concat and union, I guess.

*/


eccs_findunifs(Var, Constraints, Root, VarTree, Path) :-
    var(Var), !,
    eccs_binary_tree_of_values(Var, VarTree, Paths >> NewVar),
    eccs_note_path(path(Root, Path), Paths),
    eccs_findconstraints(Var, Constraints, VarTree, NewVar, _).
eccs_findunifs([], _Constraints, Root, VarTree, Path) :-
    !,
    eccs_binary_tree_of_values('$NULL_SEQ', VarTree, Paths >> '$NULL_SEQ'),
    eccs_note_path(path(Root, Path), Paths).
eccs_findunifs(Atom, _Constraints, Root, VarTree, Path) :-   % CHB -- singleton vars
    eccs_sys_atomic(Atom), !,
    eccs_binary_tree_of_values(Atom, VarTree, Paths >> atomic(Atom)),
    eccs_note_path(path(Root, Path), Paths).  
/* eccs_findunifs(AVM, Root, VarTree, Path) :-
 * eccs_binary_tree_of_values(AVM, NewRoot, Paths >> NewRoot),
 * (Paths = [] -> fail; eccs_note_path(path(Root, Path), Paths)), !.  
*/ 
eccs_findunifs([H|T], Constraints, Root, VarTree, Path) :-
    var(H), !,
    eccs_binary_tree_of_values(H, VarTree, Paths >> _NewRoot), % CHB, singleton vars
    eccs_note_path(path(Root, ['$HEAD'|Path]), Paths),
    eccs_findunifs_seq(T, Constraints, Root, VarTree, ['$TAIL'|Path]).
eccs_findunifs([A=V|R], Constraints, Root, VT, Path) :-
    !, eccs_once(eccs_tail([A=V|R], Tail)),
    eccs_binary_tree_of_values(Tail, VT, Paths >> avm(AVM)),
    eccs_note_path(path(Root, Path), Paths),
    (fu_been_here_before(Paths) -> true;
    		eccs_findconstraints([A=V|R], Constraints, VT, AVM, NewRoot),
    		order_and_filter_attributes([A=V|R], Filtered, NewRoot),
		eccs_findunifs_av_pairs(Filtered, Constraints, NewRoot, VT, [])). % reset path
eccs_findunifs([H|T], Constraints, Root, VT, Path) :-
    eccs_findunifs_seq([H|T], Constraints, Root, VT, Path).

fu_been_here_before(Paths) :- \+ Paths = [_].

eccs_findunifs_av_pairs(Var, _Constraints, _Root, _, _) :-
    var(Var), !.
eccs_findunifs_av_pairs([A=V|R], Constraints, Root, VT, Path) :-
    eccs_findunifs(V, Constraints, Root, VT, [A|Path]),
    eccs_findunifs_av_pairs(R, Constraints, Root, VT, Path).

eccs_findunifs_seq(Var, _Constraints, Root, VT, Path) :- % singleton var CHB
    var(Var), !, 
    eccs_binary_tree_of_values(Var, VT, Ps >> _NewVar),
    eccs_note_path(path(Root, Path), Ps).
eccs_findunifs_seq([], _Constraints, Root, VT, Path) :- % singleton vars CHB
    !,
    eccs_binary_tree_of_values('$END_SEQ', VT, Ps >> '$END_SEQ'),
    eccs_note_path(path(Root, Path), Ps).
eccs_findunifs_seq([H|T], Constraints, Root, VT, Path) :-
    eccs_findunifs(H, Root, VT, ['$HEAD'|Path]),
    eccs_findunifs_seq(T, Constraints, Root, VT, ['$TAIL'|Path]).

/*

Make a note of the current path in the list of paths associated with
each node.

*/ 
eccs_note_path(path(Root, Path), Var) :-
    var(Var), !, Var = [path(Root, Path)|_].  
eccs_note_path(path(Root, Path), [path(R1, P1)|_]) :-
    Root == R1, Path == P1, !.  
eccs_note_path(path(Root, Path), [_|T]) :-
    eccs_note_path(path(Root, Path), T).


/*

eccs_binary_tree_of_values(Value, VarTree, Structure)

Value is positioned at an appropriate point (given by the Prolog
standard ordering) in VarTree and associated in that tree with
Structure.

*/

eccs_binary_tree_of_values(Value, VarTree, Struct) :-
    var(VarTree), !,			% never been here before 
    VarTree = tree(Value,Struct, _NewTree).
eccs_binary_tree_of_values(Value, tree(Val1, Struct1, SubTree), Struct) :-
    compare(Rel, Value, Val1),
    order_tree_of_values(Rel, Value, tree(Val1, Struct1, SubTree), Struct).

order_tree_of_values((=), Value, tree(Value, Struct, _), Struct) :- !,
    (eccs_sys_var(Value); eccs_sys_atomic(Value)), !.	% ?? just for sanity
order_tree_of_values((<), Value, tree(_, _, t(Pre, _)), Struct) :- !,
    eccs_binary_tree_of_values(Value, Pre, Struct).  
order_tree_of_values((>), Value, tree(_, _, t(_, Succ)), Struct) :- !,
    eccs_binary_tree_of_values(Value, Succ, Struct).



/*

eccs_findconstraints(NewVar, VarTree)

*/

eccs_findconstraints(Var, Constraints, VT, In, Out) :-
    eccs_get_all_node_constraints(Var, Constraints, MyCs, _),
    analyse_constraints(MyCs, Constraints, VT, In, Out).
/*
eccs_findconstraints_head_and_tail(Head, Tail, Constraints, VT, AVM, NewRoot) :-
    eccs_get_all_node_constraints(Head, Constraints, MyHeadCs, _),
    eccs_get_all_node_constraints(Tail, Constraints, MyTailCs, _),
    eccs_append(MyHeadCs, MyTailCs, MyCs),
    analyse_constraints(MyCs, Constraints, VT, AVM, NewRoot).

analyse_constraints(Cs, All, VT, In, Out)

Cs are constraints that hold at the current node.  All is the set of
All constraints that hold of the current graph.  VT is the binary tree
of values.  In and Out are partial specs of SPF output.

Wed Dec 11 14:48:54 1991 JC 
Added stuff for bits. 

*/
analyse_constraints([], _, _, In, In).
analyse_constraints([Type=Cs|Rest], AllConstraints, VT, In, Out) :-
    eccs_analyse_constraint(Type, Cs, AllConstraints, VT, In, Out1),
    analyse_constraints(Rest, AllConstraints, VT, Out1, Out).

eccs_analyse_constraint(temp, Ts, All, VT, In, Out) :- !,
    eccs_analyse_tempconstraint(Ts, All, VT, In, Out).
eccs_analyse_constraint(disj, Ds, All, VT, In, Out) :- !,
    eccs_analyse_disjconstraint(Ds, All, VT, In, Out).
eccs_analyse_constraint(neg, Negs, All, VT, In, Out) :- !,
    eccs_analyse_negconstraint(Negs, All, VT, In, Out).
eccs_analyse_constraint(cv, CVs, All, VT, In, Out) :- !,
    eccs_analyse_cvconstraint(CVs, All, VT, In, Out).
eccs_analyse_constraint(instant, Insts, All, VT, In, Out) :- !,
    eccs_analyse_instconstraint(Insts, All, VT, In, Out).
eccs_analyse_constraint(bits, Bits, All, VT, In, Out) :- !,
    eccs_analyse_bitconstraint(Bits, All, VT, In, Out).
eccs_analyse_constraint(X, _, _, _, In, In) :-
    eccs_warning([no, printing, routine, available, for,
    		  constraints, of, type, X]).

/*

Decoders for the different types of constraints.

Wed Dec 11 14:51:41 1991 JC The template routines did not take into
account the wrappers that are used for counting the number of template
expansions in the history of the given template.

*/

eccs_analyse_tempconstraint([], _All, _VT, In, In).
eccs_analyse_tempconstraint([Temp|Temps], All, VT, [prefix(atomic('@'), atomic(Temp))|In], Out) :-
    eccs_sys_atomic(Temp), !,
    eccs_analyse_tempconstraint(Temps, All, VT, In, Out).
eccs_analyse_tempconstraint([Temp|Temps], All, VT, [Print|In], Out) :-
    eccs_mask_count_info(Temp, NewTemp),
    eccs_analyse_ptempconstraint(NewTemp, All, VT, Print),
    !,
    eccs_analyse_tempconstraint(Temps, All, VT, In, Out).
eccs_analyse_tempconstraint([Temp|Temps], All, VT, In, Out) :-
    eccs_warning([can, not, decode, Temp]),
    eccs_analyse_tempconstraint(Temps, All, VT, In, Out).    
    
/*

eccs_mask_count_info(In, Out)

Wed Dec 11 14:53:48 1991 JC To print template with associated
expansion info, we have to get rid of it.

*/

eccs_mask_count_info('$$COUNT'(Temp, _), Temp) :- !.
eccs_mask_count_info(Temp, Temp).

eccs_analyse_ptempconstraint(PTemp, All, VT, Format) :-
    PTemp =.. [Name|As],
    eccs_operator_or_relation(Name, L1, Format),
    eccs_list_of_gcs2gcspluscs(As, Gs, Cs),
    eccs_append(All, Cs, AllCs),
    eccs_sle2std_list(Gs, AllCs, VT, L1).

eccs_analyse_disjconstraint(Ds, _All, _VT, [disj(DsOut)|Out], Out) :-
    eccs_forall(eccs_member(D, Ds), eccs_sys_atomic(D)),
    !,
    eccs_list_to_disj(Ds, DsOut).
eccs_analyse_disjconstraint(Ds, _All, _VT, Out, Out) :-
    eccs_warning([disjuncts, in, unprintable, format, Ds]).

eccs_list_to_disj([], []).
eccs_list_to_disj([F|R], [atomic(F)|R1]) :-
    eccs_list_to_disj(R, R1).

    
/*

Wed Dec 11 14:55:06 1991 JC 

Previous code did not take account of the possibility of multiple
negative constraints.  There is a hack in here, which deletes multiple
occurrences of the same constraint.  As term unification is the test
for multiples, this may screw up in case negs are consistent with each
other but distinct.

*/
eccs_analyse_negconstraint([A], _All, _VT, [neg(atomic(A))|Out], Out) :-
    eccs_sys_atomic(A), !.
eccs_analyse_negconstraint([H|T], _All, _VT, [conj(Negs)|Out], Out) :-
    eccs_analyse_negconstraint1([H|T], [], _All, _VT, Negs).

eccs_analyse_negconstraint1([], _, _, _, []).
eccs_analyse_negconstraint1([H|T], Prev, All, VT, Negs) :-
    eccs_memberchk(H, Prev), !,
    eccs_analyse_negconstraint1(T, Prev, All, VT, Negs).
eccs_analyse_negconstraint1([H|T], Prev, All, VT, [neg(atomic(H))|Negs]) :-
    eccs_sys_atomic(H), !,
    eccs_analyse_negconstraint1(T, [H|Prev], All, VT, Negs).
eccs_analyse_negconstraint1([H|T], Prev, All, VT, [neg(atomic(H))|Negs]) :-
    eccs_warning([cannot, decode, complex, 'negation:', H]),
    eccs_analyse_negconstraint1(T, [H|Prev], All, VT, Negs).

eccs_analyse_cvconstraint([], _All, _VT, Out, Out) :- !.
eccs_analyse_cvconstraint(CV, _All, _VT, [relation(atomic(cv), [atomic(CV)])|Out], Out) :-
    eccs_sys_atomic(CV), 
    !.
eccs_analyse_cvconstraint([CV|CVs], _All, _VT, In, Out) :-
    eccs_analyse_cvconstraint(CV, _, _, In, In1),
    eccs_analyse_cvconstraint(CVs, _, _, In1, Out).

eccs_analyse_instconstraint([], _All, _VT, In, In).
eccs_analyse_instconstraint([Inst|Insts], All, VT, In, Out) :-
    eccs_analyse_instconstraint(Inst, All, VT, In, In1),
    eccs_analyse_instconstraint(Insts, All, VT, In1, Out).
eccs_analyse_instconstraint((F:'$$TOP$$'), _, _, [neg(avm([F = uninstantiated]))|Out], Out) :- !.
eccs_analyse_instconstraint((F:Atom), _, _, [neg(avm([F = atomic(Atom)]))|Out], Out) .


/*

Wed Dec 11 14:58:26 1991 JC

Additions for bit-encoded sorts.  

If we have a value for the variable variable_aliases, use the 
first sort in that list which subsumes what we currently have. 

e.g. 
:- eccs_new_variable(variable_aliases,
    	[alias('Fem',    f),
	 alias('Mal',    m),
	 alias('Ne',     n),
	 alias('Hum',    h),
	 alias('Eve',    e),
	 alias('Pro',    pr),
	 alias('Si',     sg),
	 alias('Pl',     pl),
	 alias('Mp',     mp),
	 alias('Ms',     ms),
	 alias('Sta',    s),
	 alias('Nst',    ns),
	 alias('Tem',    t),
	 alias('Obj',    o),
	 alias('Uns',    u)],
	 any, run, "A set of aliases for sort definitions").

*/  

eccs_analyse_bitconstraint(Bits, All, VT, In, Out) :-
    eccs_sys_if_then_else(Bits = [bits(NewBits)],
    	true,
	eccs_check_bits(Bits, bits(NewBits))),
    eccs_sys_if_then_else(eccs_global_variable(variable_aliases, Aliases),
    	(eccs_bits_to_alias(NewBits, Aliases, Alias),
	 In = [sort(Alias)| Out]),
	(eccs_sort_type(NewBits, Sorts),	% Imported from sort.pl
	 eccs_sorts_to_spf(Sorts, In, Out))).

eccs_bits_to_alias(_, [], unknown) :- !.
eccs_bits_to_alias(Bits, [alias(Sort, Alias)|_], Alias) :-
    eccs_get_from_database(sort_definition, +Sort, property_term(+Sort, SBits)),
    eccs_bit_subsume(SBits, Bits), !.
eccs_bits_to_alias(Bits, [_|As], Alias) :-
    eccs_bits_to_alias(Bits, As, Alias).


eccs_sorts_to_spf([], X, X).
eccs_sorts_to_spf([Sort|Ss], [sort(Sort)|S1s], S2s) :-
    eccs_sorts_to_spf(Ss, S1s, S2s).


/*

eccs_unfold_vt(VT)

The statements in VT are evaluated and, as a side effect, build give
rise to the tree associated with the empty path from Root, cf
eccs_findunifs above and follow_path below.

*/

eccs_unfold_vt(empty_tree) :- !.  
eccs_unfold_vt(tree(_, Ps >> SubDag, Tree)) :-
    value_format_and_place(Ps, SubDag),
    eccs_unfold_vt(Tree).
eccs_unfold_vt(t(Pre, Succ)) :- 
    eccs_unfold_vt(Pre),
    eccs_unfold_vt(Succ).


/*

This is where we decide whether we coindex and where coindexed
instantiated structures should be placed.

The routine fix up constraints is there because under the current
strategy we get back things which are really not very nice when output
via postscript, namely [a v b] and [F ~[a]], so we trap for these
cases. IN the case where a constraint is attached to a reentrant bit
of graph, there's not much to be done, until we have a general
tag+object routine available.

Wed Dec 11 14:59:23 1991 JC

The 2 occurrences of eccs_once were added to prevent the creation of 
arbitrarily large lists on backtracking into eccs_closed_list. 

*/

value_format_and_place([P], Var) :-	% single path to var
    var(Var),
    !, 
    P = path(Dag, Path),
    follow_path(Path, Dag, uninstantiated).
value_format_and_place([path(Dag, Path)], ConstrainedVar) :-
    eccs_listp(ConstrainedVar), !,	% see below
    eccs_once(eccs_closed_list(ConstrainedVar)),
    eccs_fix_up_constraints(ConstrainedVar, Fixed),
    follow_path(Path, Dag, Fixed).
value_format_and_place([P], Value) :- !, % single path to nonvar 
    P = path(Dag, Path),
    follow_path(Path, Dag, Value).
value_format_and_place(Ps, Var) :-	% many paths to var
    var(Var),
    !,
    follow_paths(Ps, tag(_N)).
value_format_and_place(Paths, ConstrainedVar) :- % many paths to var
    eccs_listp(ConstrainedVar), !,	% see below
    eccs_once(eccs_closed_list(ConstrainedVar)),
    order_eq_paths(Paths, [H|T]),
    eccs_fix_up_constraints(ConstrainedVar, Fix),
    follow_paths([H], tagged(N, Fix)),
    follow_paths(T, tag(N)).
value_format_and_place(Ps, atomic(Atom)) :-	% many paths to atom 
    eccs_sys_atomic(Atom), !,
    follow_paths(Ps, atomic(Atom)).
value_format_and_place(Ps, Value) :-	% many paths to complex AVM
    order_eq_paths(Ps, [H|T]),
    follow_paths([H], tagged(N, Value)),
    follow_paths(T, tag(N)).

/*

The test, eccs_listp, ensures that we got back a straight list as the
value in a dag.  What this means is that we're dealing with a list of
constraints associated with a variable value. We have then to fix the
format so that it falls within SPF.  This just means wrapping avm(_)
around it, as that will then appear as a vertically set list and
closing off the tail so that it doesn't get numbered in the tagging
routine.  This change effectively breaks the treatment of sequences as
lists from Mike's grammar, as we now have no means of telling whether
something is really list or just a constrained var.

Also, there may be some doubts about the treatment of constraints to
which there are multiple paths.  In the last clause but two, we just
throw the constraints into a tagged avm.  (This is because avms are
the only things we may currently tag).  This should be robust, but
will end up giving not very nice typography.

eccs_fix_up_constraints(ConstrainedVar, Fix)

ConstrainedVar may be in a format which needs fixing.



*/

eccs_fix_up_constraints([H, H1|T], avm([H, H1|T])) :- !.
eccs_fix_up_constraints([neg(X)], neg(X)) :- !.
eccs_fix_up_constraints([disj(X)], disj(X)) :- !.
eccs_fix_up_constraints([relation(X, Args)], relation(X, Args)) :- !.
eccs_fix_up_constraints(X, avm(X)) :- 
    !,
    eccs_listp(X).   
eccs_fix_up_constraints(X, X) :- !.


/*

follow_paths(Ps, Value)

Follow the paths Ps given in the form path(Root, RevPath) to Value

*/



follow_paths([], _) :- !.
follow_paths([P|Ps], Value) :-
    P = path(Dag, Path),
    follow_path(Path, Dag, Value),
    follow_paths(Ps, Value).

/*

follow_path(Atts, Dag, Value)

following the reversed path specified by Atts in Dag leads to Value.
The main wrinkle here has to do with instantiation.  The ordering of
attributes within all terms that ultimately instantiate Dag has
already been defined by order_and_filter_attributes in eccs_findunifs
above.  However, we can't tell what this ordering is and have to wait
until Dag is appropriately instantiated before we proceed.  Hence the
freeze in the auxiliary predicate merge_value_into_dag.  If we don't
do this, we will screw up because we can instantiate an avm whose
ordering doesn't matter (under the user defined attribute ordering) in
two ways which are graph unification equivalent but not term
unifiable.  We know that the frozen instantiation conditions will
ultimately be met, because under order_and_filter_attributes, all
attributes that figure at a particular level of structure are
represented in the partial output generated by that routine.


*/

follow_path(RevPath, Dag, Value) :-
    eccs_reverse(RevPath, Path),
    follow_path1(Path, Dag, Value).

follow_path1([], Dag, Dag1) :- !,
    merge_value_into_dag(Dag, Dag1).
follow_path1(['$HEAD'|R], [Dag|_], Value) :- !,
    follow_path1(R, Dag, Value).  
follow_path1(['$TAIL'|R], [_|Dag], Value) :- !,
    follow_path1(R, Dag, Value).
follow_path1([Att|Atts], Dag, SubDag) :-
    delayed_memberchk(Att = Val, Dag),
    follow_path1(Atts, Val, SubDag).


/*

merge_value_into_dag(DPreserve, D)

Unify D and DPreserve, ensuring that no modification is done to the
ordering given in DPreserve.

*/



merge_value_into_dag(Var, Dag) :-
    var(Var), !,
    Dag = Var.
merge_value_into_dag(_D, []) :- !.
merge_value_into_dag(D, [A=Value|R]) :- !,
    merge_av_pairs_into_dag(D, [A=Value|R]).
merge_value_into_dag([H|T], D) :-
    merge_value_into_dag_list([H|T], D).
merge_value_into_dag(Atom, Atom) :-
    eccs_sys_atomic(Atom).

merge_av_pairs_into_dag(D, [A=Value|R]) :-
    delayed_memberchk(D, A = Value),
    merge_av_pairs_into_dag(D, R).

delayed_memberchk(A = Value, D) :-
    freeze(D, ( D = [A1 = V1|R],
    (A ==A1 -> Value = V1; 
	       delayed_memberchk(A = Value, R)))).

merge_value_into_dag_list(_D, []) :- !. % singleton var CHB
merge_value_into_dag_list([H|T], [F|R]) :-
    freeze(F, merge_value_into_dag(H, F)),
    merge_value_into_dag_list(T, R).





/*

order_and_filter_attributes(Old, New, OutAVM)

New is a smaller version of Old, with any shadowed attributes removed
from the top level. OutAVM is a partial specification of the feature
structure that will be output.  We know all the feature structures
that figure at this level of structure (wherever it occurs). One thing
we can't assume is that we always end up with a unique ordering for
any given permutation of labels.  This is because there may be labels
which are unordered with respect to one another. The ordering we do
get will not contradict any of the attribute ordering statements.

*/

order_and_filter_attributes(Old, New, OutAVM) :-
    eccs_fs_labels(Old, Labels), 
    eccs_order_labels(Labels, LOrdered),	% ordered and without shadowed attributes 
    eccs_extract_values(LOrdered, Old, New),
    build_partial_output(LOrdered, OutAVM).


build_partial_output([], []) :- !.
build_partial_output([Att|Atts], [Att = _|R]) :-
    build_partial_output(Atts, R).
  

/* eccs_fs_labels(FS, Ls)

FS has Ls as it labels at the top level

*/

eccs_fs_labels(Var, []) :- 
    var(Var), !.
eccs_fs_labels([], []) :- !.
eccs_fs_labels([F=_|T], R) :-
    eccs_shadowed_attribute(F), !,
    eccs_fs_labels(T, R).
eccs_fs_labels([F=_|T], [F|R]) :-
    eccs_fs_labels(T, R).



/*

eccs_shadowed_attribute(F)

An attribute F is shadowed if it is the list of 
shadowed_attributes

*/

eccs_shadowed_attribute(F) :-
    eccs_global_variable(shadowed_attributes, L),
    eccs_memberchk(F, L).


/* eccs_order_labels(Ls, L1s)

L1s are labels sorted by the attribute ordering stated above.
CHB change
==========
If there is a value of attribute_ordering but it doesn't order the
top level features of the given structure then
we get an error message and a default version rather than silent
failure. It seems wrong that we should depend on the value of
attribute ordering being a list since we can't actually enter such
things via the dialog boxes

*/

eccs_order_labels(Ls, L1s) :-
    eccs_global_variable(attribute_ordering, Ord), !,
    eccs_sys_if_then_else(
      eccs_order_labels(Ord, Ls, L1s),
      true,
      (Ls = L1s, eccs_to_user(['Error',ordering, doesnt, order, Ls]))).
eccs_order_labels(Ls, Ls).



/*

Tue Sep 1 15:04:55 1992 JC; added the 3rd cut in the definition below,
as we otherwise can backtrack into an improper list.

*/

eccs_order_labels(_, [], []) :- !.  
eccs_order_labels([], Ls, Ls) :- !.
eccs_order_labels([L|Ord], Ls, [L|L1s]) :-
    eccs_delete(L, Ls, L2s), !,
    eccs_order_labels(Ord, L2s, L1s).
eccs_order_labels([_L|Ord], Ls, L1s) :-
    eccs_order_labels(Ord, Ls, L1s).


/*

eccs_extract_values(Atts, AVM, NewAVM)

NewAVM is just like AVM, including wrt conindexing except that it is
only specified for attributes in Atts.

The body of the first clause is there because of the need to maintain
coindexing.

*/

eccs_extract_values([], AVM, NewAVM) :- 
    (var(AVM) -> AVM = NewAVM;
    		eccs_tail(AVM, NewAVM)).
eccs_extract_values([H|T], AV, [H=Value|AV1]) :-
    eccs_delete(H = Value, AV, AV2), !,
    eccs_extract_values(T, AV2, AV1).




/*     

order_eq_paths(Ps, Ordered)

the preferred path of the Ps is the head of Order, the remainder of Ps
being Order's tail.

*/

order_eq_paths([H|T], [Best|Rest])  :-
    order_eq_paths(T, H, [], Rest, Best).

order_eq_paths([], P, Rest, Rest, P) :- !.
order_eq_paths([H|Tail], SoFar, Rest0, Rest, Best) :-
    better_path(H, SoFar), !,
    order_eq_paths(Tail, H, [SoFar|Rest0], Rest, Best).
order_eq_paths([H|Tail], SoFar, Rest0, Rest, Best) :-
    order_eq_paths(Tail, SoFar, [H|Rest0], Rest, Best).



better_path(path(_, [Same]), path(_, [Same])) :-  !.
better_path(path(_, []), path(_, [Same])) :-  !,
    eccs_global_variable(better_attributes, L),
    eccs_memberchk(Same, L), !.
better_path(path(_, [Same]), path(_, [])) :-  !,
    eccs_global_variable(better_attributes, L),
    eccs_memberchk(Same, L), !.
better_path(path(_, [Better]), path(_, [Worse])) :- 
    eccs_global_variable(better_attributes, List),
    better_path(Better, List, Worse). 




better_path(Better, List, Worse) :-
    eccs_memberchk(Better, List), 
    \+ eccs_memberchk(Worse, List), !.
better_path(Better, List, Worse) :-
    eccs_follows_in_list(Better, Worse, List).

eccs_follows_in_list(Better, Worse, []) :- 
    !, fail.
eccs_follows_in_list(Better, Worse, [Better|Rest]) :-
    eccs_memberchk(Worse, Rest), !.
eccs_follows_in_list(Better, Worse, [_|Rest]) :-
    eccs_follows_in_list(Better, Worse, Rest).

eccs_number_indices(X) :-
    eccs_number_indices(X, 1, _).
eccs_number_indices(Var, N, M) :-
    eccs_sys_var(Var),
    !,
    M is N + 1,
    Var = N.
eccs_number_indices(Atomic, N, N) :-
    eccs_sys_atomic(Atomic), 
    !.
eccs_number_indices(Term, N, M) :-
    eccs_sys_functor(Term, _F, I),        % sing vars CHB
    eccs_number_indices1(Term, 0, I, N, M).

eccs_number_indices1(_, I, I, N, N) :-
    !.
eccs_number_indices1(Term, I, J, N, M) :-
    eccs_succ(I, I1),
    eccs_sys_arg(I1, Term, A),
    eccs_number_indices(A, N, N1),
    eccs_number_indices1(Term, I1, J, N1, M).


/*

Mon Aug 10 13:53:01 1992 JC Added the following routine to catch 
lists in first-rest form and map them to sequences.

We ought to be able to make the assumptions that everything is ground
and that avms of the right form pattern match against 

[first = _, rest = _]

For generality, I've not made those assumptions.  

*/

eccs_sle_filter_lists(Var, _) :-
    eccs_sys_var(Var),
    !,
    eccs_warning([variable, in, standard, printing, format]), fail.
eccs_sle_filter_lists(Atom, Atom) :-
    eccs_sys_atomic(Atom), !.
eccs_sle_filter_lists(AVML, sequence(L1)) :-
    eccs_real_sequence(AVML, L0), !,
    eccs_sle_filter_list(L0, L1).
eccs_sle_filter_lists(T, T1) :-
    eccs_sys_functor(T, F, N),
    eccs_sys_functor(T1, F, N),
    eccs_sle_filter_lists(0, N, T, T1).

eccs_sle_filter_lists(N, N, _T, _T1) :- !.
eccs_sle_filter_lists(I, N, T, T1) :-
    eccs_sys_lt(I, N),
    eccs_succ(I, J),
    eccs_sys_arg(J, T, A),
    eccs_sys_arg(J, T1, A1),
    eccs_sle_filter_lists(A, A1),
    eccs_sle_filter_lists(J, N, T, T1).



eccs_real_sequence(atomic(nil), []) :- !.
eccs_real_sequence(avm([first = F, rest = R]), [F|Rest]) :-
    eccs_real_sequence(R, Rest).
eccs_real_sequence(avm([rest = R, first = F]), [F|Rest]) :-
    eccs_real_sequence(R, Rest).

eccs_sle_filter_list([], []).
eccs_sle_filter_list([F|R], [H|T]) :-
    eccs_sle_filter_lists(F, H),
    eccs_sle_filter_list(R, T).


/*

Thu Aug 27 11:26:40 1992 JC

filter_to_tree(STD, STD1)

Map from an AVM representation of some expression to a tree
representation.  We make lots of assumptions about the attribute
names!

*/

filter_to_tree(Atom, Atom) :-
    eccs_sys_atomic(Atom), !.
filter_to_tree(Structure, STD) :-
    trap_for_tree(Structure, STD), !.
filter_to_tree(Structure, STD) :-
    eccs_sys_functor(Structure, F, N),
    eccs_sys_functor(STD, F, N),
    filter_to_tree(0, N, Structure, STD).

filter_to_tree(N, N, _, _) :- !.
filter_to_tree(I, N, Structure, STD) :-
    I < N,
    eccs_succ(I, J),
    eccs_sys_arg(J, Structure, A1),
    eccs_sys_arg(J, STD, A2),
    filter_to_tree(A1, A2),
    filter_to_tree(J, N, Structure, STD).


trap_for_tree(avm(L), tree(avm(L2), [Out|DsOut])) :-
    eccs_delete(dtrs = avm(Ds), L, L2), !,
    eccs_delete(hd = HD1, Ds, D1s), !,
    filter_to_tree(HD1, HDTree),
    eccs_delete(cdtrs = CDs, D1s, _), !,
    map_dtrs(CDs, DsOut),
    (HDTree = tree(HD, As) -> Out = tree(stack([atomic('H'), HD]), As);
	Out = stack([atomic('H'), HDTree])).

map_dtrs(tagged(_, L), L1) :- !,
    map_dtrs(L, L1).
map_dtrs(sequence(L), L1) :- !,
    map_dtrs1(L, L1).
map_dtrs(atomic(nil), []).
map_dtrs(avm([first = CD, rest = CDs]), [stack([atomic('C'), CD1])|R]) :-
    filter_to_tree(CD, CD1),
    map_dtrs(CDs, R).

map_dtrs1([], []).
map_dtrs1([F|R], [ stack([atomic('C'), CD])|T]) :-
    filter_to_tree(F, CD),
    map_dtrs1(R, T).

    
