/*

File:	/home/dk2/jcalder/Pleuk/SLE/sledc.pl
Date:	Thu Sep 10 14:13:57 1992
By:	Jo Calder


Interaction with the derivation checker --- 
this assumes HPSG style grammars.

rcsid('$Id: sledc.pl,v 1.0 1993/05/04 09:41:27 pleuk Exp $').
$Log: sledc.pl,v $
% Revision 1.0  1993/05/04  09:41:27  pleuk
% Version 1.00beta from Jo
%
*/

/*


tree is the name of the type we give to partical derivations in the DC. 


*/
spec_dc_prepare(schema, _, Tag, Result) :-
    Name = schema/1,
    Tag = schema(DBRef-Type-NumberOfDs), 
    eccs_get_from_databaser(template, Name, Object, DBRef),
    sle_expand_schema(Object, Tag, Type, NumberOfDs, FS),
    eccs_graph_plus_constraints(GC, FS, _),
    sle_dc_schema_name(FS, N),
    sle_obj2spf(GC, schema(N), [], Tag, Result).

spec_dc_prepare(lexical_entry, Name, lexical(DBRef), Result) :-
    sle_dc_lex_lookup(Name, DBRef, _),
%    Result = tree(atomic('H'), [atomic(Name)]).
    Result = atomic(Name).

spec_dc_prepare(derivation(Tag), SPF) :-
    sle_dc_lookup(derivation(Tag), Deriv),
    eccs_sys_arg(1, Deriv, Name),
    sle_obj2spf(Deriv, Name, [], derivation(Tag), SPF).
spec_dc_prepare(lexical(Tag), SPF) :-
    spec_dc_prepare(lexical_entry, _Name, lexical(Tag), SPF).
spec_dc_prepare(schema(Tag), SPF) :-
    spec_dc_prepare(schema, _Name, schema(Tag), SPF).



sle_expand_schema(Object, schema(_-Type-NumberOfDs), Type, NumberOfDs, FSG) :-
    Object = template(schema(N:[]), _, FS),
    eccs_graph_plus_constraints(FS, FSG, _),
    sle_add_dtrs(N, FSG, Type, NumberOfDs).
    
sle_dc_schema_name(FS, N) :-
    eccs_memberchk(schema = N, FS),
    eccs_sys_nonvar(FS), !.
sle_dc_schema_name(_, '?').

sle_dc_lex_lookup(Name, DBRef, Def) :-
    eccs_get_from_databaser(template, lex/2, IntDef, DBRef),
    IntDef = template(lex(Name:[], Def1), _, _),
    eccs_get_from_database(template, lexical, template(_, _, D2)),
    eccs_user_unify(Def1, D2, Def),
    eccs_graph_plus_constraints(Def, FS, _),
    eccs_memberchk(phon = P, FS),
    eccs_memberchk(first = Name, P),
    eccs_memberchk(rest = nil, P),
    eccs_sys_nonvar(Name).

sle_dc_lex_lookup(Name, DBRef, Def) :-
    eccs_get_from_databaser(template, marker, IntDef, DBRef),
    IntDef = template(marker, _, Def),
    eccs_graph_plus_constraints(Def, G, _),
    eccs_memberchk(phon = Name, G).

/*

sle_add_dtrs(SchemaNumber, FS, DtrsType, NumberOfDs)

instantiate schema in feature structure FS with NumberOfDs of DtrsType.


*/

sle_add_dtrs(1, FS, cdtrs, 1) :-
    eccs_memberchk(dtrs = DTRS, FS),
    eccs_memberchk(cdtrs = CDTRS, DTRS),
    eccs_memberchk(first = _, CDTRS),
    eccs_memberchk(rest = nil, CDTRS).

sle_add_dtrs(2, FS, cdtrs, N) :-
    eccs_member(N, [0, 1, 2, 3]),
    eccs_memberchk(dtrs = DTRS, FS),
    eccs_memberchk(cdtrs = CDTRS, DTRS),
    sle_instantiate_list(N, CDTRS).

sle_add_dtrs(3, FS, cdtrs, N) :-
    eccs_member(N, [1, 2, 3]),
    eccs_memberchk(dtrs = DTRS, FS),
    eccs_memberchk(cdtrs = CDTRS, DTRS),
    sle_instantiate_list(N, CDTRS).

sle_add_dtrs(4, FS, mdtr, 1) :-
    eccs_memberchk(dtrs = DTRS, FS),
    eccs_memberchk(mdtr = _MDTR, DTRS).

sle_instantiate_list(0, nil) :- !.
sle_instantiate_list(N, G) :-
    N > 0,
    eccs_memberchk(first = _, G),
    eccs_memberchk(rest = G1, G),
    eccs_succ(M, N),
    sle_instantiate_list(M, G1).



sle_obj2spf(FS, _M, Path, Tag, SPF) :-
    eccs_graph_plus_constraints(FS, FSG, _),
    sle_dtrs2tree(FSG, Tag, Path, SPF).


sle_fs2mother_name(FS, _Tag, _Path, atomic(Mother)) :-
    eccs_feature_really_there(schema, FS, S), !,
    eccs_concat_list([schema, ' ', S], Mother).
sle_dc_mother_name(_FG, atomic('M?')).


sle_dtrs2tree(FSG, Tag, Path, SPF) :-
    eccs_feature_really_there(dtrs, FSG, DTRS),
    !,
    SPF = tree(Mother, SPFDTRS),
    sle_fs2mother_name(FSG, Tag, Path, Mother),
    sle_dc_do_dtrs(DTRS, Tag, [dtrs|Path], SPFDTRS).
sle_dtrs2tree(FSG, _Tag, _Path, SPF) :-
    \+ ( sle_dc_lexical(FSG, _) ; sle_dc_non_lexical(FSG)), !,
    SPF = atomic('?').
sle_dtrs2tree(FSG, _Tag, _Path, SPF) :-
    sle_dc_lexical(FSG, Phon), !,
    (eccs_sys_nonvar(Phon) -> 
    	SPF = italic(Phon);
	SPF = atomic('L')).


sle_dc_do_dtrs(FS, Tag, Path, [H|Ds]) :-
    (eccs_feature_really_there(hd, FS, HD) -> 
    	sle_do_hd(HD, Tag, [hd|Path], H);
	H = atomic('H?')),
    sle_do_other_dtrs(FS, Tag, Path, Ds).



sle_do_hd(HD, Tag, Path, H) :-
    (\+ (sle_dc_phon_instantiated(HD); eccs_memberchk(schema = X, HD), eccs_sys_nonvar(X)) -> 
    	H = sensitize(triangle(atomic('H')), 
 		      insert_selection(Path, Tag))
       ; (sle_dc_lexical(HD, Phon) -> H = tree(atomic('H'), [italic(Phon)]);
              sle_dtrs2tree(HD, Tag, Path, H))).

sle_dc_lexical(FS, Phon) :-
    eccs_memberchk(synsem = SS, FS),
    eccs_memberchk(local = L, SS),
    eccs_memberchk(cat = C, L),
    eccs_memberchk(lex = Lex, C),
    Lex == +,
    !,
    eccs_memberchk(phon = List, FS),
    eccs_memberchk(first = Phon, List).

sle_dc_non_lexical(FS) :-
    eccs_memberchk(synsem = SS, FS),
    eccs_memberchk(local = L, SS),
    eccs_memberchk(cat = C, L),
    eccs_memberchk(lex = Lex, C),
    Lex == -,
    !.

sle_dc_phon_instantiated(FS) :-
    eccs_memberchk(phon = Phon, FS),
    eccs_memberchk(first = F, Phon),
    eccs_sys_nonvar(F).

sle_do_other_dtrs(Var, _, _, []) :-
    eccs_sys_var(Var), !.
sle_do_other_dtrs([hd = _|R], Tag, Path, SPFDs) :-
    !,
    sle_do_other_dtrs(R, Tag, Path, SPFDs).
sle_do_other_dtrs([cdtrs = CDs|R], Tag, Path, SPFDs) :-
    sle_do_cdtrs(CDs, Tag, [cdtrs|Path], SPFDs, Rest), !,
    sle_do_other_dtrs(R, Tag, Path, Rest).
sle_do_other_dtrs([mdtr = MD|R], Tag, Path, [ThisD|SPFDs]) :-
    !,
    ((eccs_memberchk(phon = P, MD), eccs_sys_nonvar(P)) -> 
    	ThisD = atomic(P);
        ThisD = sensitize(triangle(atomic('M')), 
		      insert_selection([mdtr|Path], Tag))),
    sle_do_other_dtrs(R, Tag, Path, SPFDs).
sle_do_other_dtrs([X|R], Tag, Path, Rest) :-
    eccs_message([unable, to, interpret, feature, in, 'dtrs:', X]),
    sle_do_other_dtrs(R, Tag, Path, Rest).

sle_do_cdtrs(Var, _, _, Rest, Rest) :-
    eccs_sys_var(Var), !.
sle_do_cdtrs(nil, _, _, Rest, Rest) :- !.
sle_do_cdtrs(List, Tag, Path, [ThisD|SPFDs], Rest) :-
    eccs_feature_really_there(first, List, F),
    eccs_feature_really_there(rest, List, RF), !,
    (\+ (sle_dc_phon_instantiated(F); eccs_memberchk(schema = X, F), eccs_sys_nonvar(X)) -> 
	ThisD = sensitize(triangle(atomic('C')),
			  insert_selection([first|Path], Tag))
      ; ThisD = NewDTRS,
        sle_dtrs2tree(F, Tag, [first|Path], NewDTRS)),
    sle_do_cdtrs(RF, Tag, [rest|Path], SPFDs, Rest).
    


spec_dc_do_insert(Key, InsertTag, SelTag, Out) :-
    sle_dc_lookup(SelTag, Sel),
    sle_dc_lookup(InsertTag, Insert),
    sle_interpret_insert(Key, Sel, Insert, Results),
    sle_do_results(Results, Out).

sle_do_results([], []).
sle_do_results([Result|Rest], [derivation(Tag, SPFTree)|Ds]) :-
    sle_note_derivation(Result, Tag),
    sle_obj2spf(Result, _Name, [], Tag, SPFTree),
    sle_do_results(Rest, Ds).


sle_dc_lookup(Tag, Schema) :- 
    Tag = schema(DBRef-Type-NumberOfDs),
    eccs_get_from_databaser(template, _, Def, DBRef),
    sle_expand_schema(Def, Tag, Type, NumberOfDs, _FS),
    Def = template(_, _, Schema).
sle_dc_lookup(lexical(DBRef), FS) :- !,
    sle_dc_lex_lookup(_Name, DBRef, FS).
sle_dc_lookup(derivation(DBRef), Derivation) :-
    eccs_sys_clause(sle_deriv_table(Derivation), _, DBRef).

sle_lex2fs(Lex, FS) :-
    Lex = template(lex(A:[], FS), _, _),
    eccs_graph_plus_constraints(FS, FSG, _),
    eccs_memberchk(phon = Phon, FSG),
    eccs_memberchk(first = A, Phon),
    eccs_memberchk(rest = nil, Phon).

:- dynamic sle_deriv_table/1.

sle_note_derivation(Result, derivation(Tag)) :-
    eccs_sys_assert(sle_deriv_table(Result), Tag).

/*

sle_interpret_insert(Key, Selection, Target, Result)

Here, Selection is the structure currently selected and Target is the 
structure in which Selection is to be inserted at a position determined by
Key.  

We pull the graphs and constraints apart and look for the material at the 
insertion point.  We graph unify the selection and insertion point, assuming 
that this will have side effect back into the target.  If successful, we 
then proceed to check constraints.  

*/

sle_interpret_insert(Key, Sel, Target, Rs) :-
    eccs_graph_plus_constraints(Target, TargetG, _),
    eccs_graph_plus_constraints(Sel, SG, _SC),
    (Key = [_|_] -> eccs_reverse(Key, Key1); Key1 = Key),
    sle_interpret_key(Key1, TargetG, TarSubG),
    (eccs_graph_unify(SG, TarSubG) -> true;
        sle_why_fail_graph(SG, TarSubG), fail),
    findall(R, eccs_user_unify(_, Target, R), Rs),
    (Rs = [] -> sle_why_fail_constraints(Sel, Key1, Target) ; true),
    eccs_message([insertion, succeeds]).


sle_interpret_key([], G, G) :- !.
sle_interpret_key([K|Ks], G, G1) :-
    sle_interpret_key(K, G, G2),
    sle_interpret_key(Ks, G2, G1).
sle_interpret_key(F, FS, SubGraph) :-
    eccs_sys_atomic(F),
    eccs_memberchk(F = SubGraph, FS).


    		  

    
spec_windows([window('Schemata', [900, 150], type(schema)), 
	      window('Lexical entries', [900, 200], type(lexical_entry)),
	      window('Derivation Window', [400, 400])]).

:- eccs_set_variable(eccs_spec_supports_dc, true).


spec_report(selection(Tag)) :-
    sle_tag_to_name_and_type(Tag, Type, Name),
    eccs_message([Type, Name, selected]).
spec_report(insertion_attempt(Sel, Key, Target)) :-
    sle_tag_to_name_and_type(Sel, SelType, SelName),
    sle_tag_to_name_and_type(Target, TType, TName),
    (Key = [_|_] -> eccs_reverse(Key, K1) ; K1 = [Key]),
    sle_print_form_of_key(K1, PF),
    eccs_message([attempting, to, insert, SelType, SelName, as,
		PF, TType, TName]).

sle_print_form_of_key(K, K) :-
    eccs_sys_atomic(K), !.
sle_print_form_of_key(K, PF) :-
    sle_print_form_of_key1(K, K1),
    eccs_interpolate_char(' ', K1, K2),
    eccs_concat_list(K2, PF).

sle_print_form_of_key1(L, L).

sle_tag_to_name_and_type(lexical(Tag), 'lexical entry', Name) :-
    sle_dc_lex_lookup(Name, Tag, _).
sle_tag_to_name_and_type(schema(DBRef-_Type-_Dtrs), schema, SName) :-
    eccs_get_from_databaser(template, _, Object, DBRef),
    Object = template(schema(Name:_), _, _),
    eccs_concat_list([schema, ' ', Name], SName).


sle_tag_to_name_and_type(derivation(Tag), derivation, '') :-
    sle_dc_lookup(derivation(Tag), _Deriv).


spec_delete_object(lexical(_)).
spec_delete_object(rule(_)).
spec_delete_object(derivation(Tag)) :-
    eccs_sys_erase(Tag).

spec_add_lexical(Tag, SPF)  :-
   eccs_do_menu(dbox, [ fields = [field('Lexical entry to add', '')],
	 		command=sle_prep_lexical('$$', Tag, SPF)]).

sle_prep_lexical(Atom, Tag, SPF) :-
    spec_dc_prepare(lexical_entry, Atom, Tag, SPF).



spec_add_parse(Tag, SPF) :-
    eccs_do_menu(dbox, [ fields = [field('String to parse', '')],
    			 command=sle_prep_parse('$$', Tag, SPF)]).

sle_prep_parse(Atom, derivation(Tag), SPF) :-
    eccs_sys_name(Atom, L),
    eccs_massage_input(L, list, eccs_generic_tokenizer, Massaged),
    eccs_sle_budc(Massaged, Parses),
    eccs_length(Parses, N),
    (N = 0 -> eccs_message([no, parses, found, for, Atom]), fail;
    	      eccs_message([N, 'parse(s)', found, for, Atom])),
    eccs_member(P, Parses),
    eccs_sle_parse2dc(P, Deriv),
    sle_note_derivation(Deriv, derivation(Tag)),
    eccs_sys_arg(1, Deriv, Name),
    sle_obj2spf(Deriv, Name, [], derivation(Tag), SPF).

    
    


eccs_sle_budc(L, Results) :-
    Results = [_|_],
    eccs_sle_satisfy_phon([], L, Results), !.
eccs_sle_budc(_, []).

eccs_sle_parse2dc(P, P).



    
spec_tag2strictspf(Tag, SPF) :-
    spec_dc_prepare(Tag, SPF1),
    dc_filter_sensitive(SPF1, SPF).

/*

c :- dc_close_all_windows.
o :- c, dc_start.

*/

spec_dc_options(
	[option('show full avm for selection', 
		 sle_show_fs, dc_last_selection(_)),
	 option('print full avm for selection',
	 	 sle_print_fs, dc_last_selection(_))]).

sle_show_fs :-
    dc_last_selection(Sel),
    sle_dc2fullspf(Sel, SPF, Name),
    dc_display_object(Name, SPF).
    
sle_print_fs :-
    dc_last_selection(Sel),
    sle_dc2fullspf(Sel, SPF, Cap), !,
    eccs_dc_hardcopy(captioned(Cap, SPF)).
    
/*

In the first clause below, we don't look until after computing SPF to
see whether we have a phonology.


*/
sle_dc2fullspf(derivation(Tag), SPF, Cap) :-
    sle_dc_lookup(derivation(Tag), Deriv),
    eccs_sle2std(Deriv, SPF),
    eccs_graph_plus_constraints(Deriv, Graph, _),
    eccs_memberchk(phon = P, Graph),
    'Full form of derivation' = Start,
    (sle_use_phon_for_caption(P, List) ->
        eccs_append(List, ['"'], Tail),
    	eccs_concat_list([Start, ' "'|Tail], Cap)
      ; Cap = Start).
sle_dc2fullspf(lexical(DBRef), SPF, Cap) :-
    sle_dc_lex_lookup(Name, DBRef, Def),    
    eccs_concat_list(['lexical entry "', Name, '"'], Cap),
    eccs_sle2std(Def, SPF).
sle_dc2fullspf(schema(Tag), SPF, Cap) :-
    Name = schema/1,
    Tag = DBRef-_Type-_Ds,
    eccs_get_from_databaser(template, Name, template(PName, Alias, Object), DBRef),
    sle_tag_to_name_and_type(schema(Tag), _, Cap),
    eccs_tem_sle2std(PName, Alias, Object, SPF).


/*

Extract a list from the phonology of some derivation, failing if we
can't do something sensible with it.

*/

sle_use_phon_for_caption(P, _) :-
    eccs_sys_var(P),
    !,
    fail.
sle_use_phon_for_caption([F, R|_], [A]) :-
    (F = (first = A), R = (rest = Rest)
    ;R = (first = A), F = (rest = Rest)),
    eccs_sys_atomic(A),
    Rest == nil,
    !.
sle_use_phon_for_caption([F, R|_], [A, ' '|T]) :-
    (F = (first = A), R = (rest = Rest)
    ;R = (first = A), F = (rest = Rest)), !,
    eccs_sys_atomic(A),
    eccs_sys_nonvar(Rest),
    sle_use_phon_for_caption(Rest, T).


/*

Diagnosis for failure

sle_why_fail_graph(Selection, Target) 

*/

sle_why_fail_graph(Selction, Target) :-
    sle_why_fail_graph_reasons(Selction, Target, Reasons),
    sle_report_graph_failure(Reasons).


sle_why_fail_graph_reasons(Selction, Target, Reasons) :-
    sle_why_fail_bfu(Selction, Target, [], Reasons, []).

/*

A breadth-first version of unify which records each most deeply
embedded failure.

*/

sle_why_fail_bfu(Selction, Target, _, Reasons, Reasons) :-
    eccs_graph_unify(Selction, Target), !.
sle_why_fail_bfu(Selction, Target, Path, [r(Path, Selction, Target)|Rs], Rs) :-
    (eccs_sys_atomic(Target); eccs_sys_atomic(Selction)), !.
sle_why_fail_bfu(Selction, Target, Path, ReasonsIn, ReasonsOut) :-
    sle_fs_defined_in(Selction, SFs), 
    sle_fs_defined_in(Target, TFs),
    eccs_intersection([SFs, TFs], Shared),
    sle_why_fail_bfu1(Shared, Selction, Target, Path, ReasonsIn, ReasonsOut).

sle_why_fail_bfu1([], _, _, _, Reasons, Reasons).  /* Shouldn't happen */
sle_why_fail_bfu1([F|Fs], Selction, Target, Path, ReasonsIn, ReasonsOut) :-
    eccs_memberchk(F = SV, Selction),
    eccs_memberchk(F = TV, Target),
    (eccs_graph_unify(SV, TV) -> 
	ReasonsIn = Reasons1
      ; sle_why_fail_bfu(SV, TV, [F|Path], ReasonsIn, Reasons1)),
    sle_why_fail_bfu1(Fs, Selction, Target, Path, Reasons1, ReasonsOut).


sle_why_fail_graph_reasons1(Selction, Target, r(Path, SV, TV)) :-
    sle_defined_path(Selction, Path, SV),
    sle_differs_on_path(Path, Target, SV, TV).

sle_report_graph_failure([]) :-
    eccs_message([unable, to, determine, cause, of, failure]), !.
sle_report_graph_failure(Reasons) :-
    (Reasons = [_] -> Rs = 'reason:' ; Rs = 'reasons:'),
    eccs_sys_nl,
    eccs_message([insertion, fails, for, the, following, Rs]),
    sle_report_graph_failure1(Reasons).

sle_defined_path(Selction, Path, Value) :-
    sle_defined_path(Selction, Path, [], Value).

sle_defined_path(Var, Path, Path, Var) :-
    eccs_sys_var(Var), !.
sle_defined_path(Atom, Path, Path, Atom) :-
    eccs_sys_atomic(Atom), !.
sle_defined_path([F = V|Rest], P, Path, Value) :-
    sle_defined_path1([F = V|Rest], P, Path, Value).
    


sle_defined_path1(Rest, _, _, _) :-
    eccs_sys_var(Rest), !,		% tail variable
    fail.
% sle_defined_path1([F = V|_], [F|P], P, V).
sle_defined_path1([F = V|_], [F|P], Path, Value) :-
    sle_defined_path(V, P, Path, Value).
sle_defined_path1([_|Rest], P, Path, Value) :-
    sle_defined_path1(Rest, P, Path, Value).

sle_differs_on_path([], TV, SV, TV) :-
    \+ (SV = [_|_], TV = [_|_]),
    \+ eccs_graph_unify(SV, TV), !.
sle_differs_on_path([], TV, SV, TV) :-
    eccs_sys_atomic(SV),
    eccs_sys_atomic(TV),
    \+ SV = TV.
sle_differs_on_path([P|_], TV, _, TV) :-
    \+ eccs_memberchk(P = _, TV), !.
sle_differs_on_path([P|Ps], Target, SV, TV) :-
    eccs_memberchk(P = TV1, Target), 
    sle_differs_on_path(Ps, TV1, SV, TV).

sle_report_graph_failure1([]).
sle_report_graph_failure1([r(Path, SV, TV)|Rs]) :-
    (eccs_sys_atomic(SV) -> SVPrint = [SV];
    	SVPrint = [a, complex, value]),
    (eccs_sys_atomic(TV) -> TVPrint = [TV];
    	TVPrint = [a, complex, value]),
    eccs_append([selection, has, '  '], SVPrint, SVP1),
    eccs_append([while, target, has], TVPrint, TVP1),
    eccs_reverse(Path, PRev),
    sle_list_to_path(PRev, Colons),
    eccs_message(['As', value, for, the, path, Colons]),
    eccs_message(SVP1),
    eccs_message(TVP1),
    eccs_message([]),
    sle_report_graph_failure1(Rs).

sle_list_to_path([], '') :- !.
sle_list_to_path([Last], Last) :- !.
sle_list_to_path([H|T], ':'(H, Rest)) :-
    sle_list_to_path(T, Rest).


    
    
sle_fs_defined_in(Var, []) :-
    eccs_sys_var(Var), !.
sle_fs_defined_in([], []) :-		% shouldn't happen with open ends
    !.
sle_fs_defined_in([F = _|G], [F|Rest]) :-
    sle_fs_defined_in(G, Rest).


/*

Diagnosis of constraint failure

*/

sle_why_fail_constraints(Sel, _Key, Tar) :-
    sle_dc_diagnose_constraints(Sel, Tar).

sle_dc_diagnose_constraints(SelG:SelCs, TarG:TarCs) :-
    eccs_append(SelCs, TarCs, AllCs),
    sle_dc_diagnose_constraints1(AllCs, SelG, TarG).

/*

Additions JC Wed Mar 10 11:55:53 1993

sle_dc_diagnose_constraints1(Cs, SelG, TarG)

Cs = constraints, SelG = selected/inserted graph, TarG = graph
containing insert point.

based on eccs_check_constraints/2 in generic.pl

*/

sle_dc_diagnose_constraints1(Cs, SelG, TarG) :-
    (Cs = [] -> 
	eccs_message([unable, to, determine, reason, for, failure])
      ; sle_dc_diagnose_constraints2(Cs, SelG, TarG)).

sle_dc_diagnose_constraints2(Cs, SelG, TarG) :-
    sle_diagnose_cvs(Cs, Out, SelG, TarG),
    sle_dc_diagnose_constraints3(Out, SelG, TarG).	


/*

The following based on eccs_eval_cvs/2

*/

sle_diagnose_cvs([], [], _, _).
sle_diagnose_cvs([NC|CsIn], CsOut, Sel, Tar) :-
    eccs_constraints_structure(Node, Cs, NC),
    eccs_get_all_constraint_type(cv, Cs, CVars, Rest),
    (CVars = [] -> CsOut =[NC|OutCs1];
    	sle_diagnose_cvs1(CVars, Rest, Node, CsOut, OutCs1, Sel, Tar)),
    sle_diagnose_cvs(CsIn, OutCs1, Sel, Tar).


/*

This needs to be a real diagnosis

*/
sle_diagnose_cvs1(CVars, Rest, Node, CsOut, OutCs1, _Sel, _Tar) :-
    eccs_eval_cvs1(CVars, Rest, Node, CsOut, OutCs1).

/*

sle_dc_diagnose_constraints3(Cs, SelG, TarG). 

This is really eccs_check_constraints0/2

*/


sle_dc_diagnose_constraints3(Cs, SelG, TarG) :-
    sle_dc_check_constraints(Cs, CsOut, SelG, TarG), !,
    (Cs == CsOut -> 
	eccs_message([constraint, satisfaction, terminated, without, inconsistency])
      ; sle_dc_diagnose_constraints3(CsOut, SelG, TarG)).
/*

If we get to the next clause, we know that we have failed in 
sle_dc_check_constraints above.  

*/

sle_dc_diagnose_constraints3([Constraints|Rest], SelG, TarG) :-
    eccs_constraints_structure(CurrentNode, CurrentCs, Constraints),
    eccs_get_all_node_constraints(CurrentNode, Rest, RestCurrentCs, _RestCs),
    eccs_opt_append(CurrentCs, RestCurrentCs, AllCurrentCs),
    sle_dc_diagnose_constraints4(CurrentNode, AllCurrentCs, SelG, TarG).


sle_dc_check_constraints([Constraints|Rest], Out, _SelG, _TarG) :-
	eccs_constraints_structure(CurrentNode, CurrentCs, Constraints),
	eccs_get_all_node_constraints(CurrentNode,Rest, RestCurrentCs,RestCs),
	eccs_opt_append(CurrentCs, RestCurrentCs, AllCurrentCs),
        sle_dc_eval_constraints(CurrentNode, 
	                      AllCurrentCs, 
			      NewCurrentCs, RestCs, RestCsOut),
 	eccs_append(RestCsOut, NewCurrentCs, Out).
	

sle_dc_eval_constraints(Node, Constraints, NewConstraints, OtherCs, OtherCsOut) :-
	eccs_merge_constraint_values(Constraints, ConstraintLists),
	sle_dc_eval_constraints0(Node, ConstraintLists, NewConstraints, OtherCs, OtherCsOut).


sle_dc_eval_constraints0(Node, Constraints, NewConstraints, OtherCs, OtherCsOut) :-
	eccs_check_instantiations(Node, Constraints, C0, OtherCs, OtherCs1),
    	eccs_check_bit_constraints(Node, C0, C1),
	eccs_check_disjunction_constraints(Node, C1, C2, RemainingDs),
	eccs_check_negation_constraints(Node, C2, C3, RemainingNs),
	eccs_cross_check(RemainingDs, RemainingNs, C3, C4, Node),
	eccs_check_implication_constraints(Node, C4, C5),
	sle_dc_check_template_constraints(Node, C5, C6, OtherCs1, OtherCsOut),
	eccs_check_type_constraints(Node, C6, NewConstraints).


sle_dc_check_template_constraints(Node, Constraints, NewConstraints, Cs, CsOut) :-
	eccs_get_constraint_type(temp, Constraints, Temp, Rest),
	sle_dc_template_expansion(Node, Temp, NewTemp, Rest, RestOut, Cs, CsOut),
	eccs_sys_if_then_else(NewTemp = [],
	                      NewConstraints = RestOut,
			      NewConstraints = [ temp = NewTemp | RestOut ] ).


sle_dc_template_expansion(_Node, [], [], R, R, Cs, Cs) :- !.

% if unsatisfied wait statements exist, delay expansion.
% The logic here is that there is at least one wait statement for this template
% but that there is no such statement that holds.  Then we cut and delay.
% Otherwise we fail.  Note that the next clause but one holds only if
% there are no such statements. 

% Wed Dec 11 15:27:18 1991 JC
% The third clause, i.e. the one that runs if there is real work to do,
% substantially altered to allow for the tracing of template expansion. 
% This is only in a preliminary state, and should ultimately be made 
% much more flexible.  

% Thu Jan 30 21 13:50:17 1992 CB
% the hooks in sledebug.pl now spy and unspy templates with given names
% and the menu names have been changed accordingly

sle_dc_template_expansion(Node, [Temp|Ts], [Temp|Ts1], R, R1, Cs, Cs1) :-
	eccs_template_count(Temp, _Count, TName, _),
    	eccs_verify( eccs_wait_template(TName, Locus, Args)),
	(eccs_wait_template(TName, Locus, Args),
	eccs_constraints_structure(Node, R, Constraints),
	eccs_wake_up(Node, TName, [Constraints|Cs], Locus, Args) -> fail; !),
%	\+ eccs_wake_up(Node, TName, [Constraints|Cs], Locus, Args), !,
	sle_dc_template_expansion(Node, Ts, Ts1, R, R1, Cs, Cs1).
% if default not deterministic, and no explicit deterministic statement,
% delay expansion if uninstantiated locus.
sle_dc_template_expansion(Node, [Temp|Ts], [Temp|Ts1], R, R1, Cs, Cs1) :-
	eccs_sys_var(Node),
	eccs_template_count(Temp, _Count, TName, _),
	\+ eccs_wait_template(TName, _, _),
	eccs_global_variable(deterministic_templates, false),
	\+ eccs_deterministic_template(TName), !,
	sle_dc_template_expansion(Node, Ts, Ts1, R, R1, Cs, Cs1).

% expand all other cases, i.e.:
% wait statements satisfied, deterministic template, instantiated locus, or
% strategy is 'eager'.
sle_dc_template_expansion(Node, [Temp|Ts], Ts1, R, R1, Cs, Cs1) :-
	eccs_template_count(Temp, _Count, TName, N),
	eccs_maybe_trace(TName, N),
	eccs_sys_if_then_else(sle_spy(TName), sle_spy_template(TName, N, Node), true),
	eccs_template_definition(TName, Defn, Node),
	M is N+1,
	eccs_mark_templates(Defn, Defn2, M),
	eccs_graph_plus_constraints(GC, Node, []),
%	eccs_user_unify(Defn2, GC, NewGC),
	eccs_graph_plus_constraints(Defn2, D2G, TempCs),
	eccs_graph_unify(Node, D2G),
	eccs_graph_plus_constraints(NewGC, _, NewCs),
	sle_dc_template_expansion(Node, Ts, Ts1, R, R1, Cs, Cs2),
	eccs_opt_append(NewCs, Cs2, Cs0),
	eccs_opt_append(TempCs, Cs0, Cs1),
	eccs_maybe_trace_exit(TName, N).



/*

sle_dc_diagnose_constraints4(CurrentNode, AllCurrentCs, SelG, TarG)

Now the real work starts.

Current node is a node at which sle_dc_check_constraints/2 failed.

AllCurrentCs is the set of constraints at that node

SelG and TarG are the selection and target graphs.

sle_dc_diagnose_constraints4(_CurrentNode, [], _SelG, _TarG) :-
    eccs_message([unable, to, determine, reason, for failure]).


*/

sle_dc_diagnose_constraints4(CurrentNode, Fails, SelG, TarG) :-
    sle_dc_locate_node_in_graph(CurrentNode, SelG, SPaths),
    sle_dc_locate_node_in_graph(CurrentNode, TarG, TPaths),
    eccs_sys_nl,
    sle_dc_report_locations(selection, SPaths),
    sle_dc_report_locations(target, TPaths),
    sle_dc_report_reasons(CurrentNode, Fails, SelG, TarG).

sle_dc_locate_node_in_graph(Node, Graph, Paths) :-
    findall(Path, sle_dc_locate_node_in_graph1(Node, Graph, Path), Paths).

/*

The first case here covers atoms, identical vars or complex graphs

*/
sle_dc_locate_node_in_graph1(Node, Graph, []) :-
    Node == Graph, !.		
sle_dc_locate_node_in_graph1(Node, Graph, Path) :-
    eccs_sys_nonvar(Node), Node = [_|_], 
    eccs_sys_nonvar(Graph), Graph = [_|_],
    eccs_tail(Node, V),
    eccs_tail(Graph, V1),
    (V == V1  -> 
	Path = []
      ; eccs_member(FV, Graph),
        (eccs_sys_var(FV) -> 
	    !, fail
	  ; FV = (F = Val),
	    Path = [F|Tail], 
	    sle_dc_locate_node_in_graph1(Node, Val, Tail))).
    


/*

sle_dc_report_locations(Position, Paths) 

Position \in target, selection

The constraint in question holds at Paths

*/

sle_dc_report_locations(Position, []) :-
    eccs_message([the, failing, constraint, does, not, constrain, the, Position]), 
    !.
sle_dc_report_locations(Position, Paths) :-
    eccs_message([the, failing, constraint, constrains, the, Position, at]), 
    eccs_message([the, following, 'location(s):']),
    eccs_member(P, Paths),
    (P = [] -> eccs_message([the, root, node]); sle_path_message(P)),
    fail.
sle_dc_report_locations(_, _).

sle_path_message([]) :-
    eccs_sys_nl.
sle_path_message([H|T]) :-
    eccs_sys_write(H), 
    (T = [_|_] -> eccs_sys_write(':'); true),
    sle_path_message(T).
/*

sle_dc_report_reasons(CurrentNode, Fails, SelG, TarG).

*/

sle_dc_report_reasons(_, [], _, _) :-
    eccs_message([unable, to, determine, reasons, for, failure]).
sle_dc_report_reasons(CN, Cs, _, _) :-
    eccs_member(C, Cs),
    sle_dc_report_reasons1(CN, C),
    fail.

/*

A global fail is necessary at the last line above in order for 
insert_selection to fail.

*/

sle_dc_report_reasons1(CN, Type = Cs) :-
    sle_dc_report_reasons1(Type, CN, Cs).


sle_dc_report_reasons1(temp, _CN, Ts) :-
    (Ts = [T] -> 
        eccs_template_count(T, _, TArgs, _),
	eccs_template_name(TArgs, TName), 
	eccs_message([expansion, fails, for, template, TName])
      ; eccs_message([expansion, fails, for, one, or, more, of, the, 'templates:']),
        eccs_member(T, Ts),
        eccs_template_count(T, _Count, TArgs, _),
	eccs_template_name(TArgs, TName),
	eccs_message([TName])).

