/*
 rcsid('$Id: slemain.pl,v 1.60 1993/05/04 09:43:01 pleuk Exp $').
 $Log: slemain.pl,v $
% Revision 1.60  1993/05/04  09:43:01  pleuk
% Version 1.00beta from Jo
%
% Revision 1.5  1992/04/16  13:43:35  pleuk
% revisions from SLE - April 1992
%
% Revision 1.3  1992/01/29  15:57:16  chrisbr
% Jo's changes reconciled with our own.
%
*/
:- eccs_srcload(['ops.pl', 
	'generic.pl', 
	'srcparser.pl',			% The simple parser
	'printers.pl',
	'slemenus.pl',
	'sledebug.pl',
 	'sletemplates.pl']).



/*

Reader for the term based system.

eccs_term_unif_reader(_, Name, Type, Definition)

*/

eccs_sle_unif_reader(_, Name, Type, Definition) :-
    eccs_sys_read(X),
    (X == end_of_file, X = Name -> X = Definition; 
    	(X = source(File) -> Definition = source(File); 
	    eccs_well_formed_grammar_object(X, Name, Type, Definition))).


/*

eccs_well_formed_grammar_object(X, Name, Type, Definition).

Check for high-level well-formedness and Name and Type

*/

eccs_well_formed_grammar_object(Word: Definition, 
		Word, lexical_entry, Definition).
eccs_well_formed_grammar_object(lexical_rule(Name, Defn), 
		Name, lexical_rule, Defn).
eccs_well_formed_grammar_object((Name => ( Mother --> Daughters)), 
		Name, grammar_rule, grammar_rule(Mother, Daus)) :-
        eccs_commas_to_list(Daughters, Daus).
eccs_well_formed_grammar_object(rule(Name,  Mother, Daughters), 
		Name, grammar_rule, grammar_rule(Mother, Daughters)).


eccs_well_formed_grammar_object(aliases(Name, Definition), 
		TName, template, Obj) :-
    eccs_template_name(Name, TName),
    (\+(Name == TName ) ->		% attempt to define a param. template as an alias
	(eccs_warning([parameterized, templates, may, not, be, 'aliases:', Name]),
	 Obj = (Name => Definition));
	Obj = aliases(Name, Definition)).


eccs_well_formed_grammar_object((Name => Definition), TName, template, (Name => Definition)) :-
    eccs_template_name(Name, TName).	% needed for parameterized templates--does this make sense for aliases?


eccs_well_formed_grammar_object(Wait, wait_statement, control, wait(L)) :-
    Wait =.. [(wait)|L].
eccs_well_formed_grammar_object(deterministic(T/N), deterministic, control, deterministic(T/N)) :-
    eccs_sys_atomic(T), !,
    eccs_sys_integer(N).
eccs_well_formed_grammar_object(deterministic(T), deterministic, control, deterministic(T)) :-
    eccs_sys_atomic(T).

eccs_well_formed_grammar_object(enumerated_type(TName, Set), 
		TName, enumerated_type, enumerated_type(TName, Set)).
eccs_well_formed_grammar_object(closed_type(TName, FS), 
		TName, closed_type, closed_type(TName, FS)).
eccs_well_formed_grammar_object(restricted_feature(FName, Type), 
		FName, restricted_feature, restricted_feature(FName, Type)).





/*

Compilers for the SLE system

*/

eccs_generic_sle_compiler(templates,template, Name, _Args, Defn, CDefn, []) :-
    eccs_template(Defn, CDefn).
eccs_generic_sle_compiler(lexical_rules, lexical_rule, Name, _Args, Defn, CDefn, []) :-
    eccs_lexical_rule(Defn, CDefn).
eccs_generic_sle_compiler(dictionary, lexical_entry, Name, _Args, Defn, CDefn, []) :-
    eccs_lexical_entry(Name, Defn, CDefn).

eccs_generic_sle_compiler(templates, control, wait_statement, _, wait([TName|L]), wait(TName, Locus, Args), []) :-
    
    eccs_process_list_of_fs(L, L1),
    eccs_append(Args, [Locus], L1).

eccs_generic_sle_compiler(templates, control, deterministic, _, 
		deterministic(TName), deterministic(TName), []). 

eccs_grammar_rule(grammar_rules, grammar_rule, Name, _Args, grammar_rule(Mother, Daughters), CDefn, []) :-
    eccs_process_list_of_fs([Mother|Daughters], [M1|D1]),
    eccs_reverse(D1, D1R),
    CDefn = rule(M1, D1R).

eccs_lexical_rule(Defn, lexical_rule(In, Out)) :-
    eccs_user_empty_structure(In1),
    eccs_user_empty_structure(Out1),
    eccs_lexical_rule(Defn, In1, Out1, ST, 0, _, In, Out).

eccs_lexical_rule([], In, Out, ST, N, N, In, Out) :- !.
eccs_lexical_rule([LRule|R], In1, Out1, ST, M, N, In, Out) :-
    eccs_sys_atomic(LRule), 
    eccs_get_from_database(lexical_rule, LRule, lexical_rule(LRIn, LROut)),
    eccs_user_unify(In1, LRIn, In2),
    eccs_user_unify(Out1, LROut, Out2),
    eccs_lexical_rule(R, In2, Out2, ST, I, N, In, Out).
eccs_lexical_rule([:in = Defn|R], In1, Out1, ST, M, N, In, Out) :-
    eccs_template1_rhs(Defn, In1, In2, ST, M, I),
    eccs_lexical_rule(R, In2, Out1, ST, I, N, In, Out).
eccs_lexical_rule([:out = Defn|R], In1, Out1, ST, M, N, In, Out) :-
    eccs_template1_rhs(Defn, Out1, Out2, ST, M, I),
    eccs_lexical_rule(R, In1, Out2, ST, I, N, In, Out).
    


eccs_process_list_of_fs(Defns, FSs) :-
    eccs_process_list1(Defns, _, FSs).

eccs_process_list1([], _, []).
eccs_process_list1([D|Ds], ST, [FS|FSs]) :-
    eccs_user_empty_structure(New),
    eccs_graph(New, Graph),
    eccs_template1_rhs(D, Graph, New, FS, ST),
    eccs_process_list1(Ds, ST, FSs).



/*

Info interface 


*/

eccs_spec_info(sle).
