
/*

rcsid('$Id: sletemplates.pl,v 1.60 1993/05/04 09:43:01 pleuk Exp $').


$Log: sletemplates.pl,v $
% Revision 1.60  1993/05/04  09:43:01  pleuk
% Version 1.00beta from Jo
%
% Revision 1.5  1992/04/16  13:43:35  pleuk
% revisions from SLE - April 1992
%
%Revision 1.5  1992/02/11  10:29:16  chrisbr
%Changes to parser and debugging routines. Dead code removed
%
%Revision 1.4  1992/01/29  16:03:27  chrisbr
%Jo's changes integrated with SLE's
%
%Revision 1.1.1.2  1992/01/28  11:56:21  chrisbr
%Jo Calders changes
%
% Revision 1.4  1992/01/24  12:14:29  pleuk
% revisions from Jo - January 1992
%
% Revision 1.3  1991/10/21  12:51:29  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 1.2  1991/09/25  13:11:10  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 1.1  1991/09/16  19:20:11  pleuk
% Initial revision
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

Wed Dec 11 15:01:27 1991  JC

Numerous changes to do with the sort module and junking singleton vars.  

*/


/*                                                                           */
/* global variables controlling parsing behaviour - settable from top level  */
/*                                                                           */

:- eccs_new_variable(deterministic_templates, true, parsing, run,
	"Assume all templates without explicit wait statements are deterministic").

:- eccs_new_variable(template_expansion_limit, 10, parsing, run,
	"The absolute limit on template expansion").

/* The following variable gets ``literal'' wrapped around it because
it's going ultimately to get interpreted as a context variable.

This is not ideal, but will work until a more general solution is found. 
The point is that the words phonology and first should be context
dependent, since they are what determine what has to be done in order to
insert a phonology into a feature structure. The same issue arises in the
phonology satisfier in srcparser.pl
*/

:- eccs_new_variable(path_for_lex_symbol, literal(phonology:first), parsing, run,
         "Path under which the string that appears in a word's definition will be stored").

/*

Printing variables

*/

:- eccs_new_variable(trace_templates, false, parsing, run,
	"Whether or not to trace template expansion").
:- eccs_new_variable(no_trace_templates, [], parsing, run,
        "A list of those templates which should be traced").


/*                                                                           */
/* Lexical Entry compiler called by pleuk.                                   */
/*                                                                           */

eccs_lexical_entry(Word, Defn, CDefn) :-
    eccs_eval_cv(path_for_lex_symbol, Path),
    eccs_path_append(Path, Word, FVPair),
    eccs_user_empty_structure(X),
    eccs_graph(X, Graph),
    eccs_template1_path_value(FVPair, Graph, X, Out, ST),
    eccs_template1(Defn, Graph, Out, CDefn, ST).


eccs_path_append(A:X, B, A:C) :- !,
    eccs_path_append(X, B, C).
eccs_path_append(A, B, A:B).



/*                                                                           */
/* Template compiler called by pleuk.                                        */
/*                                                                           */

/* eccs_template(+TemplateIn, -CTemplateOut)

external definition TemplateIn has the internal form CTemplateOut
*/

eccs_template(aliases(Name, Defn), template(PName, alias, CDefn)) :-
    eccs_template(Name, PName, Defn, CDefn).

eccs_template((Name => Defn), template(PName, not_an_alias, CDefn)) :-
    eccs_template(Name, PName, Defn, CDefn).



/* eccs_template(+TemplateName, -NameParams, +DefnIn, -CDefnOut)

TemplateName may be any term.  For parameterized templates it is
nonatomic.  In this case NameParams is TemplateName with the
arguments set, otherwise it is just TemplateName.  
An empty graph, with no constraints, is constructed and passed to
eccs_template1_rhs/5.
*/

eccs_template(Name, NameParams, DefnIn, CDefnOut) :-
    eccs_user_empty_structure(Graph_plus_Constraints),
    eccs_graph(Graph_plus_Constraints, Graph),
    eccs_template1_rhs(DefnIn, Graph, Graph_plus_Constraints, CDefnOut, ST),
    eccs_do_template_args(Name, ST, NameParams).



/* eccs_template1_rhs(DefnIn, Graph, GCIn, CDefnOut, ST)

DefnIn is the part of the right-hand side of the current template
which remains to be processed.  CDefnOut is the result of adding any
constraints arising from DefnIn to GCIn.
*/

eccs_template1_rhs(Var, Var, GCIn, GCIn, _ST) :- 
	eccs_sys_var(Var), !.

eccs_template1_rhs(Key#Exp, Graph, GCIn, GCOut, ST) :- 
    	eccs_sys_integer(Key), !,
	eccs_variable(#Key, G1, ST),
	eccs_graph_unify(Graph, G1),
	eccs_template1_rhs(Exp, Graph, GCIn, GCOut, ST).

eccs_template1_rhs(Exp#Key, Graph, GCIn, GCOut, ST) :- 
    	eccs_sys_integer(Key), !,
	eccs_variable(#Key, G1, ST),
	eccs_graph_unify(Graph, G1),
	eccs_template1_rhs(Exp, Graph, GCIn, GCOut, ST).

eccs_template1_rhs(Value0::Type, Graph, GCIn, GCOut, ST) :- !,
	eccs_template1(Value0::Type, Graph, GCIn, GCOut, ST).

eccs_template1_rhs(`Term, 'PROLOG'(Term), GCIn, GCIn, _ST) :- !.

eccs_template1_rhs([], _, GCIn, GCIn, _ST) :- !.
eccs_template1_rhs([H|T], Graph, GCIn, GCOut, ST) :- !,
	eccs_template1([H|T], Graph, GCIn, GCOut, ST).

eccs_template1_rhs(V, Graph, GCIn, GCOut, ST) :- 
	eccs_template1_path_value(V, Graph, GCIn, GCOut, ST). 



/* eccs_template1(DefnInList, Graph, GCIn, GCOut, ST)

eccs_template1/5 takes a list of elements defining a template and
creates a term from them.  The elements of the list can be:
  i. template names, 
 ii. FS::Sort pairs, 
iii. path equations and 
 iv. feature-value structures (using the f:v notation).  
Each element of the list is processed by eccs_template1_element/5.  
*/

eccs_template1([], _, GCIn, GCIn, _ST) :- !.

eccs_template1([H|T], Graph, GCIn, GCOut, ST) :- !,
        eccs_template1_element(H, Graph, GCIn, GCOut1, ST),
        eccs_template1(T, Graph, GCOut1, GCOut, ST).

/*

Here we wrap a tag bits(_) around the bits specification.  This is 
because the rest of the constraint evaluation stuff expects things to come in 
lists of constraints.  As the bits come out of the sort module in a list, 
we want to avoid losing that list structure under append, etc.

*/

eccs_template1((T :: Sort), Graph, GCIn, GCOut, ST) :- !,
        eccs_template1(T, Graph, GCIn, GCIn1, ST),
	eccs_translate_formula(Sort,  Bits),
	eccs_sys_if_then_else(eccs_add_constraint(bits, bits(Bits), Graph, GCIn1, GCOut, ST),
		true,
		eccs_error([sort, specification, Sort, is, inconsistent,
			    with, present, information])).

eccs_template1(@T, Graph, GCIn, GCOut, ST) :- !,
	eccs_template1_template(T, Graph, GCIn, GCOut, ST).

eccs_template1(T, Graph, GCIn, GCOut, ST) :- 
    	eccs_user_possible_ptemplate(T), 
	eccs_template1_template(T, Graph, GCIn, GCOut, ST).



/* eccs_template1_element(Item, Graph, GCIn, GCOut, ST)

eccs_template1_element/5 processes an element of a list defining a
template.  The four possible types are listed above.
*/

eccs_template1_element(@T, Graph, GCIn, GCOut, ST) :- !,
	eccs_template1_template(T, Graph, GCIn, GCOut, ST). 

eccs_template1_element((F:V), Graph, GCIn, GCOut, ST) :- !,
	eccs_template1_path_value((F:V), Graph, GCIn, GCOut, ST). 

eccs_template1_element([H|T], Graph, GCIn, GCOut, ST) :- !,
        eccs_template1_element(H, Graph, GCIn, GCOut1, ST),
	eccs_template1_element(T, Graph, GCOut1, GCOut, ST).

eccs_template1_element(type(Type), Graph, GCIn, GCOut, ST) :- !,
        eccs_template1_type(Type, Graph, GCIn, GCOut, ST).

eccs_template1_element(~(N), Graph, GCIn, GCOut, _ST) :- !,
    	eccs_template1_negation(N, Graph, GCIn, GCOut).

eccs_template1_element(T, Graph, GCIn, GCOut, ST) :- 
    	eccs_user_possible_ptemplate(T), !,
	eccs_template1_template(T, Graph, GCIn, GCOut, ST). 

/* error ?? */



/* eccs_template1_path_value(Item, Graph, GCIn, GCOut, ST)

eccs_template1_path_value/5 handles the values or right hand side of
path equations.  The possible value types are variables (extremely
useful) , path equations, feature-value structures, template names,
and the + notation and of course atomic values.

There is some redundancy between this and the preceding clauses, but
it appears useful to separate things out in this way.  The clauses
here have been rearranged so that one has to wade through less in
debugging.
*/

eccs_template1_path_value((F:V), Graph, GCIn, GCOut, ST) :- !,   % ??? CUT ???
    eccs_template1_path(F, Graph,  Value),
    eccs_template1_rhs(V, Value, GCIn, GCOut, ST).
eccs_template1_path(FName, Graph, Value) :-
    eccs_memberchk(FName = Value, Graph).

eccs_template1_path_value(@T, Graph, GCIn, GCOut, ST) :- !,
	eccs_template1_template(T, Graph, GCIn, GCOut, ST).

eccs_template1_path_value(cv(CV), Graph, GCIn, GCOut, ST) :-
    !,
    (eccs_sys_atomic(CV) -> eccs_add_constraint(cv, CV, Graph, GCIn, GCOut, ST);
     eccs_error([nonatomic, context, variable, CV])).

eccs_template1_path_value(Atom, Atom, GCIn, GCIn, _ST) :- 
	eccs_sys_atomic(Atom), !.

eccs_template1_path_value(V, Graph, GCIn, GCIn, ST) :- 
        eccs_variable(V, Val, ST), !,
	eccs_graph_unify(Graph, Val).

eccs_template1_path_value(V, Graph, GCIn, GCOut, ST) :- 
	eccs_valid_constraint(V), !,
        eccs_attach_constraint(V, Graph, GCIn, GCOut, ST).

eccs_template1_path_value(T, Graph, GCIn, GCOut, ST) :- !,
    	eccs_user_possible_ptemplate(T),  % Assume we've caught all the special
	eccs_template1_template(T, Graph, GCIn, GCOut, ST).      % cases above.





/* eccs_template1_template(T, Graph, GCIn, GCOut, ST)

Add the template constraint specified by T to the node Graph, add the result 
of this to the GCIn graph/constraints to yield GCOut.
*/

eccs_template1_template(T, Graph, GCIn, GCOut, ST) :- 
    eccs_add_constraint(temp, T, Graph, GCIn, GCOut, ST).



/* eccs_do_template_args(TemplateIn, SymbolTable, TemplateOut)

Process the arguments of a parametrised template, substituting SLE
variables from the current symbol table ST with prolog variables.
*/

eccs_do_template_args(T, ST, TOut) :-
    eccs_sys_functor(T, F, N),
    eccs_sys_functor(TOut, F, N),
    eccs_do_template_args1(T, ST, TOut, N).

eccs_do_template_args1(_, _, _, 0) :- !.
eccs_do_template_args1(T, ST, TOut, N) :-
    eccs_sys_arg(N, T, Value),
    eccs_sys_arg(N, TOut, ValueOut),
    eccs_user_empty_structure(In),
    eccs_graph(In, Graph),
    eccs_template1_rhs(Value, Graph, In, ValueOut, ST),
    eccs_succ(M, N),
    eccs_do_template_args1(T, ST, TOut, M).


/*

eccs_template1_negation(N, Graph, GCIn, GCOut)

N is a constraint attached to Graph.  It may take either the form 

f:[] 

or

f:atom

*/

eccs_template1_negation((F:[]), Graph, GCIn, GCOut) :-
    eccs_sys_atomic(F), !,
    eccs_add_constraint(instant, (F:'$$TOP$$'), Graph, GCIn, GCOut, _).
eccs_template1_negation((F:A), Graph, GCIn, GCOut) :-
    eccs_sys_atomic(F), 
    eccs_sys_atomic(A), !,
    eccs_add_constraint(instant, (F:A), Graph, GCIn, GCOut, _).
eccs_template1_negation(X, _Graph, _GCIn, _GCOut) :-
    eccs_warning([illegal, constraint, on, feature, 'structure: ', '$nl$',
    		  X, '$nl$',
		  use, 'feature:atom', or, 'feature:[]']).


    
 

/* eccs_attach_constraint(C, Graph, GCIn, GCOut, ST)

Attach the constraint specified by C to the node Graph, add the result 
of this to the GCIn graph/constraints to yield GCOut.
*/

eccs_attach_constraint((A v B), Graph, In, Out, ST) :-
    eccs_disj_to_list((A v B), List),
    eccs_add_constraint(disj, List, Graph, In, Out, ST).

eccs_disj_to_list((A v B), List) :-
    eccs_disj_to_list((A v B), List, []).
eccs_disj_to_list((A v B), L, L0) :- !,
    eccs_disj_to_list(A, L, L1),
    eccs_disj_to_list(B, L1, L0).
eccs_disj_to_list(X, [X|L0], L0) :-
    eccs_sys_atomic(X), !.
eccs_disj_to_list(X, [X|L0], L0) :-
    eccs_warning(['non-atomic', element, in, 'disjunction:', X]).


eccs_attach_constraint((~ N), Graph, In, Out, ST) :-
    (eccs_sys_atomic(N) -> true; 
     eccs_warning(['non-atomic', 'negation:', N])),
    eccs_add_constraint(neg, [N], Graph, In, Out, ST).


eccs_attach_constraint((A -> B), Graph, In, Out, ST) :-
    eccs_attach_constraint(((A -> B); [] & [] ), Graph, In, Out, ST).
eccs_attach_constraint(((A -> B);C), Graph, In, Out, ST) :-
    eccs_value(A, A1, ST),
    eccs_imp_rhs(B, B1, ST),
    eccs_imp_rhs(C, C1, ST),
    eccs_add_constraint(imp, imp(A1, B1, C1), Graph, In, Out, ST).

eccs_imp_rhs(A & B, A1 & B1, ST) :-
    eccs_value(A, A1, ST),
    eccs_value(B, B1, ST).





/* eccs_template_name(Term, Name)

How we map between template names and their internal representation.
For non-parameterized templates, the names are just atoms and this is
the identity map; otherwise, we use the prolog convention, i.e.
foo(#1, #2, #3) <-> foo/3 
*/

eccs_template_name(Definition, Name/N) :-
    eccs_sys_functor(Definition, Name, N), 
    N > 0,
    !.
eccs_template_name(Definition, Definition).

/* eccs_template_parameters(Temp, Params) 

Template Temp has Params as its supplied parameters. 
*/

eccs_template_parameters(Temp, Params) :-
    Temp =.. [_|Params].


/* eccs_value(Defn, Out, ST)

definition Defn corresponds to internal form Out, with bindings ST.
*/

eccs_value(Defn, Out, ST) :-
    eccs_user_empty_structure(In),
    eccs_graph(In, Graph),
    eccs_template1_rhs(Defn, Graph, In, Out, ST).


eccs_variable(#N, Val, ST) :-
    eccs_memberchk(N = Val, ST).


eccs_valid_constraint(Term) :-
    eccs_sys_functor(Term, F, _N),
    eccs_memberchk(F, ['v', '&', '~', '->', ';']).


eccs_user_possible_ptemplate(T) :-
	eccs_sys_functor(T, F, I), I > 0,
	\+ eccs_memberchk(F, ['.', ':', '@', '#', '=', '::', '~', 'or', '&', '`']).







/* eccs_template_expansion(Node, Temp, NewTemp, Rest, RestOut, Cs, CsOut)

Node is constrained by templates Temp.  These evaluate to NewTemp.
Rest and RestOut are other constraints that hold at Node. Cs and CsOut
are all constraints that hold for the graph that contains Node.
*/

eccs_template_expansion(_Node, [], [], R, R, Cs, Cs) :- !.

% if unsatisfied wait statements exist, delay expansion.
% The logic here is that there is at least one wait statement for this template
% but that there is no such statement that holds.  Then we cut and delay.
% Otherwise we fail.  Note that the next clause but one holds only if
% there are no such statements. 

% Wed Dec 11 15:27:18 1991 JC
% The third clause, i.e. the one that runs if there is real work to do,
% substantially altered to allow for the tracing of template expansion. 
% This is only in a preliminary state, and should ultimately be made 
% much more flexible.  

% Thu Jan 30 21 13:50:17 1992 CB
% the hooks in sledebug.pl now spy and unspy templates with given names
% and the menu names have been changed accordingly

:- dynamic sle_spy/1. 

eccs_template_expansion(Node, [Temp|Ts], [Temp|Ts1], R, R1, Cs, Cs1) :-
	eccs_template_count(Temp, _Count, TName, _),
    	eccs_verify( eccs_wait_template(TName, Locus, Args)),
	(eccs_wait_template(TName, Locus, Args),
	eccs_constraints_structure(Node, R, Constraints),
	eccs_wake_up(Node, TName, [Constraints|Cs], Locus, Args) -> fail; !),
%	\+ eccs_wake_up(Node, TName, [Constraints|Cs], Locus, Args), !,
	eccs_template_expansion(Node, Ts, Ts1, R, R1, Cs, Cs1).
% if default not deterministic, and no explicit deterministic statement,
% delay expansion if uninstantiated locus.
eccs_template_expansion(Node, [Temp|Ts], [Temp|Ts1], R, R1, Cs, Cs1) :-
	eccs_sys_var(Node),
	eccs_template_count(Temp, _Count, TName, _),
	\+ eccs_wait_template(TName, _, _),
	eccs_global_variable(deterministic_templates, false),
	\+ eccs_deterministic_template(TName), !,
	eccs_template_expansion(Node, Ts, Ts1, R, R1, Cs, Cs1).

% expand all other cases, i.e.:
% wait statements satisfied, deterministic template, instantiated locus, or
% strategy is 'eager'.
eccs_template_expansion(Node, [Temp|Ts], Ts1, R, R1, Cs, Cs1) :-
	eccs_template_count(Temp, _Count, TName, N),
	eccs_maybe_trace(TName, N),
	eccs_sys_if_then_else(sle_spy(TName), sle_spy_template(TName, N, Node), true),
	eccs_template_definition(TName, Defn, Node),
	M is N+1,
	eccs_mark_templates(Defn, Defn2, M),
	eccs_graph_plus_constraints(GC, Node, []),
	eccs_user_unify(Defn2, GC, NewGC),
	eccs_graph_plus_constraints(NewGC, _, NewCs),
	eccs_template_expansion(Node, Ts, Ts1, R, R1, Cs, Cs2),
	eccs_opt_append(NewCs, Cs2, Cs1),
	eccs_maybe_trace_exit(TName, N).
	
/* 

Wed Dec 11 15:32:03 1991 JC

Additions for debugging.  

There should be be some way of ignoring certain templates, i.e.
set_variable(no_trace_templates, [lex/2, phrasal, ...]).

The way that spying is implemented is not sufficiently flexible. 
There should be a variable to keep track of skips, for instance. 

Fri Jan 31 1992 CHB

Added the code to deal with no_trace_templates. This is a list of
functor/arity specs. 
*/

sle_spy_template(TName, N, Node) :-
    eccs_sys_write('spying ....'),
    eccs_sys_functor(TName, F, _),
    eccs_print_result1(F, [f=TName|_]:[]),
    eccs_sys_write('with locus ...'),
    eccs_print_result1('', Node:[]), !,
    trace.

eccs_maybe_trace(_TName, _Count) :-
    (eccs_global_variable(trace_templates, true) -> fail; !, true).
eccs_maybe_trace(TName, _Count) :-     % CHB
	((eccs_global_variable(no_trace_templates, TNames),
	  eccs_sys_functor(TName,Functor,Arity),
	  eccs_member(Functor/Arity, TNames)) -> !,true ; fail).
eccs_maybe_trace(TName, Count) :-
    eccs_maybe_trace_in(TName, Count).
eccs_maybe_trace(TName, Count) :-
    eccs_maybe_trace_out(TName, Count).

eccs_maybe_trace_in(TName, Count) :- 
    eccs_sys_tab(Count), eccs_sys_write(expanding), eccs_sys_write(' '),
    eccs_sys_write(TName), nl, !.

eccs_maybe_trace_out(TName, Count) :-
    eccs_sys_tab(Count), eccs_sys_write('failing '), eccs_sys_write(TName), 
    nl, !, fail.

eccs_maybe_trace_exit(_TName, _Count) :-
    (eccs_global_variable(trace_templates, true) -> fail; !, true).
eccs_maybe_trace_exit(TName, _Count) :-     % CHB
	((eccs_global_variable(no_trace_templates, TNames),
	  eccs_sys_functor(TName,Functor,Arity),
	  eccs_member(Functor/Arity, TNames)) -> !,true ; fail).
eccs_maybe_trace_exit(TName, Count) :-
    eccs_maybe_trace_exit_exit(TName, Count).
eccs_maybe_trace_exit(TName, Count) :-
    eccs_maybe_trace_exit_redo(TName, Count).

eccs_maybe_trace_exit_exit(TName, Count) :-
    eccs_sys_functor(TName, F, _),
    eccs_sys_tab(Count), eccs_sys_write('exit '), eccs_sys_write(F), nl, !.

eccs_maybe_trace_exit_redo(TName, Count) :-
    eccs_sys_functor(TName, F, _),
    eccs_sys_tab(Count), eccs_sys_write('redo '), eccs_sys_write(F), nl, !, fail.


eccs_wait_template(Temp, Locus, Args) :-
    eccs_template_name(Temp, Name),
    eccs_get_from_database(control, wait_statement, wait(Name, Locus, Args)).


eccs_deterministic_template(Temp) :-
    eccs_template_name(Temp, Name),
    eccs_get_from_database(control, deterministic, deterministic(Name)).


/* eccs_wake_up(Node, Temp, Cs, Locus, Args)

A wait statement is a pair Locus and Args, Args being a list [N1, ...,
Nn] and is satisfied if the n parameters to the template Temp and Node
are subsumed by N1 ... Nn and Locus.  (That is, taking any
coinstantiation in the wait statement into account).
*/

eccs_wake_up(Node, Temp, Cs, Locus, Args) :-
    eccs_template_parameters(Temp, Params),
    eccs_graph_plus_constraints(GC, Node, Cs),
    eccs_list_subsumes([Locus|Args], [GC|Params]).


/* eccs_list_subsumes(Upper, Lower)
*/

eccs_list_subsumes(Upper, Lower) :-
    eccs_verify(
    	(eccs_list_of_graph_plus_constraints(Lower),
	 numbervars(Lower, 0, _N), 
	 eccs_list_subsumes1(Upper, Lower))).

eccs_list_subsumes1([], []).
eccs_list_subsumes1([Upper|Us], [Lower|Ls]) :-
    eccs_graph_plus_constraints(Upper, UG, UCs),
    eccs_graph_plus_constraints(Lower, LG, LCs),
    eccs_injection(UG, LG),
    eccs_list_subsumes1(Us, Ls),
    eccs_constraints_subsume(UCs, LCs).





/* 

eccs_template_definition(Template, Definition, Node)

Wed Dec 11 15:38:02 1991 JC
Changed from eccs_template_definition/2.  The last argument is the 
locus for the template.  This way, we can graph unify the locus 
with the locus spec in the template defn, and further instantiate 
earlier. 

*/

eccs_template_definition(Temp, Defn, Node) :-
    eccs_template_name(Temp, Name),
    eccs_sys_functor(Temp, F, N),
    eccs_sys_functor(PTemp, F, N),
    eccs_graph_plus_constraints(Locus, LGraph, _LCs),
    template(Name, _, _, template(PTemp, _, Locus)),
    eccs_graph_unify(LGraph, Node),
    eccs_unify_template_args(Temp, PTemp, N, Cs),
    eccs_graph_plus_constraints(Locus, G, C1s),
    eccs_opt_append(C1s, Cs, OutCs),
    eccs_graph_plus_constraints(Defn, G, OutCs).

eccs_unify_template_args(Temp, PTemp, N, OutCs) :-
    eccs_unify_template_args(Temp, PTemp, 1, N, [], OutCs).
eccs_unify_template_args(_Temp, _PTemp, M, N, Cs, Cs) :-
    eccs_succ(N, M), !.
eccs_unify_template_args(Temp, PTemp, I, N, InCs, OutCs) :-
    eccs_sys_arg(I, Temp, GC1),
    eccs_sys_arg(I, PTemp, GC2),
    eccs_user_unify(GC1, GC2, GC),
    eccs_graph_plus_constraints(GC, _, Cs),
    eccs_opt_append(Cs, InCs, NewCs),
    eccs_succ(I, J),
    eccs_unify_template_args(Temp, PTemp, J, N, NewCs, OutCs).



/* 

eccs_mark_templates

Put a wrapper around each representation of a template constraint so
that we know how many expansions have been performed prior to possible
expansion of this one.

*/

eccs_mark_templates(Defn, Def2, N) :-
    eccs_graph_plus_constraints(Defn, G, C),
    eccs_graph_plus_constraints(Def2, G, C2),
    eccs_mark_templates1(C, C2, N).

eccs_mark_templates1([], [], _N).
eccs_mark_templates1([ConstraintsIn|R], [ConstraintsOut|T], N) :-
    eccs_constraints_structure(Node, Cs, ConstraintsIn),
    eccs_get_constraint_type(temp, Cs, Temps, Remainder),
    eccs_mark_templates2(Temps, Remainder, C1s, N),
    eccs_constraints_structure(Node, C1s, ConstraintsOut),
    eccs_mark_templates1(R, T, N).

eccs_mark_templates2([], Remainder, Remainder, _).
eccs_mark_templates2([H|T], Remainder, [temp=L1|Remainder], N) :-
    eccs_mark_templates3([H|T], L1, N).

eccs_mark_templates3([], [], _).
eccs_mark_templates3([H|T], [COUNT|R], N) :-
    eccs_template_count(H, COUNT, _, N),
    eccs_mark_templates3(T, R, N).



/* eccs_template_count

An absolute limit on template expansion is given by the variable
template_expansion_limit.
*/

eccs_template_count('$$COUNT'(Temp, N), '$$COUNT'(Temp, Max), Temp, Upper) :- !,
    (eccs_sys_nonvar(Upper) -> eccs_sys_max(N, Upper, Max); Max = N, Max = Upper),
    eccs_global_variable(template_expansion_limit, M),
    eccs_sys_if_then_else(Max > M,
	(eccs_warning([template, expansion, limit, exceeded, Temp]), 
		eccs_template_expansion_overflow),
	true).

eccs_template_count(Temp, '$$COUNT'(Temp, N), Temp, N) :-
    eccs_sys_if_then_else(eccs_sys_var(N), N = 1, true).

eccs_template_expansion_overflow :-
    eccs_do_menu(overflow).

/* eccs_specialization_menu moved to slemenus.pl */

/*

Context variables

*/

eccs_spec_interp_cv(Literal, Interpreted) :-
    eccs_user_empty_structure(Empty),
    eccs_graph_plus_constraints(Empty, G, _C),
    eccs_template1_rhs(Literal, G, Empty, Interpreted, _ST).

    

/*                                                                           */
/* testing stuff                                                             */
/*                                                                           */

ttest([], _).
ttest([T|R], Out) :-
    template(T, _, _, template(_, _, X)),
    ttest(R, Uf),
    eccs_user_unify(Uf, X, Out).

t(1) :- eccs_template((test1=> []), _X).
t(2) :- eccs_template((test1=> [f:v]), _X).
t(3) :- eccs_template((test1=> [f:v, g:a]), _X).
t(4) :- eccs_template((test1=> [f:v, g:a, h:[g:a]]), _X).
t(5) :- eccs_template((test1=> [@t, f:v, g:a, h:[g:a]]), _X).
t(6) :- eccs_template((test1=> [t(#1), f:v, g: #1, h:[g:a]]), _X).
t(7) :- eccs_template((test1(#1) => [t(#1), f:v, g: #1, h:[g:a]]), _X).
t(8) :- eccs_template((test1(#1) => [f:(a v b)]), _X).

eccs_test_templates([], In, In).
eccs_test_templates([T|R], In, Out) :-
    template(T, _, _, template(_, _, TFS)),
    eccs_user_unify(TFS, In, In1),
    eccs_test_templates(R, In1, Out).

