/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:53:06 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Sort/RCS/bits.pl,v $',
	'$State: Exp $').

$Log: bits.pl,v $
% Revision 1.0  1993/05/04  09:53:06  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:48:20  pleuk
% revisions from SLE - April 1992
%
% Revision 0.7  1992/01/24  12:17:53  pleuk
% revisions from Jo - January 1992
%
% Revision 0.6  1991/09/02  13:34:03  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:45:50  pleuk
% *** empty log message ***
%

*/


/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('%M%', '%I%', %R%').

*/
% We are going to require that two model encodings have the same
% number of elements in the list.

eccs_s_bintoatom(Bin,Atom) :-
  eccs_s_bintoatom0(Bin,1,1,[],Atom,[]).

eccs_s_bintoatom0(Bin,_Mask,29,[],'2''0',_L) :- !.
eccs_s_bintoatom0(Bin,_Mask,29,K,Atom,_L) :- !,
  eccs_sys_name(Atom,[50,39|K]).
eccs_s_bintoatom0(Bin,Mask,N,K,Ln,L0) :-
  Bit is Mask /\ Bin,
  ( Bit = 0 ->
    L1 = 48, 		% 0
    K1 = K ;
    L1 = 49,		% 1
    K1 = [L1|L0] ),
  N1 is N + 1,
  Mask1 is Mask << 1,
  eccs_s_bintoatom0(Bin,Mask1,N1,K1,Ln,[L1|L0]).

eccs_l_bintoatom(Bin,Atom) :-
  eccs_l_bintoatom0(Bin,1,1,Atom,[]).

eccs_l_bintoatom0(_Bin,_Mask,29,Atom,L) :- !,
  eccs_sys_name(Atom,[50,39|L]).
eccs_l_bintoatom0(Bin,Mask,N,Ln,L0) :-
  Bit is Mask /\ Bin,
  ( Bit = 0 ->
    L1 = 48 ;		% 0
    L1 = 49 ),		% 1
  eccs_succ(N, N1),
  Mask1 is Mask << 1,
  eccs_l_bintoatom0(Bin,Mask1,N1,Ln,[L1|L0]).

eccs_s_bintoatom_list([],[]) :- !.
eccs_s_bintoatom_list([H|T],[H1|T1]) :-
  eccs_s_bintoatom(H,H1),
  eccs_s_bintoatom_list(T,T1).

eccs_l_bintoatom_list([],[]) :- !.
eccs_l_bintoatom_list([H|T],[H1|T1]) :-
  eccs_l_bintoatom(H,H1),
  eccs_l_bintoatom_list(T,T1).

eccs_bintoatom_list([],[]) :- !.
eccs_bintoatom_list([H|T],[H1|T1]) :-
  eccs_l_bintoatom(H,H1),
  eccs_l_bintoatom_list(T,T1).

eccs_bit_encode(List,BitEncodedList) :-
  eccs_bit_encode0(1,List,0,1,[],BitEncodedList).

eccs_bit_encode0(1,[],0,1,BList,BList) :-!.
eccs_bit_encode0(_,[],Word,_Mask,BList,[Word|BList]) :- !.
eccs_bit_encode0(29,List,Word,_Mask,BList0,BList1) :- !,
  eccs_bit_encode0(1,List,0,1,[Word|BList0],BList1).
eccs_bit_encode0(N,[+_|T],Word,Mask,BList0,BList1) :- !,
  Word1 is Word \/ Mask,
  eccs_succ(N, N1),
  Mask1 is Mask << 1,
  eccs_bit_encode0(N1,T,Word1,Mask1,BList0,BList1).
eccs_bit_encode0(N,[-_|T],Word,Mask,BList0,BList1) :- !,
  eccs_succ(N, N1),
  Mask1 is Mask << 1,
  eccs_bit_encode0(N1,T,Word,Mask1,BList0,BList1).

eccs_bit_unify([],[],[]) :- !, fail.
eccs_bit_unify([H1|T1],[H2|T2],[H3|T3]) :-
  H3 is H1 /\ H2,
  ( H3 = 0 ->
    eccs_bit_unify(T1,T2,T3) ;
    eccs_bit_unify1(T1,T2,T3) ).

eccs_bit_unify1([],[],[]) :- !.
eccs_bit_unify1([H1|T1],[H2|T2],[H3|T3]) :-
  H3 is H1 /\ H2,
  eccs_bit_unify1(T1,T2,T3).

eccs_bit_u(X,Y,Z) :-
  Z is X /\ Y,
  \+ Z = 0.

% eccs_bit_subsume(X,Y) is true if bit list X subsumes bit list Y.

eccs_bit_subsume([],[]) :- !.
eccs_bit_subsume([H1|T1],[H2|T2]) :-
  eccs_bit_s(H1,H2),
  eccs_bit_subsume(T1,T2).

eccs_bit_s(X,Y) :-
  Z is X /\ Y,
  Y = Z.

eccs_bit_identity(X,Y) :-
  X = Y.

eccs_bit_neg_list([],[]) :- !.
eccs_bit_neg_list([H|T],[H1|T1]) :- 
  H1 is \(H),
  eccs_bit_neg_list(T,T1).

eccs_bit_zero_list([]) :- !.
eccs_bit_zero_list([H|T]) :-
  H = 0,
  eccs_bit_zero_list(T).

%  Note:  fix eccs_l_bintoatom so that in the case where not all of a model
%  is used that you don't see the rest.

%  This will only eliminate all useless bit strings 
%  for the time being because we aren't currently worried about typing
%  of arbitrary terms.  Typing of arbitrary terms will still work but
%  just won't be too efficient.

filter_bits(_,[],[]) :- !.
filter_bits(Term,[bits(Var,Bits)|T],[bits(Var,Bits)|T0]) :-
  eccs_sys_var(Var),
  \+ occurs_check(Var,Term), !,
  filter_bits(Term,T,T0).
filter_bits(Term,[bits(Var,_Bits)|T],T0) :-
  eccs_sys_var(Var), !,
  filter_bits(Term,T,T0).
filter_bits(Term,[H|T],[H|T0]) :-
  filter_bits(Term,T,T0).
