/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:53:06 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Sort/RCS/sort.pl,v $',
	'$State: Exp $').

$Log: sort.pl,v $
% Revision 1.0  1993/05/04  09:53:06  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:48:20  pleuk
% revisions from SLE - April 1992
%
% Revision 0.7  1992/01/24  12:17:53  pleuk
% revisions from Jo - January 1992
%
% Revision 0.6  1991/09/02  13:34:49  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:45:50  pleuk
% *** empty log message ***
%

Wed Jan  8 11:10:57 1992 JC minor changes to printing routines 
to support SLE.  It was likely that these were bugs anyway.  Sort 
printing had not been properly tested with the Acord/Termunif 
formalism. 

*/
/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('%M%', '%I%', %R%').

*/
/* ******************************************************************************** */

% Compile all the models from the property declarations and the set of
% type axioms.

/* ******************************************************************************** */

eccs_compile_sorts :-
  eccs_message([compiling, sorts]),
  eccs_get_from_database(sort_definition, sort, sort(Sort,List)),
  eccs_compile_sort(Sort,List,Translation),
  eccs_svprops(Sort,Translation),
  eccs_message([sort, Sort, compiled]),
  fail.
eccs_compile_sorts :-
    eccs_message([sorts, compiled]).

eccs_compile_dm_test :-
  eccs_once((eccs_current_file(File, Specs), eccs_memberchk(type=sorts, Specs))),
  eccs_get_from_database(dm_test, dm_test, uncompiled_dm_test(X,Y,Z)),
  eccs_dm_test(X,Y,Z,TypeY,TypeZ),
  eccs_store_in_database(File, dm_test, X, _, dm_test(X,TypeY,TypeZ), []),
  fail.
eccs_compile_dm_test.



eccs_encode_sort_system :-
    eccs_message([starting, to, encode, sort, system]),
  eccs_sys_abolish('$bad_axiom$',0),
  eccs_erase_intermediate_results(model),
  eccs_erase_intermediate_results(modelnumber),
  eccs_store_intermediate_result(modelnumber, 0),
  eccs_message(['Beginning' , encoding]),
%  Begin is cputime,
  eccs_get_stats(_, Begin),
  !,
  eccs_build_encoding,
  !,
  eccs_intermediate_result(modelnumber, NumberOfModels, Ref), eccs_sys_erase(Ref),
  eccs_once((eccs_current_file(FileName, Specs),eccs_memberchk(type=sorts, Specs))),
  eccs_store_in_database(FileName, sort_definition, number_of_models, sort, NumberOfModels, []),
  eccs_store_intermediate_result(modelnumber, 0),
  !,
%  End is cputime,
  eccs_get_stats(_, End),
  Total is End - Begin,
  eccs_message(['Encoding complete.  Total time is ' , Total]).

eccs_build_encoding :-
  eccs_collect_properties(Properties),
  eccs_erase_intermediate_results(properties),
  eccs_sort(Properties,SortedProperties),		% sort the properties
  eccs_store_intermediate_result(properties, properties(SortedProperties)),
  eccs_collect_axioms(Axioms),
  eccs_erase_intermediate_results(axiom),
  eccs_store_intermediate_result(axiom, axioms(Axioms)),
  eccs_translate_axioms(NewAxioms), !,		% translate axioms into basic connectives
  eccs_translate(NewAxioms),			% simplify translated axioms
  eccs_encode_properties(PropertyList),	% gather properties together from models
  eccs_encode_PropertyList(PropertyList).	% encode property terms
eccs_build_encoding :-
	eccs_message(['Encoding',failed]).

eccs_collect_properties(PList) :-
  setof(P,eccs_get_from_database(properties, properties,P),PLists),
  eccs_append_all(PLists,PList).

eccs_collect_axioms(AList) :-
  setof(A, eccs_get_from_database(axiom, axiom, A),AList).

% translate_axioms takes user defined axioms and translates them into
% the set of basic connectives.  These include at-most-one-of (amo(A)),
% inclusive-or (or(A)), and (and(A)), exclusive-or (xor(A)), conjunction
% (&), disjunction (or), negation (-), iff (<->) and if (->).  In
% addition, positive literals may be specified with a +, e.g., +human.
% Any user defined connectives are also translated into the set of
% basic connectives here.  User defined connectives may be defined in
% terms of anything which can ultimately be translated into the basic
% connectives.  This includes other properly defined user connectives.
% Any unknown properties or connectives or flagged as errors and the
% relevant axiom is deleted from the list of axioms.  Processing still
% continues despite errors.  This may want to get changed if it
% has the effect of allowing large numbers of models to be computed in
% the face or errors.

eccs_translate_axioms(NewAxioms) :-
  eccs_intermediate_result(axiom, axioms(Axioms)),
  eccs_translate_axioms0(Axioms,NewAxioms).

eccs_translate_axioms0([],[]) :- !.
eccs_translate_axioms0([H|T],X) :-
  eccs_translate_axiom(H,H1),
  ( eccs_sys_retract('$bad_axiom$'),		% error, dont add to list
    X = T1 ;
    X = [H1|T1] ),			% no error
  eccs_translate_axioms0(T,T1).

eccs_translate_axiom('-|'(A,List),((A1&xor(List1)) or ((-A1)&(-or(List1))))) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_list(List,List1).
eccs_translate_axiom('-{'(A,ArgList),List) :- !,
  eccs_translate_axiom_list(A,ArgList,List).
eccs_translate_axiom('}-'(List,A),(A1 <-> and(List1))) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_list(List,List1).
eccs_translate_axiom(']-'(List,A),(A1 <-> or(List1))) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_list(List,List1).
eccs_translate_axiom(amo(A),amo(A1)) :- !,
  eccs_translate_list(A,A1).
eccs_translate_axiom(and(A),and(A1)) :- !,
  eccs_translate_list(A,A1).
eccs_translate_axiom(or(A),or(A1)) :- !,
  eccs_translate_list(A,A1).
eccs_translate_axiom(xor(A),xor(A1)) :- !,
  eccs_translate_list(A,A1).
eccs_translate_axiom((A<->B),(A1<->B1)) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_axiom(B,B1).
eccs_translate_axiom((A->B),(A1->B1)) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_axiom(B,B1).
eccs_translate_axiom((A&B),(A1&B1)) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_axiom(B,B1).
eccs_translate_axiom((A or B),(A1 or B1)) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_axiom(B,B1).
eccs_translate_axiom((-A),(-A1)) :- !,
  eccs_translate_axiom(A,A1).
eccs_translate_axiom((+A),(+A1)) :- !,
  eccs_translate_axiom(A,A1).
eccs_translate_axiom(A,A) :-
  eccs_sys_atom(A),
  eccs_get_from_database(properties, properties, Properties),
  eccs_member(A,Properties), !.
eccs_translate_axiom(A,A1) :-
  eccs_sys_atom(A),
  eccs_get_from_database(sort_definition, sort, sort(A,Def)), !,
  eccs_translate_axioms0(Def,Def0),
  eccs_conj_from_list(Def0,A1).
eccs_translate_axiom(A,A) :-
  eccs_sys_atom(A), !,
  ( '$bad_axiom$' ; eccs_sys_assert('$bad_axiom$') ),	% property not declared
  eccs_error(['Undeclared property:  ' , A]).
eccs_translate_axiom(Formula0,Formula2) :-
  pimple_obj(user_connective, user_connective, user_connective(Formula0,Formula1)), !,	% find & translate the connective
  eccs_translate_axiom(Formula1,Formula2).		% translate the translation
eccs_translate_axiom(Formula0,_) :-			% undeclared connective
  ( '$bad_axiom$' ; eccs_sys_assert('$bad_axiom$') ),
  eccs_error(['Unrecognised expression: ' , Formula0]).

eccs_translate_list([],[]).
eccs_translate_list([H|T],[H0|T0]) :-
  eccs_translate_axiom(H,H0),
  eccs_translate_list(T,T0).

eccs_translate_axiom_list(Property,[X],X1) :- !,
  eccs_translate_axiom_list0(Property,X,X1).
eccs_translate_axiom_list(Property,[H|T],(H1&T1)) :-
  eccs_translate_axiom_list0(Property,H,H1),
  eccs_translate_axiom_list(Property,T,T1).

% The following four clauses all have the same structure.  Basically,
% they check to see whether the term (B) position in the connective is
% instantiated.  If it is not, then the property from the original
% '-{' is plugged in instead.

eccs_translate_axiom_list0(A,'-|'(B,List),X) :- !,
  ( eccs_sys_var(B) ->
    X = X1,
    C = A ;
    eccs_translate_axiom(A,A1),
    eccs_translate_axiom(B,B1),
    X = ((A1 <-> B1) & X1),
    C = B ),
  eccs_translate_axiom('-|'(C,List),X1).
eccs_translate_axiom_list0(A,'-{'(B,List),X) :- !,
  ( eccs_sys_var(B) ->
    X = X1,
    C = A ;
    eccs_translate_axiom(A,A1),
    eccs_translate_axiom(B,B1),
    X = ((A1 <-> B1) & X1),
    C = B ),
  eccs_translate_axiom('-{'(C,List),X1).
eccs_translate_axiom_list0(A,'}-'(List,B),X) :- !,
  ( eccs_sys_var(B) ->
    X = X1,
    C = A ;
    eccs_translate_axiom(A,A1),
    eccs_translate_axiom(B,B1),
    X = ((A1 <-> B1) & X1),
    C = B ),
  eccs_translate_axiom('}-'(List,C),X1).
eccs_translate_axiom_list0(A,']-'(List,B),X) :- !,
  ( eccs_sys_var(B) ->
    X = X1,
    C = A ;
    eccs_translate_axiom(A,A1),
    eccs_translate_axiom(B,B1),
    X = ((A1 <-> B1) & X1),
    C = B ),
  eccs_translate_axiom(']-'(List,C),X1).
eccs_translate_axiom_list0(A,B,(A1 <-> B1)) :- !,
  eccs_translate_axiom(A,A1),
  eccs_translate_axiom(B,B1).

% Simplify the axioms written with basic connectives using elementary
% identities from propositional logic.

eccs_translate(A0) :- 
    eccs_conj_from_list(A0,A1),	% first, convert list to conjunction
    eccs_implications_out(A1,A2),	% rewrite implications as &,  or  and -
    eccs_negation_in(A2,A3), !,	% move negation inwards to literals
    eccs_cnf(A3,A4), !,		% rewrite for various optimisations
    eccs_expand_disjunction(A4).	% remove disjunction and save the models

eccs_conj_from_list([],[]) :- !.
eccs_conj_from_list([A],A) :- !.
eccs_conj_from_list([A|B],(A&B1)) :-
  eccs_conj_from_list(B,B1).

% The following three predicates are minor variations on code found in
% Clocksin and Mellish.

eccs_implications_out([],[]) :- !.
eccs_implications_out((P<->Q),((P1&Q1) or ((-P1)&(-Q1)))) :- !,
  eccs_implications_out(P,P1),
  eccs_implications_out(Q,Q1).
eccs_implications_out((P->Q),((-P1) or Q1)) :- !,
  eccs_implications_out(P,P1),
  eccs_implications_out(Q,Q1).
eccs_implications_out((P&Q),(P1&Q1)) :- !,
  eccs_implications_out(P,P1),
  eccs_implications_out(Q,Q1).
eccs_implications_out(amo(X),(xor(X1) or -or(X1))) :- !,
  eccs_implications_out_list(X,X1).
eccs_implications_out((P or Q),(P1 or Q1)) :- !,
  eccs_implications_out(P,P1),
  eccs_implications_out(Q,Q1).
eccs_implications_out(xor(A),xor(A1)) :- !,
  eccs_implications_out_list(A,A1).
eccs_implications_out(or(A),or(A1)) :- !,
  eccs_implications_out_list(A,A1).
eccs_implications_out(and(A),and(A1)) :- !,
  eccs_implications_out_list(A,A1).
eccs_implications_out((-P),(-P1)) :- !,
  eccs_implications_out(P,P1).
eccs_implications_out((+P),(+P1)) :- !,
  eccs_implications_out(P,P1).
eccs_implications_out(P,P).

eccs_implications_out_list([],[]) :- !.
eccs_implications_out_list([H|T],[H0|T0]) :-
  eccs_implications_out(H,H0),
  eccs_implications_out_list(T,T0).

eccs_negation_in([],[]) :- !.
eccs_negation_in((-P),P1) :- !,
  eccs_negation(P,P1).
eccs_negation_in((P&Q),(P1&Q1)) :- !,
  eccs_negation_in(P,P1),
  eccs_negation_in(Q,Q1).
eccs_negation_in((P or Q),(P1 or Q1)) :- !,
  eccs_negation_in(P,P1),
  eccs_negation_in(Q,Q1).
eccs_negation_in(xor(A),xor(A1)) :- !,
  eccs_negation_in_list(A,A1).
eccs_negation_in(or(A),or(A1)) :- !,
  eccs_negation_in_list(A,A1).
eccs_negation_in(and(A),and(A1)) :- !,
  eccs_negation_in_list(A,A1).
eccs_negation_in(+P,P1) :- !,
  eccs_negation_in(P,P1).
eccs_negation_in(P,P).

eccs_negation_in_list([],[]) :- !.
eccs_negation_in_list([H|T],[H0|T0]) :-
  eccs_negation_in(H,H0),
  eccs_negation_in_list(T,T0).

eccs_negation((-P),P1) :- !,
  eccs_negation_in(P,P1).
eccs_negation((+P),P1) :- !,
  eccs_negation(P,P1).
eccs_negation((P&Q),(P1 or Q1)) :- !,
  eccs_negation(P,P1),
  eccs_negation(Q,Q1).
eccs_negation((P or Q),(P1&Q1)) :- !,
  eccs_negation(P,P1),
  eccs_negation(Q,Q1).
eccs_negation(xor(A),(-xor(A1))) :- !,	% interpret instead of translate
  eccs_negation_in_list(A,A1).
eccs_negation(or(A),and(A1)) :- !,		% as in binary case
  eccs_negation_of_list(A,A1).
eccs_negation(and(A),or(A1)) :- !,		% as in binary case
  eccs_negation_of_list(A,A1).
eccs_negation(P,(-P)).

eccs_negation_of_list([],[]) :- !.
eccs_negation_of_list([A|B],[A1|B1]) :-
  eccs_negation(A,A1),
  eccs_negation_of_list(B,B1).

eccs_cnf(X,X).

% eccs_expand_disjunction calls eccs_expand_disjunction0 to generate a model by
% following for any disjunction one of the possibilities.  Then
% expand_model instantiates any properties not implicitly instantiated
% by the axioms.  The model is saved and then the clause failed to
% investigate other models implied by the disjunctions.  This is the
% only practical solution to eliminating the disjunction.  A
% straightforward term rewriting approach is exponential in time and
% space.  This scheme has the advantage that inconsistent models are
% eliminated as early as possible.

eccs_expand_disjunction(Axiom) :-
  eccs_once(eccs_get_from_database(properties,properties, Properties)),
  eccs_expand_disjunction0(Axiom,[],Model),
  eccs_expand_model(Model,Properties,NewModel),
  eccs_once((eccs_intermediate_result(model ,model(NewModel),_) ; 
	     eccs_store_intermediate_result(model,model(NewModel)))),
  fail.
eccs_expand_disjunction(_).

% The following predicates use a very procedural hack to cut
% redundant parts of the search space.  The technique is illustrated in
% the very next clause below.  For essentially disjunctive connectives,
% we can distinguish between formulas which are true and dont
% instantiate any further properties (i.e., which are true on the basis
% of the current property instantiations in the model) and those which
% don't.  Those that don't further instantiate a model will obviously
% return a partial model identical to the input model.  In these cases,
% we can cut the search space for any further disjunctive possibilities
% because the instantiations which make the disjunction true were not
% effected by the disjunction itself.  As long as the relevant
% instantiations are not inconsistent with any further formulae, the
% disjunction is guaranteed to hold and any way of satisfying the
% disjunction will include these instantiations.  Therefore, the
% property instantiations implied by the remainder of the disjunction
% need not be specified.  In the event that the relevant instantiations
% are inconsistent with further formula, then the disjunction as a whole
% will fail anyway precisely because it was not the disjunction which
% effected the instantiations in the first place.  That is, to undo the
% invalid instantiations will require backtracking past the disjunction.

% This can be eliminated if any higher level disjunctive
% connectives are translated into conjunctive normal form.  The
% tradeoffs are very subtle and involve interaction between level of
% compilation, the prolog backtracking strategy, avoidance of a generate
% and test scheme and the use of partial models.  There are three 
% connectives which do not get translated but are effectively
% interpreted.  They are "xor", "or" and "and".  In the case of "or"
% and "and" the negations are just translated into the equivalent
% negated form using the predicate eccs_negation_in and then executed.  It
% was decided that the translation approach for "xor" was too expensive
% and so its negation is interpreted.  This necessitates the
% interpretation of the other two as well in their positive form.

eccs_expand_disjunction0(true,L,L) :- !.		% true, succeed.
eccs_expand_disjunction0(false,_,_) :- !.		% false, die.
eccs_expand_disjunction0([],_,[]) :- !.		% no specifications
eccs_expand_disjunction0((A or B),L0,Ln) :- !,
  ( eccs_expand_disjunction0(A,L0,Ln),
    (L0 = Ln, ! ; true) ;			% if no further instantiations, cut
    eccs_expand_disjunction0(B,L0,Ln) ).		% next disjunct
eccs_expand_disjunction0((A&B),L0,Ln) :- !,
  eccs_expand_disjunction0(A,L0,L1),
  eccs_expand_disjunction0(B,L1,Ln).
eccs_expand_disjunction0(xor(A),L0,Ln) :- !,		% interpret directly
  eccs_exclusive_or(A,L0,Ln).
eccs_expand_disjunction0(or(A),L0,Ln) :- !,		% interpret directly
  inclusive_or(A,L0,Ln).
eccs_expand_disjunction0(and(A),L0,Ln) :- !,		% interpret directly
  eccs_and(A,L0,Ln).
eccs_expand_disjunction0((-xor(A)),L0,Ln) :-!,	% interpret directly
  eccs_neg_exclusive_or(A,L0,Ln).
eccs_expand_disjunction0(-or(A),L0,Ln) :- !,	% translate to and
  eccs_negation_in(-or(A),and(A1)),
  eccs_expand_disjunction0(and(A1),L0,Ln).
eccs_expand_disjunction0(-and(A),L0,Ln) :- !,	% translate to or
  eccs_negation_in(-and(A),or(A1)),
  eccs_expand_disjunction0(or(A1),L0,Ln).
eccs_expand_disjunction0(-A,L0,L1) :- !,	% only atoms can be negative
  eccs_sys_atom(A),
  eccs_negative(A,L0,L1).
eccs_expand_disjunction0(+A,L0,L1) :- !,	% only atoms can be positive
  eccs_sys_atom(A),
  eccs_positive(A,L0,L1).
eccs_expand_disjunction0(A,L0,L1) :- !,	% catchall, can only be an atom
  eccs_sys_atom(A),
  eccs_positive(A,L0,L1).

eccs_exclusive_or([],_,_) :- !, fail.	% none were true, die
eccs_exclusive_or([A|B],L0,Ln) :-
  eccs_expand_disjunction0(A,L0,L1),
  (L0 = L1, ! ; true) ,			% if no further instantiations, cut
  eccs_exclusive_or0(B,L1,Ln).
eccs_exclusive_or([A|B],L0,Ln) :-		% previous disjunct was negative, need 
  eccs_expand_disjunction0(-A,L0,L1),	% its negation to get negative instantiations
  eccs_exclusive_or(B,L1,Ln).		% on the relevant properties

eccs_exclusive_or0([],L,L) :- !.		% no more succeeded, ok.
eccs_exclusive_or0([A|B],L0,Ln) :-		% the rest of the disjuncts must fail
  eccs_expand_disjunction0(-A,L0,L1),
  eccs_exclusive_or0(B,L1,Ln).

eccs_neg_exclusive_or([],L,L) :- !.		% all failed, ok.
eccs_neg_exclusive_or([A|B],L0,Ln) :-	% found one, must find another.
  eccs_expand_disjunction0(A,L0,L1),
  (L0 = L1, ! ; true ),			% if no further instantiations, cut
  eccs_neg_exclusive_or0(B,L1,Ln).
eccs_neg_exclusive_or([A|B],L0,Ln) :-	% previous disjunct was negative, need
  eccs_expand_disjunction0(-A,L0,L1),	% its negation to get negative instantiations
  eccs_neg_exclusive_or(B,L1,Ln).		% on the relevant properties

eccs_neg_exclusive_or0([],_,_) :- !, fail.	% didn't find another, die.
eccs_neg_exclusive_or0([A|_B],L0,Ln) :-	% if we find one, ok.
  eccs_expand_disjunction0(A,L0,Ln),
  (L0 = Ln, ! ; true) .			% if no further instantiations, cut
eccs_neg_exclusive_or0([A|B],L0,Ln) :-	% previous disjunct was negative, need
  eccs_expand_disjunction0(-A,L0,L1),	% its negation to get negative instantiations
  eccs_neg_exclusive_or0(B,L1,Ln).		% on the relevant properties


eccs_and([],L,L) :- !.			% all succeeded, ok.
eccs_and([A|B],L0,Ln) :-			% all must succeed.
  eccs_expand_disjunction0(A,L0,L1),
  eccs_and(B,L1,Ln).

eccs_inclusive_or([],_,_) :- !, fail.	% none succeeded, die.
eccs_inclusive_or([A|B],L0,Ln) :-
  ( eccs_expand_disjunction0(A,L0,Ln),
    (L0 = Ln, ! ; true) ;		% if no further instantiations, cut
    eccs_inclusive_or(B,L0,Ln) ).

% negative verifies that the property A is negative in the current
% model, instantiating it if necessary.

eccs_negative(A,[],[-A]) :- !.		% not instantiated, add to model.
eccs_negative(A,[+A|_],_) :- !,fail.		% positive in model, die.
eccs_negative(A,[-A|L],[-A|L]) :- !.		% eccs_negative in model, ok.
eccs_negative(A,[H|L0],[H|L1]) :-		% check next property.
  eccs_negative(A,L0,L1).

eccs_positive(A,[],[+A]) :- !.		% not instantiated, add to model.
eccs_positive(A,[-A|_],_) :- !,fail.		% negative in model, die.
eccs_positive(A,[+A|L],[+A|L]) :- !.		% positive in model, ok.
eccs_positive(A,[H|L0],[H|L1]) :-		% check next property.
  eccs_positive(A,L0,L1).

eccs_expand_model(Model,Properties,List) :-
  eccs_pre_sort(Model,Positive,Negative),	% split into positive & negative literal lists
  eccs_sort(Positive,Positive0),		% sort positive literals
  eccs_sort(Negative,Negative0),		% sort negative literals
  eccs_expand_model0(Positive0,Negative0,Properties,List).

eccs_expand_model0(_,_,[],[]) :- !.				% no more properties
eccs_expand_model0([S0|Pn],N,[S0|Sn],[+S0|T]) :- !,		% + case
  eccs_expand_model0(Pn,N,Sn,T).
eccs_expand_model0(P,[S0|Nn],[S0|Sn],[-S0|T]) :- !,		% - case
  eccs_expand_model0(P,Nn,Sn,T).
eccs_expand_model0(P,N,[S0|Sn],[-S0|T]) :-			% neither + or- ;
  eccs_expand_model0(P,N,Sn,T).				% add as - this time
eccs_expand_model0(P,N,[S0|Sn],[+S0|T]) :-			% neither + or - ;
  eccs_expand_model0(P,N,Sn,T).				% add as + this time

eccs_pre_sort([],[],[]).					% no more left
eccs_pre_sort([+A|T],[A|P],N) :- !,				% + case
  eccs_pre_sort(T,P,N).
eccs_pre_sort([-A|T],P,[A|N]) :- !,				% - case
  eccs_pre_sort(T,P,N).
eccs_pre_sort([A|T],[A|P],N) :- !,				% positive with no sign
  eccs_pre_sort(T,P,N).

eccs_encode_properties(PropertyList) :-
    eccs_get_from_database(properties,properties, (Properties)),	% get the property list
  eccs_length(Properties,NumOfProperties),		% get the number of properties
  eccs_list(NumOfProperties,List), !,		% make a list for the property lists
  eccs_sys_assert('$PropertyList$'(List,List)),		% save the property list of lists
  eccs_encode_properties0,				% get the properties from the models
  eccs_once(eccs_sys_retract('$PropertyList$'(PropertyList,TailList))),
  eccs_instantiate_tails(TailList).			% fix the end of lists in the lists

% Add the properties from each model to the appropriate property list
% in the list of property lists '$PropertyList$'.

eccs_encode_properties0 :-
  eccs_once((eccs_current_file(File, Specs),eccs_memberchk(type=sorts, Specs))),
  eccs_once(eccs_get_from_database(properties,properties, _Properties)),
  eccs_intermediate_result(model, model(Model),Ref),
  eccs_sys_erase(Ref),
  eccs_once((
    eccs_model_number(ModelNumber),
    eccs_store_in_database(File, sort_definition, ModelNumber, model, model(ModelNumber,Model), []),
    eccs_sys_retract('$PropertyList$'(PropertyList,TailList)),
    eccs_add_list_to_TailList(Model,TailList,NewTailList),
    eccs_sys_assertz('$PropertyList$'(PropertyList,NewTailList)) )),
  fail.
eccs_encode_properties0.

eccs_model_number(ModelNumber) :-
  eccs_intermediate_result(modelnumber, PreviousModelNumber, Ref),
  eccs_sys_erase(Ref),
  eccs_succ(PreviousModelNumber, ModelNumber),
  eccs_store_intermediate_result(modelnumber, ModelNumber).

eccs_add_list_to_TailList([],[],[]) :- !.
eccs_add_list_to_TailList([L0|Ln],[[L0|T0]|LTn],[T0|Tn]) :-
  eccs_add_list_to_TailList(Ln,LTn,Tn).

eccs_instantiate_tails([]) :- !.
eccs_instantiate_tails([[]|T]) :-
  eccs_instantiate_tails(T).

% Encode the properties from the property list into property terms as
% described by Mellish.  Add the corresponding property to each term
% for readability.

eccs_encode_PropertyList(PropertyList) :-
    eccs_get_from_database(properties, properties, Properties),
    eccs_encode_PropertyList0(Properties,PropertyList).

eccs_encode_PropertyList0([],[]) :- !.
eccs_encode_PropertyList0([PropertiesH|PropertiesT],[H|T]) :-
  eccs_encode_property_term(PropertiesH,H),
  eccs_encode_PropertyList0(PropertiesT,T).

% The first clause here actually maps the property list onto a
% property term.  If it fails, then the property was negative in all of
% the models so the second clause prints an error message.

eccs_encode_property_term(Property,PropertyList) :-
    eccs_bit_encode(PropertyList,BitList),
    eccs_bit_neg_list(BitList,NegBitList),
    eccs_once((eccs_current_file(FileName, Specs), eccs_memberchk(type=sorts, Specs))),
    eccs_store_in_database(FileName, sort_definition, +Property, property_term, property_term(+Property,BitList), []),
    eccs_store_in_database(FileName, sort_definition, -Property, property_term, property_term(-Property,NegBitList), []),
  ( eccs_bit_zero_list(BitList) -> eccs_property_error(+Property) ; true ) ,
  ( eccs_bit_zero_list(BitList) -> eccs_property_error(-Property) ; true ) .

eccs_property_error(Property) :-
  eccs_warning(['Property ' , Property, ' isn''t' , valid, in, any, model]).

/* ******************************************************************************** */

%  Compile a sort definition.

/* ******************************************************************************** */

eccs_compile_sort(Sort,Axioms,NewAxioms) :-
  eccs_translate_axioms0(Axioms,NewAxioms), !,	% translate axioms into basic connectives
  eccs_bit_encode_axioms(NewAxioms,Bits),		% simplify translated axioms
  eccs_save_sort_bits(Sort,Bits).

eccs_bit_encode_axioms(A0,Bits) :- 
  eccs_conj_from_list(A0,A1),		% first, convert list to conjunction
  eccs_implications_out(A1,A2),		% rewrite implications as &,  or  and -
  eccs_negation_in(A2,A3), !,		% move negation inwards to literals
  eccs_cnf(A3,A4), !,
  eccs_expand_axiom_disjunction(A4,Bits).	% remove disjunction and save the models

eccs_expand_axiom_disjunction(Axiom,_Bits) :-
    eccs_once(eccs_sys_asserta(model_set_list([]))),
    eccs_expand_disjunction0(Axiom,[],Model),
    eccs_get_from_database(properties,properties, Properties),
    eccs_expand_partial_model(Model,Properties,NewModel),
    setof(Num,NewModel^eccs_get_from_database(sort_definition, Num, model(Num,NewModel)), ModelSet),
    eccs_once(eccs_sys_retract(model_set_list(ModelSetList))),
    eccs_append(ModelSetList,ModelSet,NewModelSetList),
    eccs_sys_asserta(model_set_list(NewModelSetList)),
    fail.
eccs_expand_axiom_disjunction(_Axiom,Bits) :-
  eccs_get_from_database(sort_definition, number_of_models, NumberOfModels),
  eccs_sys_retract(model_set_list(ModelSetList)),
  eccs_sort(ModelSetList,ModelSet),
  eccs_map_model_set(ModelSet,Bits,NumberOfModels).

eccs_save_sort_bits(Sort,Bits) :-
  eccs_bit_neg_list(Bits,NegBits),
  eccs_once((eccs_current_file(FileName, Specs), eccs_memberchk(type=sorts, Specs))),
  eccs_store_in_database(FileName, sort_definition, +Sort, property_term, property_term(+Sort,Bits), []),
  eccs_store_in_database(FileName, sort_definition, -Sort, property_term, property_term(-Sort,NegBits), []).

eccs_expand_partial_model(Model,Properties,NewModel) :-
  eccs_pre_sort(Model,Positive,Negative),
  eccs_sort(Positive,Positive0),
  eccs_sort(Negative,Negative0),
  eccs_expand_partial_model0(Positive0,Negative0,Properties,NewModel).

eccs_expand_partial_model0(_,_,[],[]) :- !.			% no more properties
eccs_expand_partial_model0([S0|Pn],N,[S0|Sn],[+S0|T]) :- !,	% + case
  eccs_expand_partial_model0(Pn,N,Sn,T).
eccs_expand_partial_model0(P,[S0|Nn],[S0|Sn],[-S0|T]) :- !,	% - case
  eccs_expand_partial_model0(P,Nn,Sn,T).
eccs_expand_partial_model0(P,N,[_S0|Sn],[_|T]) :-		% add anon. variable
  eccs_expand_partial_model0(P,N,Sn,T).

eccs_map_model_set(ModelSet,BitList,N) :-
  eccs_sort(ModelSet,ModelSet0),
  eccs_succ(N, Nplus1),
  eccs_map_model_set0(1,ModelSet0,0,1,[],BitList,1,Nplus1).

eccs_map_model_set0(1,[],0,1,BList,BList,N,N) :- !.
eccs_map_model_set0(_,[],Word,_Mask,BList,[Word|BList],N,N) :- !.
eccs_map_model_set0(29,List,Word,_Mask,BList0,BList1,C,N) :- !,
  eccs_map_model_set0(1,List,0,1,[Word|BList0],BList1,C,N).
eccs_map_model_set0(B,[],Word,Mask,BList0,BList1,C,N) :- !,
  eccs_succ(C, C1),
  eccs_succ(B, B1),
  Mask1 is Mask << 1,
  eccs_map_model_set0(B1,[],Word,Mask1,BList0,BList1,C1,N).
eccs_map_model_set0(B,[C|T],Word,Mask,BList0,BList1,C,N) :- !,
  eccs_succ(C, C1),
  eccs_succ(B, B1),
  Word1 is Word \/ Mask,
  Mask1 is Mask << 1,
  eccs_map_model_set0(B1,T,Word1,Mask1,BList0,BList1,C1,N).
eccs_map_model_set0(B,T,Word,Mask,BList0,BList1,C,N) :-
  eccs_succ(C, C1),
  eccs_succ(B, B1),
  Mask1 is Mask << 1,
  eccs_map_model_set0(B1,T,Word,Mask1,BList0,BList1,C1,N).

/* ******************************************************************************** */

% Sort definition property section

% Save any property or sort names which don't occur in a disjunction
% in the sort definition.  This is so that the routine sort_types can
% omit mention of properties or sorts which are coextensive with some
% other sort and explicitly required in their definition.

% We are only looking for syntactic requirement here.  The case where a disjunctive
% definition always implies a property or sort is not checked because it
% is too expensive.  

% Called by sort_definition in pcompile.pl.  The list of sort and
% property names is returned to be put in the database by a call to p_note_def.

/* ******************************************************************************** */

eccs_svprops(Sort,List) :-
  eccs_svprops0(Sort,List,PropertyList),
  eccs_store_intermediate_result(sortdefprops, sortdefprops(Sort,PropertyList)).

eccs_svprops0(_Sort,[],[]) :- !.
eccs_svprops0(Sort,[H|T],L0) :-
  eccs_svprops1(H,L0,Ln),
  eccs_svprops0(Sort,T,Ln).

eccs_svprops1((A&B),L0,Ln) :- !,
  eccs_svprops1(A,L0,L1),
  eccs_svprops1(B,L1,Ln).
eccs_svprops1(and(X),L0,Ln) :- !,
  eccs_svprops_list(X,L0,Ln).
eccs_svprops1(-A,[-A|Ln],Ln) :-	% Assume undeclared atoms already checked.
  eccs_sys_atom(A), !.
eccs_svprops1(+A,[+A|Ln],Ln) :-
  eccs_sys_atom(A), !.
eccs_svprops1(A,[+A|Ln],Ln) :-
  eccs_sys_atom(A), !.
eccs_svprops1(_,L,L).		% Everything else should be disjunctive.

eccs_svprops_list([],L,L) :- !.
eccs_svprops_list([H|T],L0,Ln) :-
  eccs_svprops1(H,L0,L1),
  eccs_svprops_list(T,L1,Ln).

/* ******************************************************************************** */

%  Determine the sort of a bit term.  Used in upp.pl.

/* ******************************************************************************** */

eccs_sort_type(Term,LUBSortSet) :-
  setof([Sort|SortTerm],eccs_sort_type0([Sort|SortTerm],Term),Set),
  eccs_lowest_upper_bound_set(Set,LUBSortSet0),
  eccs_sort_type1(LUBSortSet0,LUBSortSet).

/*

In trying to find a print representation for a sort, 
we look only for positive occurrences of those things which are defined
as sorts rather than as properties.   This should really be parameterized, 
so taht you can get a wider range of behaviours. 

*/

eccs_sort_type0([A|C],B) :-
    eccs_get_from_database(sort_definition, sort, sort(A, _)),
    eccs_get_from_database(sort_definition, _, property_term(+A,C)),
    eccs_bit_subsume(C,B).

eccs_sort_type1([],[]) :- !.
eccs_sort_type1([[A|_]|B],[A|B1]) :-
  eccs_sort_type1(B,B1).

eccs_lowest_upper_bound_set(Set,LUBSet) :-
  eccs_lowest_upper_bound_set(Set,Set,LUBSet).

eccs_lowest_upper_bound_set(_Set,[],[]) :- !.
eccs_lowest_upper_bound_set(Set,[A|B],[A|B0]) :-
  eccs_subsumes_no_member_of_set(A,Set), !,
  eccs_lowest_upper_bound_set(Set,B,B0).
eccs_lowest_upper_bound_set(Set,[_A|B],B0) :-
  eccs_lowest_upper_bound_set(Set,B,B0).

eccs_subsumes_no_member_of_set(_X,[]) :- !.
eccs_subsumes_no_member_of_set(X,[X|T]) :- !,
  eccs_subsumes_no_member_of_set(X,T).
eccs_subsumes_no_member_of_set([X|T],[[+Y|T]|B]) :-
  eccs_sys_if_then_else( (eccs_get_from_database(sortdefprops,sortdefprops,sortdefprops(Y,L)), eccs_member(X,L)),
    fail,
    eccs_subsumes_no_member_of_set([X|T],B)).
eccs_subsumes_no_member_of_set([X|T],[[_|A]|B]) :-
  \+ eccs_bit_subsume(T,A),
  eccs_subsumes_no_member_of_set([X|T],B).

/* ******************************************************************************** */


