/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:59:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Term/RCS/generic.pl,v $',
	'$State: Exp $').

$Log: generic.pl,v $
% Revision 1.0  1993/05/04  09:59:44  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:55:12  pleuk
% revisions from SLE - April 1992
%
% Revision 0.6  1991/09/02  13:29:13  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

*/

/*

Generic routines for the term-based system

*/

eccs_path_translate(X:Y, P) :-
    !,
    eccs_path_translate(X, P1),
    eccs_path_translate(Y, Q),
    eccs_path_append(P1, Q, P).
eccs_path_translate(A, P) :-
    eccs_sys_atomic(A),
    eccs_path_translate1(A, P).

eccs_path_translate1(A, P) :-
    (eccs_get_from_database(path_abbreviation, A, P); A = P), !.

eccs_path_append(A:X, B, A:C) :- !,
    eccs_path_append(X, B, C).

eccs_path_append(A, B, A:B).

eccs_user_empty_structure(_:[]:[]).

eccs_user_term(Term:_:_, Term).
eccs_user_bits(_:_:Bits, Bits).
eccs_user_constraints(_:Constraints:_, Constraints).

eccs_user_new_term_old_constraints(OldFs, NewFs, OldTerm, NewTerm) :-
    eccs_user_mask_term(OldFs, NewFs),
    eccs_user_term(OldFs, OldTerm),
    eccs_user_term(NewFs, NewTerm).

/*

Handle some special cases first

*/

eccs_user_unify(X:[]:[], X:[]:[], X:[]:[]) :- !.
eccs_user_unify(X:B:C, X:[]:[], X:B:C) :- !.
eccs_user_unify(X:[]:[], X:B:C, X:B:C) :- !.
eccs_user_unify(X, Y, Meet) :-
    eccs_user_term(X, Term),
    eccs_user_term(Y, Term),
    eccs_once( ( eccs_user_bits(X, XBits),
    	  eccs_user_bits(Y, YBits),
	  eccs_append(XBits, YBits, NewBits),
	  eccs_ck_typ(NewBits, MeetBits),
	  eccs_user_constraints(X, XCons),
	  eccs_user_constraints(Y, YCons),
	  eccs_append(XCons, YCons, MeetCons1),
	  eccs_sort(MeetCons1, MCSorted),
	  eccs_check_constraints(MCSorted, MeetCons))),
    eccs_user_term(Meet, Term),
    eccs_user_bits(Meet, MeetBits),
    eccs_user_constraints(Meet, MeetCons).

eccs_user_mask_term(_:Bits:Cons, _:Bits:Cons).
eccs_user_mask_bits(Term:_:Cons, Term:_:Cons).
eccs_user_mask_constraints(Term:Bits:_, Term:Bits:_).


/*---------------------------------------------------------------------------+
|        								     |
|        eccs_check_constraints(In, Out).					     |
|        								     |
|        check out the constraints in In, removing those which are 	     |
|        discharged.  If a constraint is broken, then fail.		     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_check_constraints([], []) :- !.
eccs_check_constraints([[]|T], R) :- !, 
	eccs_check_constraints(T, R).
eccs_check_constraints([H1], R) :- !,
	eccs_check_constraints(H1, R).
eccs_check_constraints([H1|T1], R) :- !,
	eccs_check_constraints(H1, HR),
	eccs_check_constraints(T1, TR),
	(HR = [] -> R = TR; R = [HR|TR]), !.
eccs_check_constraints(prolog(Goal), []) :- !, p_call(Goal).
eccs_check_constraints('C'(Node, Constraint), ['C'(Node, Constraint)]) :-
	eccs_sys_var(Node), !.
eccs_check_constraints('C'(Node, 'OR'(Real, L)), []) :- !,
	Node = Real, 
	eccs_memberchk(Real, L).
eccs_check_constraints('C'(Node, 'NOT'(Real, L)), []) :- !,
	Node = Real, 
	eccs_not_eq(Real, L).


eccs_variable(#N, Val, ST) :-
    eccs_memberchk(N = Val, ST).

% ?? Check the 4th clause!

eccs_eq_type(Var, Var) :- eccs_sys_var(Var), !.
eccs_eq_type(~Value, 'NOT'(Real, V)) :- eccs_eq_type(Value, V).
eccs_eq_type(X or Y, 'OR'(Real, [H|T])) :- eccs_eq_type(X, H),
                                          eccs_eq_type_or(Y, T).
eccs_eq_type(@Tem, D) :- pimple_obj('&template', template(Tem, _, D:C)),
                       insert_constraints(C).
eccs_eq_type(X, X) :- eccs_sys_atomic(X).

eccs_eq_type_or(X or Y, [H|T]) :- !, eccs_eq_type(X, H), eccs_eq_type_or(Y, T).
eccs_eq_type_or(X, [H]) :-  eccs_eq_type(X, H).

