;;; fake soh code

(in-package "PT")
(eval-when (compile load)
  (unintern 'dbobject))

(in-package "CLOS")

(eval-when (compile load)
  (export '(initdb
	    closedb
	    dbclass
	    dbobject
	    defdbclass
	    get-dbobject
	    store-dbobject
	    fetch-dbobject
	    delete-dbobject
	    deferred-update
	    mfetch-dbobject
	    mfetch-dbobject-where
	    save-object-cache)
	  'clos))

(defclass object () ())
(defclass dbclass (object) ())
(defclass dbobject (dbclass) ())

(defmacro defdbclass (name includes slots &rest options)
  `(defclass ,name ,includes ,slots ,@(clean-options options)))

(defun clean-options (options)
  (cond
   ((null options) options)
   ((eq (first options) ':local-slots) (clean-options (rest (rest options))))
    (t (clean-options (rest options)))))

(defgeneric delete-dbobject (self &optional no-error-p))

(defgeneric fetch-dbobject (self dbmode &optional no-error-p))

(defgeneric get-dbobject (self))

(defgeneric initialize (self plist))

(defgeneric *initialize-instance (self &rest initargs))

(defgeneric mfetch-dbobject (self slot-name slot-value 
                                  dbmode &optional no-error-p))

(defgeneric mfetch-dbobject-where (self where dbmode &optional no-error-p))

(defgeneric store-dbobject (self &optional store-components-p))

(in-package "PT")

;;  Graph Layout Code

(defvar *search-queue* nil
  "This holds the queue of nodes yet to be processed.
   The format of each node stored on the list depends on functions
   which traverse and process the graph.")

(defvar *hyperdoc-graph* nil
  "Holds shape-in-progress as nodes and connections are built up")

(defvar *intentions* nil)

;; This wrapper is put around each item added to the list, and is
;; stripped off as soon as one is taken off the
;; list.. Currently, the only purpose is to maintain information about
;; the depth of each node so that the  :depth-limit keyword will work properly
(defstruct search-queue-wrapper
  item
  level)

(defstruct (graph-node (:print-function graph-node-printer))
  "Contains the information required to do the processing of the nodes
   so that they are nicely arranged on the page.  Note that I used
   the $unknown$ value as a default since I add values slowly and don't
   want to have to check for BOUNDP all over."

  (backend-object '$unknown$); Keep the backend object
                             ; represented by this graph-node
  (dummy-p nil)            ; T if this is a dummy node for long edges, else nil.
  (x-size '$unknown$)   ; Width of this node in (some as yet undetermined) units
  (y-size '$unknown$)        ; Height of the node
  (left-x '$unknown$)        ; Left of the node for drawing purposes
  (top-y '$unknown$)         ; Top of the node for drawing purposes
  (level '$unknown$)         ; Level in the graph, where root(s) = 0
  (bary-center '$unknown$)   ; The position within the level of this node,
                             ; where the first is at position 0
  (parents nil)           ; List of graph-node structures this one descends from
  (children nil)             ; List of graph-node structures below this one
  (parent-edge-weights nil)  ; List of integer weights for edges between
                             ; this node and its ordered parent list
  (text-list '$unknown$)     ; List of arbitrary text string
                             ; (no linefeeds) to be printed at the node
  )


(defvar *best-first-eval-fn* nil
    "A function which takes a node and returns its priority value")

;;;  IMPORTANT:  the "passes" argument to this function controls how
;;;  many passes the algorithm makes over each level in the graph to
;;;  minimize crossings. WIth higher values, it will produce a better
;;;  graph, but for some reason it tends to break (inexplicably) for
;;;  any value other than 1.  Time permitting, I'll work on it, but
;;;  otherwise contact Ralph Marshall (marsh@linus.mitre.org) - he
;;;  wrote it all.
(defparameter $hip-passes 1)

(defvar *graph-list* nil "Stores the graph-list so that
                          the caller can get at it if needed,")

(defvar *heads-of-replacement-edges* nil "List of all dummy nodes
                                          directly below real nodes.")

(defvar *graph-x-size* nil "The x dimension of the graph in points.")
(defvar *graph-y-size* nil "The y dimention of the graph in points.")

(defvar *backend-text-function* nil
  "A function which takes a backend object and returns  strings describing
it.")

(defvar *backend-graph-node-map* (make-hash-table)
  "Map between backend objects and their graph nodes.")

(defvar *backend-children-function* nil
  "A function which takes a backend object and returns its children.")

(defvar *backend-edge-weight-function* nil
  "A function which takes two connected backend objects
   and determines their edge type.")

(defvar *split-near-children-p* nil
  "If T try to group children and split lines to them near group,
   in FIND-GROUPS-OF-CHILDREN.")

(defvar *graph-loudly* nil
  "Print lots of messages if T. KONG already has a *verbose*")

(defvar *verbose-node-text* nil
  "Print long description at each node if T, else just a minimal label.")

(defvar *generate-all-children-p* nil
  "A flag to be used by the :backend-children-function as it sees fit.")

(defclass node-box (box) ())

(defstruct (hyper-node (:print-function hyper-node-printer))
  name children)

(defstruct (temp (:print-function print-temp))
  name children)

(defgeneric box-color (node))

(defgeneric box-line (node))

(defgeneric db-fetch-object (self))

(defgeneric db-store-object (self))

(defgeneric db-unstore-object (self))

(defgeneric graph-box (node &optional shape))

(defgeneric my-obj (self))
(defgeneric (setf my-obj) (value self))

(defgeneric update-style (self))


;;;  Hypermedia Widgets
;;;

(defclass hypermedia-mixin (pmc) ())
(defclass hyper-collection-widget (hypermedia-mixin collection-widget) ())
(defclass hyper-graphic-widget (hypermedia-mixin graphic-browser) ())
(defclass hyper-image-widget (hypermedia-mixin image-widget) ())
(defclass hyper-table-widget (hypermedia-mixin table-field) ())
(defclass hyper-text-widget (hypermedia-mixin scrolling-text-widget) ())
(defclass hyper-video-widget (hypermedia-mixin collection-widget) ())


(defgeneric control-button (self))
(defgeneric (setf control-button) (value self))

(defgeneric create-bookmark (self))

(defgeneric current-entry (self))
(defgeneric (setf current-entry) (value self))

(defgeneric current-region (self))
(defgeneric (setf current-region) (value self))

(defgeneric display-area (self))
(defgeneric (setf display-area) (value self))

(defgeneric draw-markers (self))

(defgeneric exposed-markers (self))

(defgeneric field-types (self))
(defgeneric (setf field-types) (value self))

(defgeneric frame (self))
(defgeneric (setf frame) (value self))

(defgeneric get-candidate-markers (self))

(defgeneric get-current-bookmark (self))

(defgeneric get-current-link-marker (self))

(defgeneric get-current-marker (self))

(defgeneric get-current-position (self))

(defgeneric get-mark-region (self))

(defgeneric hide-markers (self))

(defgeneric index-panel-button (self))
(defgeneric (setf index-panel-button) (value self))

(defgeneric marker-outline-points (marker self))

(defgeneric marker-scroll-controls (self))
(defgeneric (setf marker-scroll-controls) (value self))

(defgeneric markers (self))

(defgeneric markers-shown? (self))
(defgeneric (setf markers-shown?) (value self))

(defgeneric max-col (self))

(defgeneric my-panel (self))

(defgeneric node (self))
(defgeneric (setf node) (value self))

(defgeneric orig-values (self))
(defgeneric (setf orig-values) (value self))

(defgeneric return-from-node (self))

(defgeneric selected-marker (self))
(defgeneric (setf selected-marker) (value self))

(defgeneric setup-node (self record))

(defgeneric save (object &optional more-detail))

(defgeneric scroll-to (self offset))

(defgeneric select-link-marker (self lm))

(defgeneric set-position (self &key &allow-other-keys))

(defgeneric show-markers (self))

(defgeneric toggle-marker-display (self))

(defgeneric translate-point (pt self &optional adjust outer?))

(defgeneric unmark-marker (self marker))

(defgeneric unselect-current-marker (self))


;;;;; 
;;;;;  The rest of HIP
;;;;;

(defparameter *perms* '(read write edit grant)
  "Read == browse; write == add nodes/links; edit == modify existing objects")

(defparameter $raw-node-types '(text table wip record image video))
		;; note that graphic isn't completed

;; $link-type-file is in headers/compat.cl

(defvar $raw-link-types nil)

(defvar *link-keyword-restrictions* nil
  "list of symbols used to filter set of links shown")

(defvar *node-type-selections* nil
  "list of node types being shown; used in filtering function")
(defvar *node-keyword-restrictions* nil
  "list of symbols used to filter set of nodes shown")

;;; Globals for collecting all the loaded objects:
(defvar *nodes*  (make-hash-table :test #'equal) "list of all existing nodes")
(defvar *links*  (make-hash-table :test #'equal) "list of all existing links")

;;;  May move this to slot on hyperdocs:
(defvar *history* nil
  "list of nodes visited this session")

;;;  Interface globals:
(defvar *num-panels* 3 "size of panel cache")
(defvar *current-hip-panel* nil)
(defvar *hip-panels* nil
  "cache of panels for use in displaying nodes")

(defvar *user* nil "current username")

;; default pathname to use when saving hyperdocument data:
;; *hyperdoc-info-directory* is in headers/compat.cl

;; I'm using this within methods to choose whether to call a widget or
;; just print some dummy text.  It gets set to t when hip.tool is loaded.
(defvar *widgets-loaded* nil)

(defvar *locked-image* nil)
(defvar *unlocked-image* nil)
(defvar *move-left-image* nil)
(defvar *move-right-image* nil)
(defvar *digraph-image* nil)
(defvar *return-arrow-image* nil)
(defvar *close-node-image* nil)
(defvar *default-link-image* nil)
(defvar *select-link-image* nil)

(defvar *text-node-size* nil)
(defvar *table-node-size* nil)
(defvar *video-node-size* nil)
(defvar *image-minimum-node-size* nil)
(defvar *explicit-close-node* nil)

;;;
;;; Default colors:
;;;
(defvar *panel-bg* nil)
(defvar *tool-bg*  nil)
(defvar *top-form-bg*  nil)
(defvar *dialog-bg* nil)
(defvar *alt-dialog-bg* nil)
(defvar *browser-bg* nil)
(defvar *unvisited-node-color* nil)
(defvar *visited-node-color* nil)
(defvar *link-color* nil)
(defvar *bookmark-color* nil)
(defvar *link-marker-color* nil)

(defvar *all-hip-colors* nil)

;;;
;;;  GCs for doing special drawing functions:

(defvar *bookmark-gc* nil)
(defvar *dashed-gc* nil)
(defvar *solid-gc* nil)

(defvar *owned* nil)
(defvar *hip-db* "hip::hip")
(defvar *hip-db-open* nil)

(defvar *wip-fields* '(log_type time step_path tag proc log))

(defparameter *db-types*        ;; second element of list should be owned?
  '((node nil)
    (text-node nil)
    (table-node nil)
    (proc-node nil)
    (wip-node nil)
    (video-node nil)
    (image-node nil)
    (node-set nil)
    (path nil)
    (node-record nil)
    (hyperdoc nil)
    (link nil)
    (marker nil)
    (link-marker nil)
    (bookmark nil)))


(defclass hyper-object (pmc dbobject) ())
(defclass owned-obj (pmc) ())
(defclass hyperdoc (node-set owned-obj) ())
(defclass link-type (pmc) ())
(defclass link (hyper-object) ())
(defclass marker (hyper-object) ())
(defclass bookmark (marker) ())
(defclass link-marker (marker) ())
(defclass node (hyper-object owned-obj) ())
(defclass text-node (node) ())
(defclass table-node (node) ())
(defclass image-node (node) ())
(defclass video-node (node) ())
(defclass graphic-node (node) ())
(defclass proc-node (node) ())
(defclass node-set (node) ())
(defclass path (node-set) ())
(defclass node-record (node) ())
(defclass wip-node (node-record) ())

(defgeneric action (self))
(defgeneric (setf action) (value self))

(defgeneric add-child-type (child parent))

(defgeneric add-obj (object node &optional detail))

(defgeneric add-perm (self uid perm))

(defgeneric add-perms (self uid perms))

(defgeneric bookmarks (self))
(defgeneric (setf bookmarks) (value self))

(defgeneric browse (self))

(defgeneric close-node (self))

(defgeneric dataset (self))
(defgeneric (setf dataset) (value self))

(defgeneric default-path (self))
(defgeneric (setf default-path) (value self))

(defgeneric description (self))
(defgeneric (setf description) (value self))

(defgeneric dest (self))
(defgeneric (setf dest) (value self))

(defgeneric displayed? (self))

(defgeneric draw-marker (m widget &optional outer?))

(defgeneric edit (self))

(defgeneric end-node (obj))

(defgeneric endpt (obj))
(defgeneric (setf endpt) (value obj))

(defgeneric fetch-wip-data (self))

(defgeneric fetch-wip-fields (self))

(defgeneric field-value (self name))

(defgeneric fields (obj))
(defgeneric (setf fields) (value obj))

(defgeneric filter-type (lt))

(defgeneric filtered? (obj))
(defgeneric (setf filtered?) (value obj))

(defgeneric follow (link &key dir))

(defgeneric followed? (obj))
(defgeneric (setf followed?) (value obj))

(defgeneric get-display-widget (node env))

(defgeneric (setf graph-box) (value obj))

(defgeneric has-access (user self perm))

(defgeneric has-keyword (self kwd))

(defgeneric has-type (self type))

(defgeneric hyperdocs (self))
(defgeneric (setf hyperdocs) (value self))

(defgeneric import-node (h n &key import-links by-copy))

(defgeneric last-visited (self))
(defgeneric (setf last-visited) (value self))

(defgeneric link-type (self))
(defgeneric (setf link-type) (value self))

(defgeneric keywords (self))
(defgeneric (setf keywords) (value self))

(defgeneric link-markers (self))
(defgeneric (setf link-markers) (value self))

(defgeneric links (self))
(defgeneric (setf links) (value self))

(defgeneric links-from (self))
(defgeneric (setf links-from) (value self))

(defgeneric links-into (self))
(defgeneric (setf links-into) (value self))

(defgeneric linkset (self))
(defgeneric (setf linkset) (value self))

(defgeneric lmark (self))

(defgeneric load-hyperdoc (self))

(defgeneric log-id (self))
(defgeneric (setf log-id) (value self))

(defgeneric make-label (self))

(defgeneric marker-area (self))

(defgeneric modified? (self))
(defgeneric (setf modified?) (value self))

(defgeneric modify (self))

(defgeneric node-summary (self))

(defgeneric nodes (self))
(defgeneric (setf nodes) (value self))

(defgeneric open-hyperdoc (h &optional make-current?))

(defgeneric open-marker (m &key in-link))

(defgeneric open-node (n &key offset opener))

(defgeneric opener (self))
(defgeneric (setf opener) (value self))

(defgeneric owner (self))
(defgeneric (setf owner) (value self))

(defgeneric paths (self))
(defgeneric (setf paths) (value self))

(defgeneric percent-complete (self))

(defgeneric perms (self))
(defgeneric (setf perms) (value self))

(defgeneric preview (self))

(defgeneric remove-child-type (child parent))

(defgeneric remove-from-hyperdocs (object docs &key &allow-other-keys))

(defgeneric remove-obj (object node &optional detail))

(defgeneric remove-perm (self uid perm))

(defgeneric remove-perms (self uid perms))

(defgeneric rename (self name))

(defgeneric run-id (self))
(defgeneric (setf run-id) (value self))

(defgeneric satisfies-keyword-filter (obj))

(defgeneric satisfies-type-filter (obj))

(defgeneric select-hyperdoc (self))

(defgeneric set-dest (link dest))

(defgeneric set-link-type (link type))

(defgeneric set-parent (link par))

(defgeneric set-source (link src))

(defgeneric source (self))
(defgeneric (setf source) (value self))

(defgeneric stamp (self))

(defgeneric start-node (self))
(defgeneric (setf start-node) (value self))

(defgeneric store (self))

(defgeneric timestamp (self))
(defgeneric (setf timestamp) (value self))

(defgeneric type (obj))

(defgeneric unfilter-type (lt))

(defgeneric unmodify (self))

(defgeneric unstore (self))

(defgeneric unvisit (self))

(defgeneric update (self values))

(defgeneric videodisk (self))
(defgeneric (setf videodisk) (value self))

(defgeneric viewer (self))
(defgeneric (setf viewer) (value self))

(defgeneric visible-markers (self))

(defgeneric visit (self))

(defgeneric visited? (self))
(defgeneric (setf visited?) (value self))

(defgeneric wipe-out (self))

(defgeneric write-hyperdoc (self))

(defgeneric write-node (self))

;; WITH-FEEDBACK show the message provided while the body is executed,
;; then clears the message window:
(defmacro with-feedback (msg &body body)
  `(progn
     (feedback ,msg)
     ,@body
    ;; (sleep 10)
     (feedback "OK")))

;;;   Since it doesn't make sense to create a generic node, MAKE-NODE
;;;   dispatches on node type. Thus, at this point, adding a new node
;;;   type necessitates installing it here and writing the appropriate
;;;;  make-XXX-node function.
(defmacro make-node (node-type &rest args)
  "dispatches on node-type to specific node creation functions"
  `(case ,node-type
         (text (make-text-node ,@args))
         (table (make-table-node ,@args))
         (proc (make-proc-node ,@args))
         (wip (make-wip-node ,@args))
         (graphic (make-graphic-node ,@args))
         (image (make-image-node ,@args))
         (record (make-node-record ,@args))
         (video (make-video-node ,@args))
        ;; ...and whatever else...
         (otherwise (error "Make-node: Unknown node type ~a" ,node-type))))

(defmacro current-p (panel)
  `(eq ,panel *current-hip-panel*))

(defmacro node-in-use (node)
  `(member ,node (nodes-in-use)))

