;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: chungl $
;;; $Source: /pic2/picasso/src/toolkit/base/RCS/root-window.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1992/01/11 00:02:30 $
;;;

(in-package "PT")

;;;
;;; root-window class
;;;

(defclass root-window (variable-holder opaque-window collection-gadget)
  ((screen
    :initform nil
    :type screen
    :reader screen)
   (active-lexical-children
    :initform nil
    :type list
    :accessor active-lexical-children)
   (name :initform "Root Window")
   (parent :initform nil)
   (status :initform :exposed)
   (event-mask :initform '( :no-event ))
   (x-offset :initform 0)
   (y-offset :initform 0)
   (width :initform 0)
   (height :initform 0)
   (border-width :initform 0)
   (cursor :initform nil)
   (border :initform nil)
   (background :initform nil)
   (foreground :initform nil)
   (inverted-background :initform nil)
   (inverted-foreground :initform nil)
   (dimmed-background :initform nil)
   (dimmed-foreground :initform nil)
   (gm :initform 'root-gm)
   (repack-flag :initform t)))

(defun make-root-window (&rest keys)
  (apply #'make-instance 'root-window :allow-other-keys t keys))

;;;
;;; root-window initialization method
;;;

(defmethod new-instance ((self root-window)
			 &key
			 (cursor nil)
			 &allow-other-keys)
  ;; set instance slots which require side-effects
  (setf (name self) (name self) 
	(event-mask self) (event-mask self))
  ;; test if cursor is null
  (if (not (null cursor))
      ;; set the root-window cursor
      (setf (cursor self) cursor))
  self)

(defmethod do-attach ((self root-window))
  (let ((screen (screen self))
	rs
	)
       (unless (attached-p screen) (attach screen))
       (setq rs (res screen))
       (setf (slot-value self 'res)
	     (xlib:screen-root rs))
       (setf (slot-value self 'width) 
	     (xlib:screen-width rs))
       (setf (slot-value self 'height) 
	     (xlib:screen-height rs))
       (setf (slot-value self 'colormap) 
	     (make-colormap :window self 
			    :res (xlib:window-colormap (res self))))
       )
  ;; add instance to hash table
  ;; display needs to be attached.
  (append-window self)
  self)

;;;
;;; root-window slot setf methods
;;;

(defmethod (setf x-offset) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the x-offset of a root window"))

(defmethod (setf y-offset) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the y-offset of a root window"))

(defmethod (setf width) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the width of a root window"))

(defmethod (setf height) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the height of a root window"))

(defmethod (setf status) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the status of a root window"))

;;;
;;; root-window operation methods
;;;

(defmethod do-conceal ((self root-window) &key
	
				       &allow-other-keys)
  (warn "Can't conceal a root window")) 

(defmethod conceal-transparent ((self root-window))
  (warn "Can't conceal-transparent a root window")) 

(defmethod do-detach ((self root-window))
  (warn "detaching root window")
  (setf (slot-value self 'res) nil)
  )

(defmethod do-repaint ((self root-window)
		       &key 
		       &allow-other-keys)
  nil)
