%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Konkrete SOWAM-Syntax -> Abstrakte SOWAM-Syntax
%
% Opalla/Korthaus/Alker (1990)
%
% Aenderungen:
%
% 22.02.90	Andreas Schwab
%		Konkrete Syntax erweitert:
%		Prozedurart wird mit pred, func, redu vor dem Prozedurlabel
%		markiert. Altes Format wird noch unterstuetzt.
%
% 09.10.91	Andreas Schwab
%		Max-X-Berechnung entfernt.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sowam_to_absy(FILE, CODE, MAINLISTE, EINSPRUNG) :-
    op(900,xfy,:),
    op(800,xfy,/),
    op(850,fx,pred),
    op(850,fx,func),
    op(850,fx,redu),
    c1_get_filename(FILE, DATEI),
    see(DATEI),
    c1_einlesen(IL, OL),
    seen,
    c1_new_struct(IL, CODE, MARKEN, 0),
    c1_strukt_liste(IL, LL),
    c1_vereinige(MARKEN, LL, LABELLISTE),
    c1_endg_verein(OL, LABELLISTE, MAINLISTE),
    c1_suche_goal(MAINLISTE, EINSPRUNG),
    op(600,xfy,:),
    op(400,yfx,/),
    op(0,fx,pred),
    op(0,fx,func),
    op(0,fx,redu),
    !.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    Grund-Prozeduren
c1_concat([],L,L).
c1_concat([E|R],L,[E|RL]) :-
    c1_concat(R,L,RL).

c1_append([],E,[E]).
c1_append([KOPF|REST],E,[KOPF|RestundE]) :-
    c1_append(REST,E,RestundE).

%     Haengt ggf. die Endung '.sow' an den Filenamen
c1_get_filename(FILE, DATEI) :-
    name(FILE, LISTE),
    c1_bis_punkt(LISTE, L),
    c1_concat(L, ".sow", LENDUNG),
    name(DATEI,LENDUNG).

%     gibt einen String bis zum ersten Punkt aus
c1_bis_punkt([], []).
c1_bis_punkt(".sow", []).
c1_bis_punkt([H|REST], [H|REST2]) :-
    c1_bis_punkt(REST, REST2).

 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 1. Schritt: Einlesen des Files
%   Beschreibung der meistgebrauchten Variablen
%
% IL  - Instruktions-Liste: liefert das Programm in Listenform
% OL  - Op_Typ_Liste: liefert die Liste der in der Funktion 'op_typ(X,Y)'
%       vorkommenden Label und Daten.

%       Liest das File ein
c1_einlesen(IL, OL) :-
    read(X),
    c1_is_befehl(X, AUSG),
    c1_make_list(AUSG, IL, OL).

%       Stellt die Listen der Befehle und der Op_Typen zusammen
c1_make_list(end_of_file, [], []) :-
    !.
c1_make_list(op_typ(X,Y,Z), IL, [[X,Y,Z]|OL]) :-
    !,
    c1_einlesen(IL, OL).
c1_make_list(AUSG, [AUSG|IL], OL) :-
    c1_einlesen(IL, OL).

%      Ueberprueft ob der Term ein korrekter Befehl ist
c1_is_befehl(end_of_file, end_of_file).
c1_is_befehl(op_typ(L/S,OT,PR), op_typ(L/S,OT,PR)) :-
    atom(L),
    integer(S),
    c1_is_op_typ(OT),
    integer(PR).
c1_is_befehl(pred(X/Y) : Z, pred(X/Y): Z2) :-
    atom(X),
    integer(Y),
    c1_is_2befehl(Z, Z2).
c1_is_befehl(func(X/Y) : Z, func(X/Y): Z2) :-
    atom(X),
    integer(Y),
    c1_is_2befehl(Z, Z2).
c1_is_befehl(redu(X/Y) : Z, redu(X/Y): Z2) :-
    atom(X),
    integer(Y),
    c1_is_2befehl(Z, Z2).
c1_is_befehl(X/Y : Z, X/Y : Z2) :-
    atom(X),
    integer(Y),
    c1_is_2befehl(Z, Z2).
c1_is_befehl(X : Z, X : Z2) :-
    atom(X),
    c1_is_2befehl(Z, Z2).
c1_is_befehl(X, AUSG) :-
    c1_is_ins(X, AUSG).
c1_is_befehl(X, fehler(X), 0) :-
    write('*** FEHLER *** : '),
    writeq(X),
    nl.

c1_is_2befehl(X : Z, X : Z2) :-
    atom(X),
    c1_is_2befehl(Z, Z2).
c1_is_2befehl(X, AUSG) :-
    c1_is_ins(X, AUSG).

%     Stellt fest, ob der eingelesene Term
%     im Instruktionssatz steht
c1_is_ins(switch_on_constant(Y, [H|T]), switch_on_constant(Y, L)) :-
    integer(Y),
    !,
    c1_2ctab_create([H|T], L).
c1_is_ins(switch_on_constant(X), switch_on_constant(Y, L)) :-
    !,
    c1_ctab_create(X, Y, L).
c1_is_ins(switch_on_structure(Y, [H|T]), switch_on_structure(Y, L)) :-
    integer(Y),
    !,
    c1_2stab_create([H|T], L).
c1_is_ins(switch_on_structure(X), switch_on_structure(Y, L)) :-
    !,
    c1_stab_create(X, Y, L).
c1_is_ins(push_act_occ, push_act_occ).
c1_is_ins(allocate, allocate).
c1_is_ins(deallocate, deallocate).
c1_is_ins(stop, stop).
c1_is_ins(call(X/Y, Z), call(X/Y, Z)) :-
    atom(X),
    integer(Y),
    integer(Z).
c1_is_ins(call_rewriting(ao,N), call_rewriting(ao,N)) :-
    integer(N).
c1_is_ins(call_narrowing(ao,N), call_narrowing(ao,N)) :-
    integer(N).
c1_is_ins(call_rewriting(X/Y), call_rewriting(X/Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(call_rewriting(X/Y,N), call_rewriting(X/Y,N)) :-
    atom(X),
    integer(Y),
    integer(N).
c1_is_ins(call_rewriting(ao), call_rewriting(ao)).
c1_is_ins(built_in(N), built_in(N)).
c1_is_ins(rebuild_occ_stack, rebuild_occ_stack).
c1_is_ins(execute(X/Y), execute(X/Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(execute_rewriting(X/Y), execute_rewriting(X/Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(proceed, proceed).
c1_is_ins(put_variable(X, Y), put_variable(OUT1, OUT2)) :-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(put_value(X, Y), put_value(OUT1, OUT2)) :-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(put_unsafe_value(X, Y), put_unsafe_value(OUT1, OUT2)):-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(put_constant(X, Y), put_constant(X, OUT)) :-
    atom(X),
    c1_arg_reg(Y, OUT),
    OUT = x(_).
c1_is_ins(put_nil(X), put_nil(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = x(_).
c1_is_ins(put_structure(X/Y, Z), put_structure(X/ Y, OUT)) :-
    atom(X),
    integer(Y),
    c1_arg_reg(Z, OUT).
c1_is_ins(put_list(X), put_list(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(get_variable(X, Y), get_variable(OUT1, OUT2)):-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(get_value(X, Y), get_value(OUT1, OUT2)):-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(get_constant(X, Y), get_constant(X, OUT)) :-
    atom(X),
    c1_arg_reg(Y, OUT),
    OUT = x(_).
c1_is_ins(get_nil(X), get_nil(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = x(_).
c1_is_ins(get_structure(X/Y,Z), get_structure(X/Y, OUT)) :-
    atom(X),
    integer(Y),
    c1_arg_reg(Z, OUT),
    OUT = x(_).
c1_is_ins(get_list(X), get_list(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = x(_).
c1_is_ins(match_variable(X, Y), get_variable(OUT1, OUT2)):-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(match_value(X, Y), match_value(OUT1, OUT2)):-
    c1_arg_reg(X, OUT1),
    c1_arg_reg(Y, OUT2),
    OUT2 = x(_).
c1_is_ins(match_constant(X, Y), match_constant(X, OUT)) :-
    atom(X),
    c1_arg_reg(Y, OUT),
    OUT = x(_).
c1_is_ins(match_nil(X), match_nil(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = x(_).
c1_is_ins(match_structure(X/Y,Z), match_structure(X/Y, OUT)) :-
    atom(X),
    integer(Y),
    c1_arg_reg(Z, OUT),
    OUT = x(_).
c1_is_ins(match_list(X), match_list(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = x(_).
c1_is_ins(unify_void(X), unify_void(X)) :-
    integer(X).
c1_is_ins(unify_variable(X), unify_variable(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(unify_value(X), unify_value(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(unify_local_value(X), unify_local_value(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(unify_constant(X), unify_constant(X)) :-
    atom(X).
c1_is_ins(unify_nil, unify_nil).
c1_is_ins(write_void(X), write_void(X)) :-
    integer(X).
c1_is_ins(write_variable(X), write_variable(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(write_value(X), write_value(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(write_local_value(X), write_local_value(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(write_constant(X), write_constant(X)) :-
    atom(X).
c1_is_ins(write_nil, write_nil).
c1_is_ins(read_void(X), read_void(X)) :-
    integer(X).
c1_is_ins(read_variable(X), read_variable(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(read_value(X), read_value(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(read_constant(X), read_constant(X)) :-
    atom(X).
c1_is_ins(read_nil, read_nil).
c1_is_ins(try_me_else(X, Y), try_me_else(X, Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(retry_me_else(X), retry_me_else(X)) :-
    atom(X).
c1_is_ins(trust_me_else_fail, trust_me_else_fail).
c1_is_ins(try(X, Y), try(X, Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(retry(X), retry(X)) :-
    atom(X).
c1_is_ins(trust(X), trust(X)) :-
    atom(X).
c1_is_ins(l_try_me_else(X, Y, Z), l_try_me_else(X, Y, Z)) :-
    atom(X),
    integer(Y),
    integer(Z).
c1_is_ins(l_trust_me_else_fail, l_trust_me_else_fail).
c1_is_ins(r_try_me_else(X), r_try_me_else(X)) :-
    atom(X).
c1_is_ins(r_retry_me_else(X), r_retry_me_else(X)) :-
    atom(X).
c1_is_ins(r_trust_me_else_fail, r_trust_me_else_fail).
c1_is_ins(r_try(X), r_try(X)) :-
    atom(X).
c1_is_ins(r_retry(X), r_retry(X)) :-
    atom(X).
c1_is_ins(r_trust(X), r_trust(X)) :-
    atom(X).
c1_is_ins(fail, fail).
c1_is_ins(reflection, reflection).
c1_is_ins(inner_reflection, inner_reflection).
c1_is_ins(switch_on_term(W,X,Y,Z), switch_on_term(W,X,Y,Z)) :-
    atom(W),
    atom(X),
    atom(Y),
    atom(Z).
c1_is_ins(load_occ(X), load_occ(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(push_occ(X), push_occ(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(pop_occ, pop_occ).
c1_is_ins(copy_pop_occ, copy_pop_occ).
c1_is_ins(allocate_occ, allocate_occ).
c1_is_ins(deallocate_occ, deallocate_occ).
c1_is_ins(invalid_os, invalid_os).
c1_is_ins(set_begin_of_term(X), set_begin_of_term(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(execute_narrowing(ao), execute_narrowing(ao)).
c1_is_ins(execute_rewriting(ao), execute_rewriting(ao)).
c1_is_ins(reject, reject).
c1_is_ins(put_var_occ(X), put_var_occ(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(put_value_occ(X), put_value_occ(OUT)) :-
    c1_arg_reg(X, OUT).
c1_is_ins(put_unsafe_value_occ(X), put_unsafe_value_occ(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = y(_).
c1_is_ins(put_const_occ(X), put_const_occ(X)) :-
    atom(X).
c1_is_ins(put_nil_occ, put_nil_occ).
c1_is_ins(put_struct_occ(X/Y), put_struct_occ(X/Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(put_function_occ(X/Y), put_function_occ(X/Y)) :-
    atom(X),
    integer(Y).
c1_is_ins(put_list_occ, put_list_occ).
c1_is_ins(write_and_ask(X), write_and_ask(OUT)) :-
    c1_arg_reg(X, OUT),
    OUT = x(_).

%      Stellt die Sprungtabelle bei 'switch_on_constant' zusammen
c1_ctab_create((STELL,REST), STELL, TABLE) :-
    integer(STELL),
    c1_ctab1_create(REST, TABLE).
c1_ctab1_create((ATOM,LABEL), [entry(ATOM, LABEL)]) :-
    atom(ATOM),
    atom(LABEL).
c1_ctab1_create((ATOM,LABEL,REST), [entry(ATOM, LABEL)|TABLE]) :-
    atom(ATOM),
    atom(LABEL),
    c1_ctab1_create(REST, TABLE).

%      Stellt die Sprungtabelle bei 'switch_on_structure' zusammen
c1_stab_create((STELL,REST), STELL, TABLE) :-
    integer(STELL),
    c1_stab1_create(REST, TABLE).
c1_stab1_create((STRUCT,LABEL), [entry(STRUCT, LABEL)]) :-
    STRUCT=(X/Y),
    atom(X),
    integer(Y),
    atom(LABEL).
c1_stab1_create((STRUCT,LABEL,REST), [entry(STRUCT, LABEL)|TABLE]) :-
    STRUCT=(X/Y),
    atom(X),
    integer(Y),
    atom(LABEL),
    c1_stab1_create(REST, TABLE).


%      Stellt alternativ die Sprungtabelle bei 'switch_on_constant' zusammen
c1_2ctab_create([], []).
c1_2ctab_create([ATOM, LABEL | REST], [entry(ATOM, LABEL)|TABLE]) :-
    atom(ATOM),
    atom(LABEL),
    c1_2ctab_create(REST, TABLE).

%      Stellt alternativ die Sprungtabelle bei 'switch_on_structure' zusammen
c1_2stab_create([], []).
c1_2stab_create([SNAME/STELL, LABEL | REST],
		[entry(SNAME/STELL,LABEL)|TABLE]) :-
    atom(SNAME),
    integer(STELL),
    atom(LABEL),
    c1_2stab_create(REST, TABLE).

%      Stellt fest ob es sich um ein Argument-Register handelt
c1_arg_reg(a(NR), x(NR)) :-			% Argument-Register
    integer(NR).
c1_arg_reg(X, x(NR)) :-
    atom(X),
    name(X, [65|REST]),				% 65 = 'a'
    name(NR, REST),
    integer(NR).
c1_arg_reg(x(NR), x(NR)) :-			% Temporaere-Variable
    integer(NR).
c1_arg_reg(X, x(NR)) :-
    atom(X),
    name(X, [88|REST]),				% 88 = 'x'
    name(NR, REST),
    integer(NR).
c1_arg_reg(y(NR), y(NR)) :-			% Permanente-Variable
    integer(NR).
c1_arg_reg(X, y(NR)) :-
    atom(X),
    name(X, [89|REST]),				% 89 = 'y'
    name(NR, REST),
    integer(NR).

%    Stellt fest ob es eine korrekte 'op_typ' Bezeichnung ist
c1_is_op_typ(nofix).
c1_is_op_typ(infixnot).
c1_is_op_typ(infixleft).
c1_is_op_typ(infixright).
c1_is_op_typ(prefix).
c1_is_op_typ(postfix).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     Unterteilt das Programm in Prozeduren 
c1_new_struct([], [], [], _).
c1_new_struct([pred(X/Y):Z|IL], NEWCODE, NEWMARKEN, NR) :-
    c1_new_struct1(X/Y, [Z|IL], pred, NEWCODE, NEWMARKEN, NR).
c1_new_struct([func(X/Y):Z|IL], NEWCODE, NEWMARKEN, NR) :-
    c1_new_struct1(X/Y, [Z|IL], func, NEWCODE, NEWMARKEN, NR).
c1_new_struct([redu(X/Y):Z|IL], NEWCODE, NEWMARKEN, NR) :-
    c1_new_struct1(X/Y, [Z|IL], rewr, NEWCODE, NEWMARKEN, NR).
c1_new_struct([X/Y:Z|IL], NEWCODE, NEWMARKEN, NR) :-
    c1_new_struct2(X/Y, [Z|IL], NEWCODE, NEWMARKEN, NR).
c1_new_struct(_, [], [], _) :-
    write('*** Start-Label fehlt *** : '),
    write('Alle weiteren Fehler koennen daraus resultieren!!!'),
    nl.

c1_new_struct1(MARKE, IL, ART, [proc(LBLNAME,PCOD)|CODE],
	       [[MARKE, LBLNAME, ART]|MARKEN], NR) :-
    c1_new_name(NR, LBLNAME),
    c1_new_proc(IL, RESTLISTE, PCOD),
%   write(X/Y), write(' - '), write(ART), nl,
    NEWNR is NR + 1,
    c1_new_struct(RESTLISTE, CODE, MARKEN, NEWNR).

c1_new_struct2(MARKE, IL, [proc(LBLNAME,PCOD)|CODE],
	       [[MARKE, LBLNAME, ART]|MARKEN], NR) :-
    c1_new_name(NR, LBLNAME),
    c1_new_proc(IL, RESTLISTE, PCOD),
    c1_new_art(PCOD, ART),
%   write(X/Y), write(' - '), write(ART), nl,
    NEWNR is NR + 1,
    c1_new_struct(RESTLISTE, CODE, MARKEN, NEWNR).

%     Liefert die naechste Prozedur
c1_new_proc([], [], []) :-
    !.
c1_new_proc([pred(X/Y):Z|IL], [pred(X/Y):Z|IL], []) :-
    !.
c1_new_proc([func(X/Y):Z|IL], [func(X/Y):Z|IL], []) :-
    !.
c1_new_proc([redu(X/Y):Z|IL], [redu(X/Y):Z|IL], []) :-
    !.
c1_new_proc([X/Y:Z|IL], [X/Y:Z|IL], []) :-
    !.
c1_new_proc([X|IL], RESTLISTE, [X|PCODE]) :-
    c1_new_proc(IL, RESTLISTE, PCODE).

%    Generiert einen neuen Label-Namen
c1_new_name(ZAHL, NAME) :-
    integer(ZAHL),
    !,
    S1 is ZAHL // 100 + 48,
    S2 is (ZAHL // 10) mod 10 + 48,
    S3 is ZAHL mod 10 + 48,
    name(NAME,[108, 104, 95, S1, S2, S3]).

%      Findet heraus welche Art von Prozedur vorliegt
c1_new_art(CODE, ART) :-			% as - 10.10.90
    c1_last_ins(CODE, INS),
    c1_new_art1(INS, ART).

c1_new_art1([], pred).
c1_new_art1(r_proceed_occ, rewr).
c1_new_art1(execute_rewriting(_), rewr).
c1_new_art1(inner_reflection, part).
c1_new_art1(execute(_), pred). 
c1_new_art1(proceed, pred). 
c1_new_art1(proceed_occ, func).
c1_new_art1(execute_narrowing(_), func).
c1_new_art1(stop, pred).
c1_new_art1(fail, pred).

c1_last_ins([_:X | RESTCODE], INS) :-
    !, c1_last_ins([X|RESTCODE], INS). 
    c1_last_ins([INS],INS) :- !.
c1_last_ins([_|RESTCODE], INS) :-
    c1_last_ins(RESTCODE, INS).
c1_last_ins([],[]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     Liefert die Liste aller aufgerufenen Strukturen
c1_strukt_liste([], []).
c1_strukt_liste([_:Z | RESTCODE], LL) :-
    c1_strukt_liste([Z|RESTCODE], LL).
c1_strukt_liste([Z|RESTCODE], NEWLL) :-
    c1_struktur_drin(Z, STL),
    c1_strukt_liste(RESTCODE, LL),
    c1_concat(STL, LL, NEWLL).

%      Liefert alle Strukturen in einem Befehl
c1_struktur_drin(put_structure(X/Y, _), [[X/Y, '_', cons]]).
c1_struktur_drin(get_structure(X/Y, _), [[X/Y, '_', cons]]).
c1_struktur_drin(put_struct_occ(X/Y), [[X/Y, '_', cons]]).

c1_struktur_drin(put_constant(X, _), [[X/0, '_', cons]]).
c1_struktur_drin(get_constant(X, _), [[X/0, '_', cons]]).
c1_struktur_drin(unify_constant(X), [[X/0, '_', cons]]).
c1_struktur_drin(put_const_occ(X), [[X/0, '_', cons]]).

c1_struktur_drin(call(X/Y, _), [[X/Y, '_', pred]]).
c1_struktur_drin(execute(X/Y), [[X/Y, '_', pred]]).
c1_struktur_drin(switch_on_structure(_,L), STL) :-
    c1_look_table(L, STL).
c1_struktur_drin(switch_on_constant(_,L), STL) :-
    c1_look_ctable(L, STL).
c1_struktur_drin(_, []).

%     Liefert alle Strukturen eines switch_on_structure-Befehls
c1_look_table([], []).
c1_look_table([[X/Y,_]|REST], [[X/Y, '_', cons]|STL]) :-
    c1_look_table(REST, STL).

%     Liefert alle Strukturen eines switch_on_constant-Befehls
c1_look_ctable([], []).
c1_look_ctable([[X,_]|REST], [[X/0, '_', cons]|STL]) :-
    c1_look_ctable(REST, STL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%      Vereinigt Marken und Strukturen zu einer Liste
c1_vereinige(MARKEN, [], MARKEN).
c1_vereinige(MARKEN, [[X, '_', pred]|LL], OUTLIST) :-
    c1_pruefe_pred(X, MARKEN, JN),
    c1_write_fehler(JN, X),
    c1_vereinige(MARKEN, LL, OUTLIST).
c1_vereinige(MARKEN, [[X, '_', cons]|LL], OUTLIST) :-
    c1_pruefe_cons(X, MARKEN, JN),
    c1_hvereinige(JN, [X, '_', cons], MARKEN, NEUMARKEN),
    c1_vereinige(NEUMARKEN, LL, OUTLIST).
c1_vereinige(MARKEN, [X|LL], OUTLIST) :-
    write('Fehler: '), write(X), nl,
    c1_vereinige(MARKEN, LL, OUTLIST).

c1_hvereinige(ja, _, MARKEN, MARKEN).
c1_hvereinige(nein, X, MARKEN, [X|MARKEN]).

c1_write_fehler(ja, _).
c1_write_fehler(nein, X) :-
    write('***FEHLER***: undefiniertes Praedikat: '),
    writeq(X),
    write(' wird aufgerufen ***'),
    nl.

%      Prueft ob das Predikat in der Liste ist
c1_pruefe_pred(X, [[X,_,pred]|_], ja).
c1_pruefe_pred(X, [[_,_,_]|LISTE], JN) :-
    c1_pruefe_pred(X, LISTE, JN).
c1_pruefe_pred(_, [], nein).

%      Prueft ob die Struktur in der Liste ist
c1_pruefe_cons(X, [[_,_,pred]|LISTE], JN) :-
    c1_pruefe_cons(X, LISTE, JN).
c1_pruefe_cons(X, [[X,_,_]|_], ja).
c1_pruefe_cons(X, [[_,_,_]|LISTE], JN) :-
    c1_pruefe_cons(X, LISTE, JN).
c1_pruefe_cons(_, [], nein).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     Vereinigung der Op_Typ-Liste mit der Liste aller Label
c1_endg_verein([], [], []).
c1_endg_verein([], [[X, HL, HART]|LABELLISTE], [FE|MAINLISTE]) :-
    write('Warnung: undefiniertes Label: '),
    write(X),
    nl,
    c1_hole(X, [], ART, [[X, HL, HART]|LABELLISTE], NEWLLISTE),
    c1_endg_verein([], NEWLLISTE, MAINLISTE),
    FE = entry(X, ART, nofix, -1).
c1_endg_verein([[X, OPTYP, PREC]|OL], LABELLISTE, [FE|MAINLISTE]) :-
    c1_hole(X, [], ART, LABELLISTE, NEWLLISTE),
    c1_endg_verein(OL, NEWLLISTE, MAINLISTE),
    FE = entry(X,ART,OPTYP,PREC).

%      Alle vorkommen des Labels werden aus der Label-Liste geholt
c1_hole(X, H, ART, [], []) :-
    c1_bestimme(X, H, ART).
c1_hole(X, H, ART, [[X,LBL,FA]|LABELLISTE], NEWLISTE) :-
    c1_hole(X, [FA,LBL|H], ART, LABELLISTE, NEWLISTE).
c1_hole(X, H, ART, [Y|LABELLISTE], [Y|NEWLLISTE]) :-
    c1_hole(X, H, ART, LABELLISTE, NEWLLISTE).

%      Festlegung des Prozedurtyps
c1_bestimme(_, [], cons).
c1_bestimme(_, [cons, _], cons).
c1_bestimme(_, [pred, L1], pred(L1)).
c1_bestimme(_, [pred, L1, cons, _], pred(L1)). % wegen write_and_ask
c1_bestimme(_, [cons, _, pred, L1], pred(L1)). % wegen write_and_ask
c1_bestimme(X,[func, L1], func(L1,'FEHLER')) :-
    write('***FEHLER***: rewrite-label fehlt zu '),
    writeq(X), nl.
c1_bestimme(X, [part, L1], func(L1,'FEHLER')) :-
    write('***FEHLER***: rewrite-label fehlt zu '),
    writeq(X), nl.

% Das ist ein falscher Fehler - (as)
%c1_bestimme(X, [rewr, L1], func('FEHLER',L1)) :-
%  write('***FEHLER***: Narrowing-label fehlt zu '),
%  writeq(X), nl.

c1_bestimme(_, [rewr, L1], rewr(L1)).
c1_bestimme(_, [func, L1, rewr, L2], func(L1, L2)).
c1_bestimme(_, [rewr, L2, func, L1], func(L1, L2)).
c1_bestimme(_, [part, L1, rewr, L2], func(L1, L2)).
c1_bestimme(_, [rewr, L2, part, L1], func(L1, L2)).
c1_bestimme(_, [rewr, L2, pred, L1], func(L1, L2)).
c1_bestimme(_, [pred, L1, rewr, L2], func(L1, L2)).
c1_bestimme(X, L, cons) :-
    write('***FEHLER***: unstimmige Label zu '),
    writeq(X), 
    write(' : '),
    writeq(L),
    nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     Ueberprueft ob ein goal vorhanden ist
c1_suche_goal([], nicht_vorhanden) :-
    write('***FEHLER***: Kein Goal ist angegeben'),
    nl.
c1_suche_goal([entry(the_goal/0, pred(X), _, _)|_], X).
c1_suche_goal([_|MAINLISTE], EINSPRUNG) :-
    c1_suche_goal(MAINLISTE, EINSPRUNG).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
