DEFS = -DSTRERROR_MISSING -DPILS
CFLAGS	= $(OPT) $(DEBUG) $(STAT) $(WARN) $(PROFILE) $(DEFS)
LDFLAGS = -g $(PROFILE)

srcs =	sowam.c interp.c funcs.c builtins.c output.c debug.c unify.c \
	plread.c plprintf.c version.c streams.c af-area.c alf-string.c \
	bytecode.c

objs =	sowam.o builtins.o debug.o funcs.o interp.o output.o unify.o \
	plread.o plprintf.o streams.o af-area.o alf-string.o bytecode.o

objs1 =	version.o getopt.o getopt1.o

incs =	sowam.h std.h macros.h proto.h types.h debug.h builtins.h plprintf.h \
	plrdwr.h plstd.h prologdef.h streams.h global.h machine.h af-area.h \
	bytecode.h

$(PROG): $(objs) $(objs1)
	$(CC) $(LDFLAGS) $^ $(LDLIBS) -o $@

dump_byt: dump_byt.o version.o

$(objs):	sowam.h machine.h types.h std.h macros.h

getopt.o :	getopt.h
getopt1.o :	getopt.h

af-area.o:	af-area.h bytecode.h
sowam.o:	getopt.h af-area.h
interp.o:	debug.h
debug.o:	debug.h
builtins.o:	builtins.h plread.h streams.h af-area.h
output.o:	plread.h streams.h
plread.o:	prologdef.h plstd.h plrdwr.h plprintf.h
plprintf.o:	prologdef.h plstd.h plprintf.h
streams.o:	streams.h
bytecode.o:	bytecode.h

TAGS: $(incs) $(srcs)
	etags -tw $^

.PHONY: clean realclean

clean:
	$(RM) $(objs) $(objs1)

realclean: clean
	$(RM) $(PROG) dump_byt core TAGS
