/*
 *
 *	sowam
 *		Bytecode-Interpreter fuer die SOWAM
 *
 *
 *	FILE
 *		alf-string.c
 *
 *	PURPOSE
 *		Stringverwaltung
 *		
 *
 *
 *	AUTHORS
 *		Andreas Schwab
 *
 */

#include <string.h>
#include <stdio.h>
#include "sowam.h"

static char *string_buffer = NULL;
static int string_buffer_length = 0;
static void init_string_buffer PROTO((void));

int
read_line(f)
     FILE *f;
{
  int c;
  int i = 0;

  if (string_buffer == NULL)
    init_string_buffer();
  while ((c = fgetc(f)) != EOF && c != '\n')
    {
      if (i >= string_buffer_length-1)
	{
	  string_buffer_length += 80;
	  string_buffer = xrealloc(string_buffer, string_buffer_length);
	}
      string_buffer[i++] = c;
    }
  if (c == EOF && i == 0)
    fail();
  string_buffer[i++] = 0;
  return lookup_symbol(string_buffer, 0);
}

/* Erzeugt eine Liste aus den Zeichen im String s */
term
explode_string(s)
     char *s;
{
  term result;
  term *t = &result;
  char character[2];

  character[1] = 0;
  CHECK_HEAP(2 * strlen(s));
  while (*s)
    {
      SET_TERM(*t, T_LIST, s_regs.h);
      character[0] = *s++;
      SET_CONST(s_regs.h[0], lookup_symbol(character, 0));
      t = &s_regs.h[1];
      s_regs.h += 2;
    }
  SET_CONST(*t, NIL);
  return result;
}

/* Concateniert eine Liste von Strings */
int
implode_string(list)
     term *list;
{
  term *string;
  char *name;
  int len, last_len;

  if (string_buffer == NULL)
    init_string_buffer();
  last_len = 0;
  string_buffer[0] = '\0';
  while (TAG(*list) == T_LIST)
    {
      string = &REF(*list);
      DEREF_TERMP(string);
      if (ATOM(*string)) {
	name = AF_NAME(VAL(*string));
	len = strlen(name);
	if (last_len + len >= string_buffer_length)
	  {
	    string_buffer_length += len + 1;
	    string_buffer = xrealloc(string_buffer, string_buffer_length);
	  }
	strcpy(string_buffer + last_len, name);
	last_len += len;
      }
      else
	runtime_error("string list expected in 'stringChars'");
      list = &TAIL(*list);
      DEREF_TERMP(list);
    }
  if (!ISNIL(*list))
    runtime_error("string list expected in 'stringChars'");

  return lookup_symbol(string_buffer, 0);
}

static void
init_string_buffer()
{
  string_buffer_length = 80;
  string_buffer = xmalloc(80);
}
