
/*
 *
 *	sowam_c
 *		Bytecode-Interpreter fuer die SOWAM
 *
 *
 *	FILE
 *		macros.h
 *
 *	PURPOSE
 *		verschiedene Macro-Definitionen
 *		
 *
 *
 *	AUTHORS
 *		Mike Wilhelm, Frank Lindert, Volker Siebert, Andreas Schwab
 *
 */



/* 
 * Zugriffsmakros auf die Speicherbereiche 
 */

#define BACK(x)		((struct backtrack *)(x))
#define BACKB		s_regs.b
#define ENVIRON		s_regs.e
#define X_REG(x)	(s_xregs[(x)-1])
#define Y_REG(x)	(s_regs.e->env_y[(x)-1])
#define CODE(p)		((code_addr)(p))

#define IS_LS_ADDR(x)	((x) >= INDEX(LS_MIN))

#define AF_ENTRY(f)	(b_af_area[A_F(f)])
#define AF_NAME(f)	(AF_ENTRY(f).text_addr)
#define AF_PRED(f)	(AF_ENTRY(f).pred_addr)
#define AF_NARROW(f)	(AF_ENTRY(f).narrow_addr)
#define AF_REWRITE(f)	(AF_ENTRY(f).rewrite_addr)
#define AF_ARITY(f)	(AF_ENTRY(f).arity)
#define AF_OPTYPE(f)	(AF_ENTRY(f).op_type)
#define AF_PRIORITY(f)	(AF_ENTRY(f).prio)

#define ISNIL(t)	(TAG(t) == T_AF && VAL(t) == NIL)
#define ISLIST(t)	(TAG(t) == T_LIST || ISNIL(t))
#define ATOM(t)		(TAG(t) == T_AF && ARITY(VAL(t)) == 0)
#define ISREF(t)	(TAG(t) != T_AF)

#define IS_FUNCTION(t)	(AF_REWRITE(VAL(t)) != NULL)

#define SET_CONST(t,i)	(SET_LOC(t,SKEL), SET_TAG(t,T_AF), SET_VAL(t,i))
#define SET_ECONST(t,i)	(SET_LOC(t,ENV), SET_TAG(t,T_AF), SET_VAL(t,i))

#define SET_TERM(t,tag,ref) \
  (SET_LOC(t,SKEL), SET_TAG(t,tag), SET_VAL(t,INDEX(ref)))
#define SET_ETERM(t,tag,ref) \
  (SET_LOC(t,ENV), SET_TAG(t,tag), SET_VAL(t,INDEX(ref)))

#define HP_MIN		b_hp_ls
#define HP_MAX		hp_end
#define LS_MIN		hp_end
#define LS_MAX		ls_end
#define OS_MIN		b_occ_stk
#define OS_MAX		os_end
#define TRL_MIN		b_trail
#define TRL_MAX		trail_end

#define OCC_SIZE(p)	((p)->occ_om - (p)->occ_os)
#define OANZ            (s_regs.om - s_regs.op->occ_os)

#ifdef STAT
#define CHECK_HEAP(n) \
  (s_regs.h + (n) > heap_used && \
   (heap_used = s_regs.h + (n)) > HP_MAX ? (hp_overflow(), 0) : 0)

#define CHECK_TRAIL() \
  (s_regs.t - 1 < trail_used && \
   (trail_used = s_regs.t - 1) <= TRL_MIN ? (trl_overflow(), 0) : 0)

#define CHECK_LS(top_ls) \
  ((top_ls) > ls_used && \
   (ls_used = (top_ls)) > LS_MAX ? (ls_overflow(), 0) : 0)

#define CHECK_OS(n) \
  (s_regs.om + (n) >= s_regs.or ? (os_overflow(), 0) : \
   (s_regs.om + (n) > os_used ? (os_used = s_regs.om + 1, 0) : 0))

#else /* !STAT */

#define CHECK_HEAP(n)	(s_regs.h + (n) > HP_MAX ? (hp_overflow(), 0) : 0)
#define CHECK_TRAIL()	(s_regs.t-1 <= TRL_MIN ? (trl_overflow(), 0) : 0)
#define CHECK_LS(top)	(top > LS_MAX ? (ls_overflow(), 0) : 0)
#define CHECK_OS(n)	(s_regs.om + (n) >= s_regs.or ? (os_overflow(), 0) : 0)

#endif /* STAT */

#define CHECK_TA(n)	(ta_ptr + (n) > ta_end ? (af_overflow(), 0) : 0)

#define CHANGE_ENV(t)		(SET_LOC(t, ENV))
#define CHANGE_ET(t)		(TAG(t) == T_UNDEF ? SET_TAG(t, T_VAR) : 0)
#define CHANGE_ET_ENV(t)	(CHANGE_ENV(t), CHANGE_ET(t))

#define polymorph_unequal(x,y)		((x) != (y))

#define UNBINDABLE(v)	(VAL(v) >= INDEX(LS_MIN) ? VAL(v) < INDEX(s_regs.r) :\
			 VAL(v) < INDEX(s_regs.hr))

#define isizeof(x)	(sizeof(x)/sizeof(void *))

#define POP_OCC()	(s_regs.ao = (OANZ == 0) ? UNDEF : *--s_regs.om)

#define TRUST_ME_ELSE_FAIL()  (s_regs.b = BACKB->bt_regs.b)

#define TOP_LS() \
  (((term *)s_regs.e < (term *)s_regs.b) ? (term *)(s_regs.b + 1) : \
   (s_regs.cp == 0) ? LS_MIN : &Y_REG(OP2ARG(s_regs.cp[-3])+1))

#define PUSH_B(n_args,top_ls) \
{ \
  struct backtrack *back; \
  int occ_size = OANZ + isizeof(struct occ_stack) - 1; \
  CHECK_LS(top_ls + occ_size + (n_args) + isizeof(struct backtrack)); \
  bcopy(s_regs.op, top_ls, occ_size * sizeof(term *)); \
  bcopy(&X_REG(1), top_ls + occ_size, (n_args) * sizeof(term)); \
  back = BACK(top_ls + occ_size + (n_args)); \
  back->bt_anz = (n_args); \
  back->bt_regs = s_regs; \
  back->bt_flags = s_flags; \
  s_regs.b = back; \
}

#define DEREF_TERM(x) \
{ \
  while (TAG(x) == T_VAR || \
	 (TAG(x) == T_STRUCT && \
	  (TAG(REF(x)) != T_AF || ARITY(VAL(REF(x))) == 0))) \
    (x) = REF(x); \
}

#define DEREF1_TERM(x) \
{ \
  while (TAG(x) == T_VAR || \
	 (TAG(x) == T_STRUCT && TAG(REF(x)) != T_AF)) \
    (x) = REF(x); \
}

#define DEREF_TERMP(t) \
{ \
  while (TAG(*(t)) == T_VAR || TAG(*(t)) == T_STRUCT) \
    (t) = &REF(*(t)); \
}

#define DEREF_AO() \
{ \
  if (s_regs.ao != UNDEF) \
    DEREF_TERMP(s_regs.ao); \
}

#define TRAIL_AO() \
{ \
  if (BACKB != 0 && s_regs.ao < BACKB->bt_regs.h) \
    PUSH_TRL_ENTRY(s_regs.ao); \
}

#define PUSH_OS_ENTRY(adr) \
{ \
  CHECK_OS(1); \
  *s_regs.om++ = (adr); \
}

#define PUSH_TRL_ENTRY(adr) \
{ \
  CHECK_TRAIL(); \
  s_regs.t--; \
  s_regs.t->trl_addr = (adr); \
  s_regs.t->trl_cont = *(adr); \
}
