/*
 *
 *	sowam
 *		Bytecode-Interpreter fuer die SOWAM
 *
 *
 *	FILE
 *		prologdef.h
 *
 *	PURPOSE
 *		Definitionen fuer den Prolog-Reader
 *		
 *
 *
 *	AUTHORS
 *		Volker Siebert, Andreas Schwab
 *
 */

#include "sowam.h"
#include "builtins.h"

#define MALLOC	xmalloc
#define REALLOC	xrealloc
#define FREE	free
#define BSTRING
#define STATIC	static

#define prolog_getchar()	getc(read_file)
#define prolog_putchar(c)	putc((c),stderr)

#define STRING_SPECIAL		1
#define C_STYLE_COMMENTS	1
#define CONVERT_DOT_TO_LIST	0

#define create_eof(term)	SET_CONST(*(term), EOF_SYM)
#define create_atom(r,n)	create_term((r),(n),CONST_SYM)
#define create_string(r,n)	create_term((r),(n),STR_SYM)
#define create_variable(r,n)	create_term((r),(n),VAR_SYM)
#define get_operator_type(name,prec,type) \
    lookup_operator(lookup_symbol((name),0),(prec),(type))

#define TERM term

extern FILE *read_file;
