/*
 *	types.h
 *		Typdefinitionen fuer den SOWAM Bytecode Interpreter
 *
 *	History:
 *	[001]	FL,MW,VS - Register rfp & tfp eingefuegt
 */

/*
 * Typ eines Terms
 */

enum locs { SKEL, ENV };
enum tags { T_AF, T_UNDEF, T_VAR, T_LIST, T_STRUCT };

#ifdef SMALL_MEM
#define TAG_BITS 7
#define VAL_BITS 24
#else
#define TAG_BITS 3
#define VAL_BITS 28
#endif

typedef struct {
#ifndef NO_ENUM_BITFIELD
    enum locs loc: 1;
    enum tags tag: TAG_BITS;
#else
    unsigned loc: 1;
    unsigned tag: TAG_BITS;
#endif
    unsigned val: VAL_BITS;
} term;


/*
 * Zugriffsmakros und Werte der Teile eines Terms
 */
#define LOC(t)		((t).loc)
#define TAG(t)		((t).tag)
#define VAL(t)		((t).val)
#define SET_LOC(t,x)	((t).loc = (x))
#define SET_TAG(t,x)	((t).tag = (x))
#define SET_VAL(t,x)	((t).val = (x))

#define INDEX(x)	((long)(x))
#define ARITY(f)	((f >> 16) & 0xff)
#define A_F(f)		(f & 0xffff)
#define REF(t)		(*(term *)VAL(t))
#define SET_REF(t,r)	SET_VAL(t,INDEX(r))
#define AF_ARG(t,n)	(((term *)VAL(t))[n])
#define TAIL(t)		(((term *)VAL(t))[1]) /* falls TAG(t) == T_LIST */

typedef char flag;
typedef WORD *code_addr;

/*
 * Register der SOWAM, die im Backtrackpunkt gespeichert werden
 */
struct registers {
    struct environment *e;
    struct environment *re;	/* doch hier (VS) */
    code_addr cp;
    struct backtrack *b;
    term *r;
    code_addr p;
    struct trail *t;
    term *h;
    code_addr tfp;		/* [001] */
    code_addr rfp;
    term *hr;
    term *ts;
    term *ao;
    struct occ_stack *op;
    term **om;
    term **or;
#ifdef DEBUG_BOX
    int p_box;
    int cp_box;
    int tfp_box;
    int rfp_box;
#endif
};

/*
 * Flags der SOWAM, die im Backtrackpunkt gespeichert werden
 */
struct flags {
    flag os_valid;
    flag rw;
};

/*
 * Register der SOWAM, die nicht im Backtrackpunkt gespeichert werden
 */
struct global_regs {
    term *sh;
    term *hb;
#ifdef DEBUG_BOX
    int	box_count;
#endif
};

/*
 * Flags der SOWAM, die nicht im Backtrackpunkt gespeichert werden
 */
struct global_flags {
    flag rew;
    flag error;
    flag occur_check;
    flag trace;
    flag debug;
};

struct backtrack {
    int bt_anz;
    struct registers bt_regs;
    struct flags    bt_flags;
};

struct environment {
    struct environment *env_e;
    code_addr env_cp;
#ifdef DEBUG_BOX
    int env_cpb;
#endif
    term *env_r;
    term *env_hr;
    term env_y[1];
};

struct occ_stack {
    struct occ_stack *occ_op;	/* Physikalischer Vorgaenger */
    struct occ_stack *occ_pred; /* Logischer Vorgaenger */
    code_addr occ_cp;
#ifdef DEBUG_BOX
    int occ_cpb;
#endif
    term **occ_om;		/* aktueller Wert von om */
    term **occ_or;
    term *occ_ts;		/* aktueller Wert von ts */
    term *occ_ao;		/*  "         "    "  ao */
    term *occ_os[1];
};

struct trail {
    term *trl_addr;
    term  trl_cont;
};

/*
 * Operatortypen
 */

enum operator {
  nonfix, prefix, postfix, infixnot, infixleft, infixright };

/*
 * Ein A/F-Eintrag
 */
struct af_entry {
  code_addr narrow_addr;
  code_addr rewrite_addr;
  code_addr pred_addr;
  char *text_addr;
  long arity;
  enum operator op_type;
  int prio;
};
