;;;
;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; $Id: create-event.sc,v 1.3 90/05/07 11:34:45 johani Exp $

;;; create-event.sc -- Enables assembling of events for the SendEvent request.
;;;                    Format of call: (create-event <symbol> (<data>)), where
;;;                    <symbol> is a symbolic representation of the event name
;;;                    (eg, 'ConfigureNotify) and <data> is the data to fill
;;;                    the event with. This should be given in the order stated
;;;                    in the protocol definition, leaving out any unused
;;;                    fields.

(module scixce)

(define-external lookup-constant scixutil)

(define event-codes '((keypress . 2) (keyrelease . 3)
		      (buttonpress . 4) (buttonrelease . 5)
		      (motionnotify . 6) (enternotify . 7)
		      (leavenotify . 8) (focusin . 9)
		      (focusout . 10) (keymapnotify . 11)
		      (expose . 12) (graphicsexposure . 13)
		      (noexposure . 14) (visibilitynotify . 15)
		      (createnotify . 16) (destroynotify . 17)
		      (unmapnotify . 18) (mapnotify . 19)
		      (maprequest . 20) (reparentnotify . 21)
		      (configurenotify . 22) (configurerequest . 23)
		      (gravitynotify . 24) (resizerequest . 25)
		      (circulatenotify . 26) (circulaterequest . 27)
		      (propertynotify . 28) (selectionclear . 29)
		      (selectionrequest . 30) (selectionnotify . 31)
		      (colormapnotify . 32) (clientmessage . 33)
		      (mappingnotify . 34) ))

;;; create-event -- Doesn't really do anything useful, just looks up the
;;;                 event-code. code s a symbol denoting the event, data
;;;                 a list of bytes to be sent. This is in no way the final
;;;                 version, a better one is being devised...
(define (create-event code data)
  (cons (lookup-constant code event-codes) data) )
