(define-constant defining-form
   (#!lambda (name)
      (#!if (memq name defining-forms) nil 
	  (set! defining-forms
	     (cons name defining-forms)))))

(undeclare-constant 'save-defining-form)

(define-constant save-defining-form
  (#!lambda (e)
    (#!if (atom? e) e
	  (#!if (atom? (car e))
		(#!if (memq (car e) defining-forms)
		      ((#!lambda (l)
			 ((#!lambda (id)
			    (#!if (constant? id)
				  (begin
				    (writeln
				      "[defining-form: " id " is a constant")
				    (writeln "It cannot be re-defined]")
				    (reset))
				  ((#!lambda (v)
				     (#!if v
				       ((#!lambda (p) (set-cdr! p l)) v)
				       (begin
					 (#!set! defined-forms
					   (cons (cons id l)
						 defined-forms)))))
				   (assq id defined-forms))))
			  (#!if (atom? (cadr l)) (cadr l) (caadr l))))
		       (copy e)))))
    e))

(defining-form 'define)
(defining-form 'define!)
;(defining-form 'macro)
;(defining-form 'mkmac)				; 1-Mar-85
(defining-form 'syntax)
(defining-form 'alias)
;(defining-form 'define-syntax)			; 1-Mar-85
;(defining-form 'define-syntax*)			; 1-Mar-85
;(defining-form 'define-syntax/keywords)		; 1-Mar-85
(defining-form 'declare-syntax)

